/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.mail;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class SMTPProfile {
    private final String id;
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;

    public SMTPProfile(@NotNull String id, @NotNull String hostname, int port, @NotNull String username, @NotNull String password) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public Authenticator createAuthenticator() {
        return new ProfileAuthenticator();
    }

    public void testConnection(@NotNull DBRProgressMonitor monitor) throws DBException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.hostname);
        properties.put("mail.smtp.port", (Object)this.port);
        properties.put("mail.smtp.auth", (Object)true);
        properties.put("mail.smtp.starttls.enable", (Object)true);
        try {
            Session session = Session.getInstance((Properties)properties, (Authenticator)this.createAuthenticator());
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Transport transport = session.getTransport((Address)new InternetAddress(this.username));){
                    monitor.beginTask("Connecting to SMTP server", 1);
                    transport.connect();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (MessagingException e) {
            throw new DBException("Error establishing SMTP connection", (Throwable)e);
        }
    }

    public String toString() {
        return String.valueOf(this.username) + " (" + this.hostname + ":" + this.port + ")";
    }

    private class ProfileAuthenticator
    extends Authenticator {
        private ProfileAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(SMTPProfile.this.username, SMTPProfile.this.password);
        }
    }
}

