/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SystemVariablesResolver
implements IVariableResolver {
    public static final SystemVariablesResolver INSTANCE = new SystemVariablesResolver();
    public static final String VAR_APP_NAME = "application.name";
    public static final String VAR_APP_VERSION = "application.version";
    public static final String VAR_APP_PATH = "application.path";
    public static final String VAR_WORKSPACE = "workspace";
    public static final String VAR_HOME = "home";
    public static final String VAR_DBEAVER_HOME = "dbeaver_home";
    public static final String VAR_LOCAL_IP = "local.ip";
    private static Properties configuration;

    public static void setConfiguration(Properties configuration) {
        SystemVariablesResolver.configuration = configuration;
    }

    @Override
    public String get(String name) {
        Object o;
        switch (name) {
            case "application.name": {
                return GeneralUtils.getProductName();
            }
            case "application.version": {
                return GeneralUtils.getProductVersion().toString();
            }
            case "home": {
                return SystemVariablesResolver.getUserHome();
            }
            case "workspace": {
                return SystemVariablesResolver.getWorkspacePath();
            }
            case "application.path": 
            case "dbeaver_home": {
                return SystemVariablesResolver.getInstallPath();
            }
            case "local.ip": {
                try {
                    return InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    return "127.0.0.1";
                }
            }
        }
        if (configuration != null && (o = configuration.get(name)) != null) {
            return o.toString();
        }
        String var = System.getProperty(name);
        if (var != null) {
            return var;
        }
        return System.getenv(name);
    }

    public static String getInstallPath() {
        return SystemVariablesResolver.getPlainPath(Platform.getInstallLocation().getURL());
    }

    public static String getWorkspacePath() {
        return SystemVariablesResolver.getPlainPath(Platform.getInstanceLocation().getURL());
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    private static String getPlainPath(URL url) {
        try {
            File file = RuntimeUtils.getLocalFileFromURL(url);
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            return url.toString();
        }
    }
}

