/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security.user;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;

public class SMUser {
    private final String userId;
    private final Map<String, String> metaParameters = new LinkedHashMap<String, String>();
    private boolean enabled = true;

    public SMUser(@NotNull String userId) {
        this.userId = userId;
    }

    public SMUser(@NotNull String userId, @NotNull Map<String, String> metaParameters) {
        this.userId = userId;
        this.metaParameters.putAll(metaParameters);
    }

    public SMUser(@NotNull String userId, boolean enabled) {
        this.userId = userId;
        this.enabled = enabled;
    }

    public SMUser(@NotNull String userId, @NotNull Map<String, String> metaParameters, boolean enabled) {
        this.userId = userId;
        this.metaParameters.putAll(metaParameters);
        this.enabled = enabled;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @NotNull
    public Map<String, String> getMetaParameters() {
        return this.metaParameters;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableUser(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMetaParameter(String name, String value) {
        this.metaParameters.put(name, value);
    }
}

