/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;

public class QMMTransactionSavepointInfo
extends QMMObject {
    private final QMMTransactionInfo transaction;
    private final String name;
    private boolean committed;
    private final QMMTransactionSavepointInfo previous;
    private QMMStatementExecuteInfo lastExecute;
    private transient DBCSavepoint reference;

    QMMTransactionSavepointInfo(QMMTransactionInfo transaction, DBCSavepoint reference, String name, QMMTransactionSavepointInfo previous) {
        this.transaction = transaction;
        this.reference = reference;
        this.name = name;
        this.previous = previous;
    }

    protected void close(boolean commit) {
        this.committed = commit;
        super.close();
        this.reference = null;
    }

    DBCSavepoint getReference() {
        return this.reference;
    }

    public QMMTransactionInfo getTransaction() {
        return this.transaction;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public QMMTransactionSavepointInfo getPrevious() {
        return this.previous;
    }

    public QMMStatementExecuteInfo getLastExecute() {
        return this.lastExecute;
    }

    void setLastExecute(QMMStatementExecuteInfo lastExecute) {
        this.lastExecute = lastExecute;
    }

    public Iterator<QMMStatementExecuteInfo> getExecutions() {
        return new Iterator<QMMStatementExecuteInfo>(){
            private QMMStatementExecuteInfo curExec;
            {
                this.curExec = QMMTransactionSavepointInfo.this.lastExecute;
            }

            @Override
            public boolean hasNext() {
                return this.curExec != null && this.curExec.getSavepoint() == QMMTransactionSavepointInfo.this;
            }

            @Override
            public QMMStatementExecuteInfo next() {
                if (this.curExec == null || this.curExec.getSavepoint() != QMMTransactionSavepointInfo.this) {
                    throw new NoSuchElementException();
                }
                QMMStatementExecuteInfo n = this.curExec;
                this.curExec = this.curExec.getPrevious();
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return "SAVEPOINT" + (this.name == null ? "" : this.name);
    }

    public boolean hasUserExecutions() {
        QMMStatementExecuteInfo exec = this.lastExecute;
        while (exec != null) {
            switch (exec.getStatement().getPurpose()) {
                case USER: 
                case USER_FILTERED: 
                case USER_SCRIPT: 
                case UTIL: 
                case META_DDL: {
                    return true;
                }
            }
            exec = exec.getPrevious();
        }
        return false;
    }

    @Override
    public String getText() {
        return this.transaction.getText();
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.getTransaction().getConnection();
    }
}

