/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.dbeaver.db.ycql.data.CasMapValue;
import com.dbeaver.db.ycql.data.CasSetValue;
import com.dbeaver.db.ycql.data.CasTupleValue;
import com.dbeaver.db.ycql.data.CasUDTValue;
import com.dbeaver.db.ycql.exec.CasSession;
import com.dbeaver.db.ycql.model.CasAbstractDataType;
import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasPrivilegeGrant;
import com.dbeaver.ee.model.content.DBContentByteBuffer;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class CasUtils {
    private static final Log log = Log.getLog(CasUtils.class);
    private static Field typeProtocolField;

    static {
        try {
            typeProtocolField = DataType.Name.class.getDeclaredField("protocolId");
            typeProtocolField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            log.debug((Object)e);
        }
    }

    public static int getTypeNameID(DataType type) {
        return CasUtils.getTypeNameID(type.getName());
    }

    public static int getTypeNameID(DataType.Name typeName) {
        if (typeProtocolField != null) {
            try {
                return (Integer)typeProtocolField.get(typeName);
            }
            catch (Exception e) {
                log.debug((Object)"Error reading type ID", (Throwable)e);
            }
        }
        return typeName.ordinal();
    }

    public static DBPDataKind getDataKind(DataType dataType) {
        return CasUtils.getDataKind(dataType.getName());
    }

    public static DBPDataKind getDataKind(DataType.Name typeName) {
        switch (typeName) {
            case BOOLEAN: {
                return DBPDataKind.BOOLEAN;
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return DBPDataKind.STRING;
            }
            case BIGINT: 
            case COUNTER: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case VARINT: 
            case SMALLINT: 
            case TINYINT: {
                return DBPDataKind.NUMERIC;
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return DBPDataKind.DATETIME;
            }
            case CUSTOM: 
            case UUID: 
            case TIMEUUID: 
            case INET: 
            case TUPLE: {
                return DBPDataKind.OBJECT;
            }
            case UDT: {
                return DBPDataKind.STRUCT;
            }
            case MAP: {
                return DBPDataKind.ARRAY;
            }
            case LIST: 
            case SET: {
                return DBPDataKind.ARRAY;
            }
            case JSONB: {
                return DBPDataKind.CONTENT;
            }
        }
        return DBPDataKind.BINARY;
    }

    public static String transformCQL(CasDataSource dataSource, String original, DBDDataFilter filter) {
        StringBuilder cql = new StringBuilder(original);
        if (filter != null && filter.hasConditions()) {
            cql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)cql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            cql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (boolean)false, (StringBuilder)cql);
        }
        return cql.toString();
    }

    public static Object wrapValue(DBCExecutionContext executionContext, String keyspace, Object value) throws DBCException {
        if (value instanceof ByteBuffer) {
            return new DBContentByteBuffer(executionContext, (ByteBuffer)value);
        }
        return value;
    }

    public static Object unwrapValue(Object value) {
        if (value instanceof DBContentByteBuffer) {
            return ((DBContentByteBuffer)value).getData();
        }
        if (value instanceof CasSetValue) {
            return ((CasSetValue)((Object)value)).makeSet();
        }
        if (value instanceof CasMapValue) {
            return ((CasMapValue)((Object)value)).makeMap();
        }
        if (value instanceof CasUDTValue) {
            return ((CasUDTValue)value).getRawValue();
        }
        if (value instanceof CasTupleValue) {
            return ((CasTupleValue)value).getRawValue();
        }
        return value;
    }

    @NotNull
    public static LocalDate toLocalDate(Date date) {
        return LocalDate.fromMillisSinceEpoch((long)(date.getTime() + (long)TimeZone.getDefault().getRawOffset()));
    }

    public static long toCasTime(Date date) {
        return (date.getTime() + (long)TimeZone.getDefault().getRawOffset()) * 1000000L;
    }

    public static CasAbstractDataType resolveDataType(DBRProgressMonitor monitor, CasDataSource dataSource, String keyspace, DataType dataType) throws DBException {
        if (dataType instanceof TupleType) {
            return dataSource.getCachedTupleType((TupleType)dataType);
        }
        if (dataType instanceof UserType) {
            return dataSource.getKeyspace(keyspace).getUserType(monitor, dataType);
        }
        return dataSource.getLocalDataType(dataType.toString());
    }

    public static List<CasPrivilegeGrant> readPermissions(DBRProgressMonitor monitor, CasDataSource dataSource, String query) throws DBCException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CasSession session = ((CasExecutionContext)dataSource.getDefaultContext(monitor, false)).openSession(monitor, DBCExecutionPurpose.UTIL, "Read privileges");){
            SimpleStatement privStat = new SimpleStatement(query);
            ResultSetFuture resultSetFuture = session.getImpl().executeAsync((Statement)privStat);
            try {
                ResultSet rows = (ResultSet)resultSetFuture.get();
                ArrayList<CasPrivilegeGrant> grants = new ArrayList<CasPrivilegeGrant>();
                for (Row row : rows.all()) {
                    String username = (String)row.get("username", String.class);
                    String resource = (String)row.get("resource", String.class);
                    List permissions = row.getList("permissions", String.class);
                    for (String permission : permissions) {
                        CasPrivilegeGrant grant = new CasPrivilegeGrant(dataSource, username, resource, permission);
                        grants.add(grant);
                    }
                }
                return grants;
            }
            catch (Throwable e) {
                throw new DBCException("Error reading privileges", e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

