/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.json4j;

import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.json4j.OrderedJSONObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Serializer {
    private Writer writer;

    public Serializer(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public Serializer writeRawString(String string) throws IOException {
        this.writer.write(string);
        return this;
    }

    public Serializer writeNull() throws IOException {
        this.writeRawString("null");
        return this;
    }

    public Serializer writeNumber(Number number) throws IOException {
        if (null == number) {
            return this.writeNull();
        }
        if (number instanceof Float) {
            if (((Float)number).isNaN()) {
                return this.writeNull();
            }
            if (Float.NEGATIVE_INFINITY == number.floatValue()) {
                return this.writeNull();
            }
            if (Float.POSITIVE_INFINITY == number.floatValue()) {
                return this.writeNull();
            }
        }
        if (number instanceof Double) {
            if (((Double)number).isNaN()) {
                return this.writeNull();
            }
            if (Double.NEGATIVE_INFINITY == number.doubleValue()) {
                return this.writeNull();
            }
            if (Double.POSITIVE_INFINITY == number.doubleValue()) {
                return this.writeNull();
            }
        }
        this.writeRawString(number.toString());
        return this;
    }

    public Serializer writeBoolean(Boolean bl2) throws IOException {
        if (null == bl2) {
            return this.writeNull();
        }
        this.writeRawString(bl2.toString());
        return this;
    }

    private String rightAlignedZero(String string, int n2) {
        if (n2 == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < n2) {
            stringBuilder.insert(0, '0');
        }
        return stringBuilder.toString();
    }

    public Serializer writeString(String string) throws IOException {
        if (null == string) {
            return this.writeNull();
        }
        this.writer.write(34);
        char[] cArray = string.toCharArray();
        block11: for (int i10 = 0; i10 < cArray.length; ++i10) {
            char c10 = cArray[i10];
            switch (c10) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block11;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block11;
                }
                case '\u0000': {
                    this.writer.write("\\0");
                    continue block11;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block11;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block11;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block11;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block11;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block11;
                }
                case '/': {
                    this.writer.write("\\/");
                    continue block11;
                }
                default: {
                    if (c10 >= ' ' && c10 <= '~') {
                        this.writer.write(c10);
                        continue block11;
                    }
                    this.writer.write("\\u");
                    this.writer.write(this.rightAlignedZero(Integer.toHexString(c10), 4));
                }
            }
        }
        this.writer.write(34);
        return this;
    }

    private Serializer write(Object object) throws IOException {
        if (null == object) {
            return this.writeNull();
        }
        if (object instanceof Number) {
            return this.writeNumber((Number)object);
        }
        if (object instanceof String) {
            return this.writeString((String)object);
        }
        if (object instanceof Boolean) {
            return this.writeBoolean((Boolean)object);
        }
        if (object instanceof JSONObject) {
            return this.writeObject((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return this.writeArray((JSONArray)object);
        }
        throw new IOException("Attempting to serialize unserializable object: '" + object + "'");
    }

    public Serializer writeObject(JSONObject jSONObject) throws IOException {
        List list;
        if (null == jSONObject) {
            return this.writeNull();
        }
        this.writeRawString("{");
        this.indentPush();
        Iterator iterator = null;
        if (jSONObject instanceof OrderedJSONObject) {
            iterator = ((OrderedJSONObject)jSONObject).getOrder();
        } else {
            list = this.getPropertyNames(jSONObject);
            iterator = list.iterator();
        }
        while (iterator.hasNext()) {
            list = iterator.next();
            if (!(list instanceof String)) {
                throw new IOException("attempting to serialize object with an invalid property name: '" + list + "'");
            }
            Object v2 = jSONObject.get(list);
            if (!JSONObject.isValidObject(v2)) {
                throw new IOException("attempting to serialize object with an invalid property value: '" + v2 + "'");
            }
            this.newLine();
            this.indent();
            this.writeString((String)((Object)list));
            this.writeRawString(":");
            this.space();
            this.write(v2);
            if (!iterator.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("}");
        return this;
    }

    public Serializer writeArray(JSONArray jSONArray) throws IOException {
        if (null == jSONArray) {
            return this.writeNull();
        }
        this.writeRawString("[");
        this.indentPush();
        Iterator iterator = jSONArray.iterator();
        while (iterator.hasNext()) {
            Object e10 = iterator.next();
            if (!JSONObject.isValidObject(e10)) {
                throw new IOException("attempting to serialize array with an invalid element: '" + jSONArray + "'");
            }
            this.newLine();
            this.indent();
            this.write(e10);
            if (!iterator.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("]");
        return this;
    }

    public void space() throws IOException {
    }

    public void newLine() throws IOException {
    }

    public void indent() throws IOException {
    }

    public void indentPush() {
    }

    public void indentPop() {
    }

    public List getPropertyNames(Map map) {
        return new ArrayList(map.keySet());
    }
}

