/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoKeyType;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoValueType;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;

public class DynamoTableAttribute
implements DBSEntityAttribute,
DBSTableColumn,
DBPNamedObject2,
DBPSaveableObject {
    private static final Log log = Log.getLog(DynamoTableAttribute.class);
    private final DynamoTable table;
    private boolean persisted;
    private String name;
    private DynamoValueType type;
    private boolean isKey;
    private DynamoKeyType keyType;

    public DynamoTableAttribute(DynamoTable table, AttributeDefinition definition) {
        this.table = table;
        this.name = definition.attributeName();
        this.type = DynamoValueType.from(definition.attributeType());
        this.persisted = true;
    }

    public DynamoTableAttribute(DynamoTable table, boolean persisted, String name, @NotNull DynamoValueType type) {
        this.table = table;
        this.persisted = persisted;
        this.name = name;
        this.type = type;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return (DynamoDataSource)this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DynamoTable getParentObject() {
        return this.table;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public String getDefaultValue() {
        return null;
    }

    public int getOrdinalPosition() {
        return -1;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @Property(viewable=true, editable=true, order=2, listProvider=TypeListProvider.class)
    public DynamoValueType getType() {
        return this.type;
    }

    public void setType(DynamoValueType type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.type.toString();
    }

    public String getFullTypeName() {
        return this.getTypeName();
    }

    public int getTypeID() {
        return this.type.ordinal();
    }

    public DBPDataKind getDataKind() {
        return this.type.getKind();
    }

    public Integer getScale() {
        return null;
    }

    public Integer getPrecision() {
        return null;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Property(viewable=true, editable=true, order=4)
    public DynamoKeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(DynamoKeyType keyType) {
        this.keyType = keyType;
    }

    public static class TypeListProvider
    implements IPropertyValueListProvider<Object> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(Object object) {
            return Arrays.stream(DynamoValueType.values()).filter(type -> type != DynamoValueType.UNKNOWN).toArray();
        }
    }
}

