/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoDeleteStatement;
import com.dbeaver.db.dynamodb.exec.DynamoPutStatement;
import com.dbeaver.db.dynamodb.exec.DynamoQueryStatement;
import com.dbeaver.db.dynamodb.exec.DynamoScanStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.exec.DynamoUpdateStatement;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoKeyType;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexAbstract;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexGlobal;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexLocal;
import com.dbeaver.db.dynamodb.model.DynamoTableKey;
import com.dbeaver.ee.model.document.DBAbstractDocumentContainer;
import com.dbeaver.ee.model.document.data.DBAbstractDocument;
import com.dbeaver.ee.model.document.data.DBMapValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDocumentLocator;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingModeSummary;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class DynamoTable
extends DBAbstractDocumentContainer<DynamoDataSource>
implements DBSDataManipulator,
DBSDocumentLocator,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject,
DBPObjectStatistics {
    private static final Log log = Log.getLog(DynamoTable.class);
    private String tableName;
    private boolean persisted;
    private volatile DynamoTableKey key;
    private final AttributeCache attributeCache = new AttributeCache();
    private volatile List<DynamoTableIndexLocal> localIndexes;
    private volatile List<DynamoTableIndexGlobal> globalIndexes;
    private volatile TableDescription tableDescription;
    private Long readCapacityUnits;
    private Long writeCapacityUnits;

    public DynamoTable(DynamoDataSource dataSource, String tableName, boolean persisted) {
        super((DBPDataSource)dataSource);
        this.tableName = tableName;
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.tableName;
    }

    public void setName(String newName) {
        this.tableName = newName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return ((DynamoDataSource)this.dataSource).getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    @Property(viewable=true, order=40)
    public TableStatus getTableStatus(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableStatus();
    }

    @Property(viewable=true, category="Statistics", order=41)
    public Instant getCreationDateTime(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).creationDateTime();
    }

    @Property(viewable=true, order=42)
    public String getTableArn(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableArn();
    }

    @Property(viewable=true, category="Statistics", order=43)
    public String getLatestStreamArn(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).latestStreamArn();
    }

    @Property(viewable=true, category="Statistics", order=44)
    public String getLatestStreamLabel(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).latestStreamLabel();
    }

    @Property(viewable=true, order=50)
    public String getTableId(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableId();
    }

    @Property(viewable=true, category="Statistics", order=51)
    public Long getTableSizeBytes(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).tableSizeBytes();
    }

    @Property(viewable=true, category="Statistics", order=52)
    public Long getRowCount(DBRProgressMonitor monitor) throws DBCException {
        return this.getTableDescription(monitor).itemCount();
    }

    @Property(viewable=true, category="Statistics", order=53)
    public String getBillingModeSummary(DBRProgressMonitor monitor) throws DBCException {
        BillingModeSummary billingModeSummary = this.getTableDescription(monitor).billingModeSummary();
        return billingModeSummary == null ? null : billingModeSummary.billingModeAsString();
    }

    @Property(viewable=true, editable=true, order=60)
    public Long getReadCapacityUnits(DBRProgressMonitor monitor) throws DBCException {
        if (this.readCapacityUnits == null && this.isPersisted()) {
            this.readCapacityUnits = this.getTableDescription(monitor).provisionedThroughput().readCapacityUnits();
        }
        return this.readCapacityUnits;
    }

    public void setReadCapacityUnits(Long readCapacityUnits) {
        this.readCapacityUnits = readCapacityUnits;
    }

    @Property(viewable=true, editable=true, order=61)
    public Long getWriteCapacityUnits(DBRProgressMonitor monitor) throws DBCException {
        if (this.writeCapacityUnits == null && this.isPersisted()) {
            this.writeCapacityUnits = this.getTableDescription(monitor).provisionedThroughput().readCapacityUnits();
        }
        return this.writeCapacityUnits;
    }

    public void setWriteCapacityUnits(Long writeCapacityUnits) {
        this.writeCapacityUnits = writeCapacityUnits;
    }

    public ProvisionedThroughput getProvisionedThroughput() throws DBCException {
        return (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.readCapacityUnits).writeCapacityUnits(this.writeCapacityUnits).build();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableDescription = null;
        if (this.readCapacityUnits != null) {
            this.readCapacityUnits = null;
            this.getReadCapacityUnits(monitor);
        }
        this.attributeCache.clearCache();
        this.localIndexes = null;
        this.globalIndexes = null;
        this.key = null;
        return this;
    }

    TableDescription getTableDescription(DBRProgressMonitor monitor) throws DBCException {
        if (!this.persisted) {
            this.tableDescription = (TableDescription)TableDescription.builder().build();
        }
        if (this.tableDescription == null) {
            try {
                DescribeTableResponse dtResponse = ((DynamoDataSource)this.dataSource).getClient().describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(this.tableName).build());
                this.tableDescription = dtResponse == null ? null : dtResponse.table();
            }
            catch (Exception e) {
                throw new DBCException("Error reading table attributes", (Throwable)e);
            }
        }
        return this.tableDescription;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public AttributeCache getAttributeCache() {
        return this.attributeCache;
    }

    @NotNull
    public List<DynamoTableAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBCException {
        return this.attributeCache.getAllObjects(monitor, this);
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBCException {
        DynamoTableAttribute attr = (DynamoTableAttribute)DBUtils.findObject(this.getAttributes(monitor), (String)attributeName);
        if (attr != null) {
            return attr;
        }
        return super.getAttribute(monitor, attributeName);
    }

    public List<DynamoTableKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        DynamoTableKey key = this.getKey(monitor);
        return key == null ? Collections.emptyList() : Collections.singletonList(key);
    }

    public DynamoTableKey getKey(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.key == null && this.persisted) {
            this.key = new DynamoTableKey(monitor, this, this.getTableDescription(monitor).keySchema());
        }
        return this.key;
    }

    public Collection<DynamoTableIndexAbstract> getIndexes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DynamoTableIndexAbstract> allIndexes = new ArrayList<DynamoTableIndexAbstract>();
        allIndexes.addAll(this.getLocalIndexes(monitor));
        allIndexes.addAll(this.getGlobalIndexes(monitor));
        return allIndexes;
    }

    public List<DynamoTableIndexLocal> getLocalIndexes(DBRProgressMonitor monitor) throws DBException {
        if (this.localIndexes == null) {
            ArrayList<DynamoTableIndexLocal> tmp = new ArrayList<DynamoTableIndexLocal>();
            for (LocalSecondaryIndexDescription indexDef : this.getTableDescription(monitor).localSecondaryIndexes()) {
                tmp.add(new DynamoTableIndexLocal(monitor, this, indexDef));
            }
            this.localIndexes = tmp;
        }
        return this.localIndexes;
    }

    public List<DynamoTableIndexGlobal> getGlobalIndexes(DBRProgressMonitor monitor) throws DBException {
        if (this.globalIndexes == null) {
            ArrayList<DynamoTableIndexGlobal> tmp = new ArrayList<DynamoTableIndexGlobal>();
            for (GlobalSecondaryIndexDescription indexDef : this.getTableDescription(monitor).globalSecondaryIndexes()) {
                tmp.add(new DynamoTableIndexGlobal(monitor, this, indexDef));
            }
            this.globalIndexes = tmp;
        }
        return this.globalIndexes;
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count", "data.filter", "data.insert", "data.update", "data.delete"};
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        long startTime;
        DBCStatistics statistics;
        block13: {
            statistics = new DBCStatistics();
            startTime = System.currentTimeMillis();
            Throwable throwable = null;
            Object var16_13 = null;
            try (DynamoBaseStatement scanStatement = this.createTableStatement((DynamoSession)session, source, dataFilter, firstRow, maxRows);){
                scanStatement.executeStatement();
                DBCResultSet resultSet = scanStatement.openResultSet();
                if (resultSet == null) break block13;
                dataReceiver.fetchStart(session, resultSet, firstRow, maxRows);
                DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
                try {
                    while (resultSet.nextRow()) {
                        if (fetchProgress.isCanceled()) break;
                        dataReceiver.fetchRow(session, resultSet);
                        fetchProgress.monitorRowFetch();
                    }
                    fetchProgress.dumpStatistics(statistics);
                }
                finally {
                    dataReceiver.fetchEnd(session, resultSet);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        return statistics;
    }

    private DynamoBaseStatement createTableStatement(DynamoSession session, DBCExecutionSource source, DBDDataFilter dataFilter, long firstRow, long maxRows) {
        DynamoBaseStatement statement;
        if (dataFilter != null && dataFilter.hasConditions()) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)dataFilter, (DBPDataSource)this.getDataSource(), null, (StringBuilder)query, (boolean)true);
            statement = new DynamoQueryStatement(session, query.toString());
        } else {
            statement = new DynamoScanStatement(session, this);
            statement.setDataFilter(dataFilter);
        }
        statement.setStatementSource(source);
        statement.setLimit(firstRow, maxRows);
        return statement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM ").append(DBUtils.getQuotedIdentifier((DBSObject)this));
        SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
        Throwable throwable = null;
        Object var8_8 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);){
            DBCResultSet resultSet;
            block14: {
                dbStat.executeStatement();
                Throwable throwable2 = null;
                Object var11_13 = null;
                try {
                    long l;
                    resultSet = dbStat.openResultSet();
                    try {
                        if (!resultSet.nextRow()) break block14;
                        l = CommonUtils.toLong((Object)resultSet.getAttributeValue(0));
                        if (resultSet == null) return l;
                    }
                    catch (Throwable throwable3) {
                        if (resultSet == null) throw throwable3;
                        resultSet.close();
                        throw throwable3;
                    }
                    resultSet.close();
                    return l;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            if (resultSet == null) return -1L;
            resultSet.close();
            return -1L;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source, Map<String, Object> options) throws DBCException {
        final DynamoSession dynamoSession = (DynamoSession)session;
        return new ExecuteBatchImpl(attributes, null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                return new DynamoPutStatement(dynamoSession, source, DynamoTable.this, this.attributes, attributeValues);
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((DynamoPutStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(final @NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        boolean updateByReplace;
        boolean bl = updateByReplace = updateAttributes.length == 1 && keyAttributes.length == 1 && updateAttributes[0] == keyAttributes[0] && updateAttributes[0].getDataKind() == DBPDataKind.DOCUMENT;
        if (updateByReplace || this.hasKeyAttribute(session, updateAttributes)) {
            return new DBSDataManipulator.ExecuteBatch(keyAttributes, source){
                private final DBSDataManipulator.ExecuteBatch insertBatch;
                private final DBSDataManipulator.ExecuteBatch deleteBatch;
                {
                    this.insertBatch = DynamoTable.this.insertData(dBCSession, dBSAttributeBaseArray, null, dBCExecutionSource, Collections.emptyMap());
                    this.deleteBatch = DynamoTable.this.deleteData(dBCSession, dBSAttributeBaseArray, dBCExecutionSource);
                }

                public void add(Object[] attributeValues) throws DBCException {
                    if (updateByReplace) {
                        this.insertBatch.add(Arrays.copyOfRange(attributeValues, 0, 1));
                        if (DynamoTable.this.hasKeyModified(session, attributeValues[0], attributeValues[1])) {
                            log.info((Object)"InsertItem and DeleteItem were used due to key update");
                            this.deleteBatch.add(Arrays.copyOfRange(attributeValues, 1, 2));
                        }
                    } else {
                        log.info((Object)"InsertItem and DeleteItem were used due to key update");
                        Object[] keyValues = Arrays.copyOfRange(attributeValues, updateAttributes.length, attributeValues.length);
                        this.insertBatch.add(keyValues);
                        this.deleteBatch.add(keyValues);
                    }
                }

                public DBCStatistics execute(DBCSession session2, Map<String, Object> options) throws DBCException {
                    DBCStatistics stats = new DBCStatistics();
                    stats.accumulate(this.insertBatch.execute(session2, options));
                    stats.accumulate(this.deleteBatch.execute(session2, options));
                    return stats;
                }

                public void generatePersistActions(DBCSession session2, List<DBEPersistAction> actions, Map<String, Object> options) throws DBCException {
                    this.insertBatch.generatePersistActions(session2, actions, options);
                    this.deleteBatch.generatePersistActions(session2, actions, options);
                }

                public void close() {
                    this.insertBatch.close();
                    this.deleteBatch.close();
                }
            };
        }
        final DynamoSession dynamoSession = (DynamoSession)session;
        DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
        return new ExecuteBatchImpl(attributes, null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                DynamoUpdateStatement statement = new DynamoUpdateStatement(dynamoSession, source, DynamoTable.this, updateAttributes, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((DynamoUpdateStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    private boolean hasKeyModified(DBCSession session, Object newObj, Object rawObj) throws DBCException {
        if (newObj instanceof DBAbstractDocument && newObj instanceof DBAbstractDocument) {
            DynamoTableKey key = this.getKeyInternal(session);
            DBMapValue newMap = ((DBAbstractDocument)newObj).getRootNode();
            DBMapValue rawMap = ((DBAbstractDocument)rawObj).getRootNode();
            for (Map.Entry newEntry : newMap.getRawValue().entrySet()) {
                if (newEntry.getValue() == null || !key.containsAttribute((String)newEntry.getKey()) || newEntry.getValue().equals(rawMap.getAttributeValue((String)newEntry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasKeyAttribute(DBCSession session, DBSAttributeBase[] updateAttributes) throws DBCException {
        DynamoTableKey key = this.getKeyInternal(session);
        boolean recreateRequired = false;
        DBSAttributeBase[] dBSAttributeBaseArray = updateAttributes;
        int n = updateAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSAttributeBase updAttr = dBSAttributeBaseArray[n2];
            if (key.containsAttribute(updAttr.getName())) {
                recreateRequired = true;
                break;
            }
            ++n2;
        }
        return recreateRequired;
    }

    private DynamoTableKey getKeyInternal(DBCSession session) throws DBCException {
        try {
            return this.getKey(session.getProgressMonitor());
        }
        catch (DBException e) {
            throw new DBCException("Unable to get key info", (Throwable)e);
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        final DynamoSession dynamoSession = (DynamoSession)session;
        return new ExecuteBatchImpl(keyAttributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                return new DynamoDeleteStatement(dynamoSession, source, DynamoTable.this, this.attributes, attributeValues);
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((DynamoDeleteStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean hasStatistics() {
        return this.tableDescription != null;
    }

    public long getStatObjectSize() {
        return this.tableDescription == null ? 0L : CommonUtils.toLong((Object)this.tableDescription.tableSizeBytes());
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    @Nullable
    public DBDDocument findDocument(@NotNull DBRProgressMonitor monitor, Map<String, Object> key) throws DBException {
        DynamoTableKey tableKey = this.getKey(monitor);
        LinkedHashMap<String, AttributeValue> keyValues = new LinkedHashMap<String, AttributeValue>();
        for (DynamoTableKey.KeyAttribute ka : tableKey.getAttributes()) {
            Object keyAttrValue = key.get(ka.getName());
            keyValues.put(ka.getName(), DynamoDBUtils.getAttributeValueFromJson(keyAttrValue, ka.getAttribute().getDataKind() == DBPDataKind.NUMERIC));
        }
        GetItemRequest itemRequest = (GetItemRequest)GetItemRequest.builder().tableName(this.getName()).key(keyValues).build();
        GetItemResponse getItemResponse = ((DynamoDataSource)this.dataSource).getClient().getItem(itemRequest);
        Map item = getItemResponse.item();
        if (item != null) {
            return new DynamoDocument((DynamoDataSource)this.getDataSource(), this, item);
        }
        return null;
    }

    public class AttributeCache
    extends BasicObjectCache<DynamoTable, DynamoTableAttribute> {
        @NotNull
        public List<DynamoTableAttribute> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable DynamoTable table) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<DynamoTableAttribute> attrList = new ArrayList<DynamoTableAttribute>();
                if (DynamoTable.this.isPersisted()) {
                    TableDescription tableDescription = DynamoTable.this.getTableDescription(monitor);
                    for (AttributeDefinition attrDef : tableDescription.attributeDefinitions()) {
                        attrList.add(new DynamoTableAttribute(table, attrDef));
                    }
                    List keySchema = tableDescription.keySchema();
                    for (KeySchemaElement ksItem : keySchema) {
                        for (DynamoTableAttribute attr : attrList) {
                            if (!CommonUtils.equalObjects((Object)ksItem.attributeName(), (Object)attr.getName())) continue;
                            attr.setKeyType(DynamoKeyType.getByKeyType(ksItem.keyType()));
                        }
                    }
                }
                this.setCache(attrList);
            }
            return this.getCachedObjects();
        }
    }
}

