/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import com.dbeaver.db.dynamodb.model.DynamoTableIndexAbstract;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTable;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableStatus;

public class DynamoGlobalTable
implements DBSTable,
DBPSaveableObject,
DBPSystemObject,
DBPRefreshableObject,
DBSDataContainer {
    private static final Log log = Log.getLog(DynamoGlobalTable.class);
    private final DynamoDataSource dataSource;
    private final GlobalTable globalTable;
    private boolean persisted;
    private volatile GlobalTableDescription tableDescription;

    public DynamoGlobalTable(DynamoDataSource dataSource, GlobalTable globalTable) {
        this.dataSource = dataSource;
        this.globalTable = globalTable;
        this.persisted = true;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.globalTable.globalTableName();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return false;
    }

    @Property
    public GlobalTableStatus getTableStatus(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).globalTableStatus();
    }

    @Property
    public Instant getCreationDateTime(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).creationDateTime();
    }

    @Property
    public String getTableArn(DBRProgressMonitor monitor) {
        return this.getTableDescription(monitor).globalTableArn();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableDescription = null;
        return this;
    }

    public boolean isView() {
        return false;
    }

    GlobalTableDescription getTableDescription(DBRProgressMonitor monitor) {
        if (this.tableDescription == null) {
            DescribeGlobalTableResponse dtResponse = this.dataSource.getClient().describeGlobalTable((DescribeGlobalTableRequest)DescribeGlobalTableRequest.builder().globalTableName(this.getName()).build());
            this.tableDescription = dtResponse == null ? null : dtResponse.globalTableDescription();
        }
        return this.tableDescription;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public List<DynamoTableAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    public DynamoTableAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) {
        return null;
    }

    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public List<? extends DBSTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<DynamoTableIndexAbstract> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    public String[] getSupportedFeatures() {
        return new String[]{"data.select"};
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        long startTime = System.currentTimeMillis();
        statistics.addExecuteTime(System.currentTimeMillis() - startTime);
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        return 0L;
    }
}

