/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import java.time.Instant;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableDescription;

public class DynamoBackup
implements DBSObject,
DBPSaveableObject {
    private static final Log log = Log.getLog(DynamoBackup.class);
    private final DynamoDataSource dataSource;
    private final BackupSummary summary;
    private boolean persisted;
    private volatile GlobalTableDescription tableDescription;

    public DynamoBackup(DynamoDataSource dataSource, BackupSummary summary) {
        this.dataSource = dataSource;
        this.summary = summary;
        this.persisted = true;
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.summary.backupName();
    }

    @Property(viewable=true)
    public String getTableName() {
        return this.summary.tableName();
    }

    public String getTableId() {
        return this.summary.tableId();
    }

    @Property
    public String getTableArn() {
        return this.summary.tableArn();
    }

    @Property
    public String getBackupArn() {
        return this.summary.backupArn();
    }

    @Property(viewable=true)
    public Instant getBackupCreationDateTime() {
        return this.summary.backupCreationDateTime();
    }

    @Property(viewable=true)
    public Instant getBackupExpiryDateTime() {
        return this.summary.backupExpiryDateTime();
    }

    @Property(viewable=true)
    public String getBackupStatus() {
        return this.summary.backupStatusAsString();
    }

    @Property
    public String getBackupType() {
        return this.summary.backupTypeAsString();
    }

    @Property(viewable=true)
    public Long getBackupSizeBytes() {
        return this.summary.backupSizeBytes();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String toString() {
        return this.getName();
    }
}

