/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoResultIterable;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalResultSet;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;

public class DynamoQueryStatement
extends DynamoBaseStatement {
    private static final Gson QUERY_PARSER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().setLenient().create();
    private static final Log log = Log.getLog(DynamoQueryStatement.class);
    @NotNull
    private final String queryText;
    @NotNull
    private QueryRequest queryRequest;
    @NotNull
    private DBCResultSet resultSet;
    private boolean selectCount;
    private boolean hasKeyConditions;

    public DynamoQueryStatement(@NotNull DynamoSession session, @NotNull String queryText) {
        super(session);
        this.queryText = queryText;
    }

    @Override
    @Nullable
    public DynamoTable getSourceEntity() {
        if (this.queryRequest != null) {
            String tableName = this.queryRequest.tableName();
            return (DynamoTable)((DynamoSession)this.getSession()).getDataSource().getTableCache().getCachedObject(tableName);
        }
        return null;
    }

    @NotNull
    public String getQueryString() {
        try {
            this.parseQueryText();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (this.selectCount) {
            return "SELECT COUNT(*) FROM " + DBUtils.getObjectFullName((DBPNamedObject)this.getSourceEntity(), (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        if (!this.hasKeyConditions) {
            return "SCAN " + this.queryText;
        }
        return this.queryText;
    }

    public boolean executeStatement() throws DBCException {
        if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        Exception executeError = null;
        try {
            this.parseQueryText();
            DynamoDbClient client = ((DynamoSession)this.getSession()).getDataSource().getClient();
            if (this.selectCount) {
                long rowCount;
                if (CommonUtils.isEmpty((Map)this.queryRequest.keyConditions())) {
                    ScanRequest scanRequest = this.createScanRequest(false);
                    rowCount = client.scan(scanRequest).count().intValue();
                } else {
                    rowCount = client.query(this.queryRequest).count().intValue();
                }
                LocalResultSet lrs = new LocalResultSet(this.getSession(), (DBCStatement)this);
                lrs.addColumn("count", DBPDataKind.NUMERIC);
                lrs.addRow(new Object[]{rowCount});
                this.resultSet = lrs;
            } else if (!this.hasKeyConditions) {
                ScanRequest scanRequest = this.createScanRequest(true);
                this.resultSet = new DynamoResultIterable(this, (Iterable<?>)client.scanPaginator(scanRequest), this.limit);
            } else {
                QueryIterable queryResponse = client.queryPaginator(this.queryRequest);
                this.resultSet = new DynamoResultIterable(this, (Iterable<?>)queryResponse, this.limit);
            }
            return true;
        }
        catch (Exception e) {
            executeError = e;
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(GeneralUtils.getRootCause((Throwable)e), (DBCExecutionContext)((DynamoSession)this.getSession()).getExecutionContext());
        }
        finally {
            if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
    }

    public void parseQueryText() throws Exception {
        String query = this.queryText.trim();
        if (query.toUpperCase(Locale.ENGLISH).startsWith("SELECT")) {
            this.createSelectQuery(query);
        } else {
            if (!query.startsWith("{")) {
                query = "{" + query + "}";
            }
            this.createJsonQueryRequest(query);
        }
    }

    @NotNull
    private ScanRequest createScanRequest(boolean setLimit) {
        ScanRequest.Builder srBuilder = ScanRequest.builder().tableName(this.queryRequest.tableName()).projectionExpression(this.queryRequest.projectionExpression());
        String expression = this.queryRequest.keyConditionExpression();
        if (!CommonUtils.isEmpty((String)this.queryRequest.filterExpression())) {
            expression = expression == null ? this.queryRequest.filterExpression() : String.valueOf(expression) + " AND " + this.queryRequest.filterExpression();
        }
        if (!CommonUtils.isEmpty((String)expression)) {
            srBuilder.filterExpression(expression);
        }
        if (!CommonUtils.isEmpty((Map)this.queryRequest.expressionAttributeNames())) {
            srBuilder.expressionAttributeNames(this.queryRequest.expressionAttributeNames());
        }
        if (!CommonUtils.isEmpty((Map)this.queryRequest.expressionAttributeValues())) {
            srBuilder.expressionAttributeValues(this.queryRequest.expressionAttributeValues());
        }
        if (setLimit && this.limit > 0L) {
            srBuilder.limit(Integer.valueOf((int)this.limit));
        }
        return (ScanRequest)srBuilder.build();
    }

    private void createSelectQuery(@NotNull String query) throws Exception {
        Statement statement = SQLSemanticProcessor.parseQuery((String)query);
        if (statement instanceof Select && ((Select)statement).getSelectBody() instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            try {
                this.parseSelect(select);
            }
            catch (Exception e) {
                if (e instanceof DBCException) {
                    throw e;
                }
                throw new DBCException("Error parsing SQL query", (Throwable)e);
            }
        } else {
            throw new DBCException("Only SELECT SQL queries supported");
        }
    }

    private void parseSelect(@NotNull PlainSelect select) throws DBException {
        Expression where;
        if (!(select.getFromItem() instanceof Table)) {
            throw new DBCException("FROM keyword missing");
        }
        if (!CommonUtils.isEmpty((Collection)select.getJoins())) {
            throw new DBCException("JOINs are not supported");
        }
        if (select.getHaving() != null) {
            throw new DBCException("HAVING is not supported");
        }
        QueryRequest.Builder queryBuilder = QueryRequest.builder();
        if (this.limit > 0L) {
            queryBuilder.limit(Integer.valueOf((int)this.limit));
        }
        HashMap<String, String> attrNames = new HashMap<String, String>();
        DynamoTable table = this.getDynamoTable(((Table)select.getFromItem()).getName());
        queryBuilder.tableName(table.getName());
        List selectItems = select.getSelectItems();
        if (!CommonUtils.isEmpty((Collection)selectItems)) {
            StringBuilder projectionExpression = new StringBuilder();
            int index = 0;
            while (index < selectItems.size()) {
                SelectItem item = (SelectItem)selectItems.get(index);
                if (item instanceof AllColumns || item instanceof AllTableColumns) break;
                if (item instanceof SelectExpressionItem) {
                    SelectExpressionItem sei = (SelectExpressionItem)item;
                    Expression expr = sei.getExpression();
                    if (expr instanceof Column) {
                        String attrName = DBUtils.getUnQuotedIdentifier((String)((Column)expr).getFullyQualifiedName(), (String)"\"");
                        String attrKey = "#sc" + attrNames.size() + "_" + CommonUtils.escapeIdentifier((String)attrName);
                        attrNames.put(attrKey, attrName);
                        if (index > 0) {
                            projectionExpression.append(", ");
                        }
                        projectionExpression.append(attrKey);
                    } else if (expr instanceof Function && ((Function)expr).getName().equalsIgnoreCase("count")) {
                        this.selectCount = true;
                    } else {
                        throw new DBCException("Unsupported select expression: " + expr);
                    }
                }
                ++index;
            }
            if (projectionExpression.length() > 0) {
                queryBuilder.projectionExpression(projectionExpression.toString());
            }
        }
        if ((where = select.getWhere()) != null) {
            DynamoSQL.RequestConditionsInfo condition = DynamoSQL.prepareSelectionConditions(table, where);
            if (condition.getFilterExpression().length() > 0) {
                queryBuilder.filterExpression(condition.getFilterExpression());
            }
            if (condition.getKeyExpression().length() > 0) {
                queryBuilder.keyConditionExpression(condition.getKeyExpression());
                this.hasKeyConditions = true;
            }
            if (!condition.getExprAttrNames().isEmpty()) {
                attrNames.putAll(condition.getExprAttrNames());
            }
            if (!condition.getExprAttrValues().isEmpty()) {
                queryBuilder.expressionAttributeValues(condition.getExprAttrValues());
            }
        }
        queryBuilder.expressionAttributeNames(attrNames);
        Limit sLimit = select.getLimit();
        if (sLimit != null) {
            try {
                if (sLimit.getOffset() != null) {
                    this.offset = Long.parseLong(sLimit.getOffset().toString());
                }
                if (sLimit.getRowCount() != null) {
                    this.limit = Long.parseLong(sLimit.getRowCount().toString());
                }
                if (this.limit > 0L) {
                    queryBuilder.limit(Integer.valueOf((int)this.limit));
                }
            }
            catch (NumberFormatException e) {
                throw new DBCException("Bad LIMIT clause", (Throwable)e);
            }
        }
        this.queryRequest = (QueryRequest)queryBuilder.build();
    }

    private void createJsonQueryRequest(@NotNull String jsonString) throws Exception {
        Map paramMap = (Map)QUERY_PARSER.fromJson(jsonString, Map.class);
        QueryRequest.Builder queryBuilder = QueryRequest.builder();
        if (this.limit > 0L) {
            queryBuilder.limit(Integer.valueOf((int)this.limit));
        }
        for (Map.Entry param : paramMap.entrySet()) {
            Object value = param.getValue();
            switch (((String)param.getKey()).toLowerCase(Locale.ENGLISH)) {
                case "tablename": {
                    queryBuilder.tableName(CommonUtils.toString(value));
                    break;
                }
                case "indexname": {
                    queryBuilder.indexName(CommonUtils.toString(value));
                    break;
                }
                case "select": {
                    queryBuilder.select(CommonUtils.toString(value));
                    break;
                }
                case "attributestoget": {
                    ArrayList<String> attrNames = new ArrayList<String>();
                    if (value instanceof Collection) {
                        for (Object object : (Collection)value) {
                            attrNames.add(CommonUtils.toString((Object)object));
                        }
                    }
                    queryBuilder.attributesToGet(attrNames);
                    break;
                }
                case "limit": {
                    queryBuilder.limit(Integer.valueOf(CommonUtils.toInt(value)));
                    break;
                }
                case "consistentread": {
                    queryBuilder.consistentRead(Boolean.valueOf(CommonUtils.toBoolean(value)));
                    break;
                }
                case "keyconditions": {
                    queryBuilder.keyConditionExpression(QUERY_PARSER.toJson(value));
                    break;
                }
                case "queryfilter": {
                    queryBuilder.filterExpression(QUERY_PARSER.toJson(value));
                    break;
                }
                case "conditionaloperator": {
                    queryBuilder.conditionalOperator(CommonUtils.toString(value));
                    break;
                }
                case "scanindexforward": {
                    queryBuilder.scanIndexForward(Boolean.valueOf(CommonUtils.toBoolean(value)));
                    break;
                }
                case "returnconsumedcapacity": {
                    queryBuilder.returnConsumedCapacity(CommonUtils.toString(value));
                    break;
                }
                case "projectionexpression": {
                    queryBuilder.projectionExpression(CommonUtils.toString(value));
                    break;
                }
                case "filterexpression": {
                    queryBuilder.filterExpression(CommonUtils.toString(value));
                    break;
                }
                case "keyconditionexpression": {
                    queryBuilder.keyConditionExpression(CommonUtils.toString(value));
                    break;
                }
                case "expressionattributenames": {
                    LinkedHashMap<String, String> expAttributes = new LinkedHashMap();
                    if (value instanceof Map) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            expAttributes.put((String)entry.getKey(), QUERY_PARSER.toJson(entry.getValue()));
                        }
                    }
                    queryBuilder.expressionAttributeNames(expAttributes);
                    break;
                }
                case "expressionattributevalues": {
                    LinkedHashMap<String, String> expAttributes = new LinkedHashMap<String, String>();
                    if (value instanceof Map) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            expAttributes.put((String)entry.getKey(), (String)DynamoDBUtils.getAttributeValueFromJson(entry.getValue()));
                        }
                    }
                    queryBuilder.expressionAttributeValues(expAttributes);
                    break;
                }
                default: {
                    log.debug((Object)("Unsupported DynamoDB query parameter: " + (String)param.getKey()));
                }
                case "exclusivestartkey": 
            }
        }
        this.queryRequest = (QueryRequest)queryBuilder.build();
    }

    @Override
    @NotNull
    public DBCResultSet openResultSet() throws DBCException {
        return this.resultSet;
    }
}

