/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.drop.Drop;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;

public class DynamoDropStatement
extends DynamoBaseStatement {
    @Nullable
    private DynamoTable table;
    @Nullable
    private String statementText;

    public DynamoDropStatement(@NotNull DynamoSession session, @NotNull String statementText) {
        super(session);
        this.table = null;
        this.statementText = statementText;
    }

    public DynamoDropStatement(@NotNull DynamoSession session, @NotNull DBCExecutionSource source, @NotNull DynamoTable table) {
        super(session, source);
        this.table = table;
        this.statementText = null;
    }

    @Nullable
    public String getQueryString() {
        return this.statementText != null ? this.statementText : (this.statementText = this.makeStatementText());
    }

    @NotNull
    private String makeStatementText() {
        return "DROP " + this.table.getName();
    }

    public boolean executeStatement() throws DBCException {
        Drop drop;
        Statement statement = SQLSemanticProcessor.parseQuery((String)this.statementText);
        if (statement instanceof Drop) {
            drop = (Drop)statement;
            if (drop.getName() == null) {
                throw new DBCException("Unsupported SQL query");
            }
        } else {
            throw new DBCException("This type of statement is not supported");
        }
        DynamoTable table = this.getDynamoTable(drop.getName().getName());
        DeleteTableRequest dtr = (DeleteTableRequest)DeleteTableRequest.builder().tableName(table.getName()).build();
        ((DynamoSession)this.getSession()).getDataSource().getClient().deleteTable(dtr);
        return false;
    }

    @Override
    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    public DynamoTable getSourceEntity() {
        return this.table;
    }
}

