/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.sql;

import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPDatabaseEngine;
import com.dbeaver.cloud.gcp.GCPProject;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;

public abstract class GCPCloudSQLBaseInstance
extends GCPCloudAbstractInstance {
    protected GCPCloudSQLBaseInstance(GCPCloudSession session, GCPProject project) {
        super(session, project);
    }

    @Override
    protected boolean isDriverNeedsAuthentication() {
        return true;
    }

    protected void setDefaultDataSourceConfiguration(GCPDatabaseEngine instanceFamily, DBPConnectionConfiguration configuration) throws DBException {
        switch (instanceFamily) {
            case POSTGRES: {
                configuration.setAuthModelId("gcp_sql_iam");
                configuration.setProperty("sslpasswordcallback", DefaultCallbackHandler.class.getName());
                break;
            }
            case MYSQL: {
                configuration.setAuthModelId("gcp_sql_iam");
                break;
            }
            case SQLSERVER: {
                configuration.setAuthModelId("gcp_sql_iam");
                break;
            }
            default: {
                throw new DBException("SQL engine '" + (Object)((Object)instanceFamily) + "' not supported");
            }
        }
    }

    public String toString() {
        return this.getGcpResourceARN();
    }
}

