/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloudService;

public enum GCPDatabaseEngine {
    POSTGRES("postgres", GCPCloudService.SQL_POSTGRESQL),
    MYSQL("mysql", GCPCloudService.SQL_MYSQL),
    SQLSERVER("sqlserver", GCPCloudService.SQL_SQLSERVER);

    private final String id;
    private final GCPCloudService cloudService;

    private GCPDatabaseEngine(String id, GCPCloudService cloudService) {
        this.id = id;
        this.cloudService = cloudService;
    }

    public String getId() {
        return this.id;
    }

    public GCPCloudService getCloudService() {
        return this.cloudService;
    }

    public boolean matchesDatabaseVersion(String databaseVersion) {
        return databaseVersion.toLowerCase().startsWith(this.id);
    }
}

