/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.google.api.client.googleapis.services.AbstractGoogleClient;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class GCPCloudUtils {
    private static final Log log = Log.getLog(GCPCloudUtils.class);

    public static GCPCloud[] getAllClouds() {
        return (GCPCloud[])GCPCloudUtils.getGcpCloudProvider().getInstance().getAvailableClouds();
    }

    public static GCPCloud getCloud(String cloudId) {
        List providers = CloudProviderRegistry.getInstance().getCloudProviders();
        for (CloudProviderDescriptor cpDescriptor : providers) {
            CPCloud[] cPCloudArray = cpDescriptor.getInstance().getAvailableClouds();
            int n = cPCloudArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPCloud cloud = cPCloudArray[n2];
                if (cloud.getCloudId().equals(cloudId)) {
                    return (GCPCloud)cloud;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nullable
    public static GCPCloudConfiguration getGcpCloudConfiguration() {
        return (GCPCloudConfiguration)CPCloudUtils.getCloudConfiguration((String)"GCP", GCPCloudConfiguration.class);
    }

    public static CloudProviderDescriptor getGcpCloudProvider() {
        return CloudProviderRegistry.getInstance().getCloudProvider("gcp");
    }

    public static <B extends AbstractGoogleClient.Builder, C extends AbstractGoogleClient> C buildClient(B builder) {
        builder.setApplicationName(GeneralUtils.getProductName());
        return (C)builder.build();
    }
}

