/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public enum GCPCloudService {
    SQL_POSTGRESQL("postgresql", "sql", "gcp.postgresql", "gcp-postgres-jdbc"),
    SQL_MYSQL("mysql", "sql", "gcp.mysql", "gcp-mysql-jdbc"),
    SQL_SQLSERVER("sqlserver", "sql", "gcp.sqlserver", "gcp-sqlserver-jdbc"),
    UNKNOWN("unknown", "", "", "");

    private final String id;
    private final String serviceId;
    private final String providerId;
    private final String driverId;

    private GCPCloudService(String id, String serviceId, String providerId, String driverId) {
        this.id = id;
        this.serviceId = serviceId;
        this.providerId = providerId;
        this.driverId = driverId;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String getServiceId() {
        return this.serviceId;
    }

    @NotNull
    public String getProviderId() {
        return this.providerId;
    }

    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    public DBPDriver getInstanceDriver() throws DBException {
        DataSourceProviderDescriptor dsProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(this.providerId);
        if (dsProvider == null) {
            throw new DBException("Datasource provider '" + this.providerId + "' not found");
        }
        DriverDescriptor driver = dsProvider.getDriver(this.driverId);
        if (driver == null) {
            throw new DBException("Driver '" + this.driverId + "' not found");
        }
        return driver;
    }

    @Nullable
    public static GCPCloudService getServiceByDriver(DBPDriver driver) {
        GCPCloudService[] gCPCloudServiceArray = GCPCloudService.values();
        int n = gCPCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCPCloudService service = gCPCloudServiceArray[n2];
            if (service.providerId.equals(driver.getProviderId()) && service.driverId.equals(driver.getId())) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public static GCPCloudService getServiceById(String id) {
        GCPCloudService[] gCPCloudServiceArray = GCPCloudService.values();
        int n = gCPCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCPCloudService service = gCPCloudServiceArray[n2];
            if (service.getId().equals(id)) {
                return service;
            }
            ++n2;
        }
        return null;
    }
}

