/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.gcp.GCPCloudDataSourceOrigin;
import com.dbeaver.cloud.gcp.GCPCloudUtils;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.utils.CommonUtils;

public class GCPCloudProvider
implements CPCloudProvider,
CPCloudConfigurationListener {
    private static final Log log = Log.getLog(GCPCloudProvider.class);
    private GCPCloud[] allClouds;

    public GCPCloudProvider() {
        CPCloudConfigurationRegistry.getInstance().addConfigurationChangeListener((CPCloudConfigurationListener)this, true);
    }

    @NotNull
    public String getCloudProviderId() {
        return "gcp";
    }

    @NotNull
    public synchronized GCPCloud[] getAvailableClouds() {
        if (this.allClouds == null) {
            CPCloudConfigurationProvider configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(this.getCloudProviderId());
            CPCloudConfiguration[] configurations = new CPCloudConfiguration[]{};
            if (configurationProvider != null) {
                configurations = configurationProvider.getCloudConfigurations();
            }
            this.allClouds = (GCPCloud[])Arrays.stream(configurations).filter(cfg -> cfg instanceof GCPCloudConfiguration).map(cfg -> new GCPCloud(this, (GCPCloudConfiguration)cfg)).toArray(GCPCloud[]::new);
        }
        return this.allClouds;
    }

    public DBPDataSourceOrigin createDataSourceOrigin(@NotNull CPCloud<?, ?> cloud, CPCloudZone zone, Map<String, Object> configuration) {
        String projectId = CommonUtils.toString((Object)configuration.get("gcp-project"));
        String resourceId = CommonUtils.toString((Object)configuration.get("gcp-resource"));
        String nodeId = CommonUtils.toString((Object)configuration.get("gcp-node-id"));
        return new GCPCloudDataSourceOrigin(GCPCloudUtils.getGcpCloudProvider(), (GCPCloud)cloud, projectId, (GCPCloudZone)zone, resourceId, nodeId);
    }

    public GCPCloud createCloudInstance(GCPCloudConfiguration configuration) {
        return new GCPCloud(this, configuration);
    }

    public void handleCloudConfigurationChange() {
        this.allClouds = null;
    }
}

