/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudExplorer;
import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class GCPCloudDataSourceOrigin
extends DataSourceOriginCloud<GCPCloud, GCPCloudZone>
implements DBACredentialsProvider {
    private static final Log log = Log.getLog(GCPCloudDataSourceOrigin.class);
    static final String PROPERTY_PROJECT_ID = "gcp-project";
    static final String PROPERTY_RESOURCE_ID = "gcp-resource";
    static final String PROPERTY_NODE_ID = "gcp-node-id";
    private final String projectId;
    private final String resourceId;
    private final String nodeId;

    public GCPCloudDataSourceOrigin(@NotNull CloudProviderDescriptor provider, @NotNull GCPCloud cloud, @NotNull String projectId, @NotNull GCPCloudZone zone, String resourceId, String nodeId) {
        super(provider, (CPCloud)cloud, (CPCloudZone)zone);
        this.projectId = projectId;
        this.resourceId = resourceId;
        this.nodeId = nodeId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    @NotNull
    public Map<String, Object> getDataSourceConfiguration() {
        Map configuration = super.getDataSourceConfiguration();
        configuration.put(PROPERTY_PROJECT_ID, this.projectId);
        configuration.put(PROPERTY_RESOURCE_ID, this.resourceId);
        configuration.put(PROPERTY_NODE_ID, this.nodeId);
        return configuration;
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext sessionContext, @NotNull DBPDataSourceContainer dataSource) throws DBException {
        GCPCloudService service = GCPCloudService.getServiceByDriver(dataSource.getDriver());
        if (service == null) {
            log.error((Object)("Cannot detect GCP service for driver " + dataSource.getDriver().getFullName()));
            return null;
        }
        GCPCloudAbstractInstance instance = this.getDatabaseInstance(monitor, sessionContext, service);
        if (instance == null) {
            log.error((Object)(String.valueOf(service.getServiceId()) + " instance '" + this.resourceId + "' not found"));
        }
        return instance;
    }

    public GCPCloudAbstractInstance getDatabaseInstance(DBRProgressMonitor monitor, SMSessionContext sessionContext, GCPCloudService service) throws DBException {
        SMSession cloudSession = sessionContext.getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
        if (cloudSession instanceof GCPCloudSession) {
            GCPCloudExplorer cloudExplorer = ((GCPCloud)this.cloud).createExplorer(monitor, (GCPCloudSession)cloudSession);
            return cloudExplorer.getDatabaseInstance(monitor, service.getServiceId(), (CPDatabaseFolder)new GCPProject(this.projectId), (GCPCloudZone)this.zone, this.nodeId);
        }
        throw new DBException("GCP cloud session not found");
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        SMSession cloudSession = DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
        if (cloudSession instanceof GCPCloudSession) {
            return ((GCPCloudSession)cloudSession).provideAuthParameters(monitor, dataSourceContainer, configuration);
        }
        return false;
    }
}

