/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;

public abstract class GCPCloudAbstractInstance
implements CPDatabaseNode,
CPDatabaseInstance {
    @NotNull
    private final GCPCloudSession session;
    @NotNull
    private final GCPProject project;

    public GCPCloudAbstractInstance(@NotNull GCPCloudSession session, @NotNull GCPProject project) {
        this.session = session;
        this.project = project;
    }

    public GCPCloudSession getCloudSession() {
        return this.session;
    }

    @NotNull
    public String getCloudResourceId() {
        return this.getInstanceARN();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        try {
            return this.getInstanceDriver().getIcon();
        }
        catch (DBException dBException) {
            return null;
        }
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public abstract GCPCloudZone getZone();

    @NotNull
    public GCPProject getFolder() {
        return this.project;
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.getNodeName();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getGcpRegionId() {
        return this.getZone().getZoneId();
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getGcpResourceARN() {
        return this.getInstanceARN();
    }

    @Property(viewable=true, order=3, href=true)
    @NotNull
    public String getGcpResourceLink() {
        return this.getExternalLink();
    }

    @NotNull
    public DBPDataSourceContainer createDataSourceContainer(DBRProgressMonitor monitor, DBPDataSourceRegistry dataSourceRegistry) throws DBException {
        String dsID = this.getCloudResourceId();
        DBPDriver driver = this.getInstanceDriver();
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        DataSourceDescriptor dataSource = new DataSourceDescriptor(dataSourceRegistry, (DBPDataSourceConfigurationStorage)this.session.getCloud().getDataSourceStorage(), this.session.getCloud().createOrigin(this.getZone(), this.getFolder(), this.getResourceId(), this.getNodeId()), dsID, driver, configuration);
        this.setDataSourceConfiguration(dataSource, configuration);
        dataSource.setHidden(true);
        dataSource.setName(String.valueOf(driver.getName()) + " - " + this.getNodeDisplayName());
        dataSource.setSavePassword(!this.isDriverNeedsAuthentication());
        dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSource);
        return dataSource;
    }

    @NotNull
    protected String getResourceId() {
        return this.getInstanceARN();
    }

    protected boolean isDriverNeedsAuthentication() {
        return false;
    }

    protected abstract void setDataSourceConfiguration(DataSourceDescriptor var1, DBPConnectionConfiguration var2) throws DBException;

    protected abstract GCPCloudService getCloudService();

    protected abstract String getInstanceARN();

    protected abstract String getExternalLink();

    protected String getInstanceUserName() {
        return null;
    }

    private DBPDriver getInstanceDriver() throws DBException {
        return this.getCloudService().getInstanceDriver();
    }
}

