/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.ui;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.gcp.GCPCloudProvider;
import com.dbeaver.cloud.gcp.ui.internal.GcpCloudUIMessages;
import com.dbeaver.net.auth.gcp.AuthModelGCPAbstract;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.ui.auth.gcp.AuthModelGCPConfigurator;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;

public class GcpUIConfigurationEditor
implements IObjectPropertyConfigurator<Object, GCPCloudConfiguration> {
    private static final Log log = Log.getLog(GcpUIConfigurationEditor.class);
    private GCPCloudConfiguration curConfiguration;
    private AuthModelGCPConfigurator iamConfigurator;
    private Composite mainGroup;
    private Button refreshSessionButton;
    private Button closeSessionButton;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        TabFolder configTabs = new TabFolder(parent, 0x800080);
        this.createGeneralTab(configTabs, propertyChangeListener);
        configTabs.setSelection(0);
    }

    public void createGeneralTab(final TabFolder parent, Runnable propertyChangeListener) {
        Composite topGroup = new Composite((Composite)parent, 0);
        topGroup.setLayout((Layout)new GridLayout(1, false));
        this.mainGroup = UIUtils.createComposite((Composite)topGroup, (int)2);
        this.mainGroup.setLayoutData((Object)new GridData(1808));
        this.iamConfigurator = new AuthModelGCPConfigurator();
        this.iamConfigurator.setCloudProvided(false);
        this.iamConfigurator.createIAMAuthControls(this.mainGroup, () -> {
            this.updateSessionActions();
            propertyChangeListener.run();
        }, false);
        this.iamConfigurator.initAuthTypes();
        UIUtils.createEmptyLabel((Composite)topGroup, (int)1, (int)1).setLayoutData((Object)new GridData(1808));
        final Composite btnComposite = UIUtils.createComposite((Composite)topGroup, (int)4);
        btnComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)btnComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)btnComposite, (String)GcpCloudUIMessages.gcp_configurator_dialog_button_test_connection, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GcpUIConfigurationEditor.this.saveSettings(GcpUIConfigurationEditor.this.curConfiguration);
                try {
                    GcpUIConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> GcpUIConfigurationEditor.this.testCloudConnection(monitor, GcpUIConfigurationEditor.this.curConfiguration));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Cloud connect error", "Error during cloud connect", ex.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.refreshSessionButton = UIUtils.createDialogButton((Composite)btnComposite, (String)GcpCloudUIMessages.gcp_configurator_dialog_button_refresh_session, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GcpUIConfigurationEditor.this.saveSettings(GcpUIConfigurationEditor.this.curConfiguration);
                try {
                    GcpUIConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> GcpUIConfigurationEditor.this.refreshCloudSession(monitor, GcpUIConfigurationEditor.this.curConfiguration));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Session refresh error", "Error during session refresh", ex.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.closeSessionButton = UIUtils.createDialogButton((Composite)btnComposite, (String)GcpCloudUIMessages.gcp_configurator_dialog_button_end_session, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UIUtils.confirmAction((Shell)btnComposite.getShell(), (String)"End SSO Session", (String)"Are you sure you want to end active SSO session?")) {
                    return;
                }
                try {
                    GcpUIConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> GcpUIConfigurationEditor.this.closeCloudSession(monitor, GcpUIConfigurationEditor.this.curConfiguration));
                }
                catch (InvocationTargetException ex) {
                    DBWorkbench.getPlatformUI().showError("Session close error", "Error during session close", ex.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        TabItem regionsTab = new TabItem(parent, 0);
        regionsTab.setText(GcpCloudUIMessages.gcp_configurator_tab_item_authentication);
        regionsTab.setControl((Control)topGroup);
    }

    @NotNull
    public DBRRunnableContext getRunnableContext(TabFolder parent) {
        Object context = parent.getShell().getData() instanceof IRunnableContext ? new RunnableContextDelegate((IRunnableContext)parent.getShell().getData()) : UIUtils.getDialogRunnableContext();
        return context;
    }

    private void testCloudConnection(DBRProgressMonitor monitor, GCPCloudConfiguration cfg) throws InvocationTargetException {
        monitor.beginTask("Test GCP cloud connection", 1);
        GCPCloud cloud = new GCPCloudProvider().createCloudInstance(cfg);
        cloud.getCloudConfiguration().setCloudId("gcp-test-cloud");
        try {
            try {
                String response = cloud.testConnection(monitor);
                UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)GcpCloudUIMessages.gcp_configurator_message_bog_title_success, (String)("Cloud connection established successfully: " + response), (int)2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void refreshCloudSession(DBRProgressMonitor monitor, GCPCloudConfiguration cfg) throws InvocationTargetException {
        monitor.beginTask("Refresh GCP cloud connection", 1);
        GCPCloud cloud = new GCPCloudProvider().createCloudInstance(cfg);
        try {
            try {
                String response = cloud.refreshSession(monitor);
                UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)GcpCloudUIMessages.gcp_configurator_message_bog_title_success, (String)("Cloud session has been refreshed: " + response), (int)2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            UIUtils.asyncExec(this::updateSessionActions);
        }
    }

    private void closeCloudSession(DBRProgressMonitor monitor, GCPCloudConfiguration cfg) throws InvocationTargetException {
        monitor.beginTask("Close GCP cloud connection", 1);
        GCPCloud cloud = new GCPCloudProvider().createCloudInstance(cfg);
        try {
            try {
                cloud.closeSession(monitor);
                UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)GcpCloudUIMessages.gcp_configurator_message_bog_title_success, (String)"Cloud session was terminated", (int)2));
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            UIUtils.asyncExec(this::updateSessionActions);
        }
    }

    private void updateSessionActions() {
        boolean hasSessionToken = false;
        if (this.curConfiguration != null && this.iamConfigurator != null && this.iamConfigurator.isSSOEnabled()) {
            hasSessionToken = new GCPCloudProvider().createCloudInstance(this.curConfiguration).getActiveSession() != null;
        }
        this.refreshSessionButton.setEnabled(hasSessionToken);
        this.closeSessionButton.setEnabled(hasSessionToken);
    }

    public void loadSettings(@NotNull GCPCloudConfiguration configuration) {
        this.curConfiguration = configuration;
        this.mainGroup.setRedraw(false);
        try {
            LinkedHashMap authProperties = new LinkedHashMap();
            AuthModelGCPAbstract.saveCredentialsToMap((AuthModelGCPCredentials)configuration.getCredentials(), authProperties);
            this.iamConfigurator.loadIAMAuthSettings(authProperties);
            this.iamConfigurator.updateControls();
        }
        finally {
            this.mainGroup.setRedraw(true);
        }
        this.updateSessionActions();
    }

    public void saveSettings(@NotNull GCPCloudConfiguration configuration) {
        LinkedHashMap authProperties = new LinkedHashMap();
        this.iamConfigurator.saveIAMAuthSettings(authProperties);
        AuthModelGCPAbstract.loadCredentialsFromMap((AuthModelGCPCredentials)configuration.getCredentials(), authProperties);
    }

    public void resetSettings(@NotNull GCPCloudConfiguration configuration) {
    }

    public boolean isComplete() {
        return this.iamConfigurator.isComplete();
    }
}

