/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.tasks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskSettings
implements DBTTaskSettingsInput<DBSDataContainer> {
    private static final Log log = Log.getLog(DCCompareTaskSettings.class);
    private DBSDataContainer leftContainer;
    private DBSDataContainer rightContainer;
    private DBSAttributeBase[] leftKeys;
    private DBSAttributeBase[] rightKeys;
    private final Map<DBSAttributeBase, DBSAttributeBase> mappings = new HashMap<DBSAttributeBase, DBSAttributeBase>();
    private long comparedRowsLimit = 0L;
    private long differentRowsLimit = 10000L;
    private int fetchSize = 10000;
    private boolean includeModifiedRows = true;
    private boolean includeDeletedRows = true;
    private boolean includeInsertedRows = true;
    private boolean openNewConnections = false;
    private boolean openViewerOnFinish = true;
    private boolean queryRowsCount = false;
    private String outputFilePath;

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> properties) {
        try {
            runnableContext.run(true, true, monitor -> {
                DBPProject project;
                if (!properties.containsKey("project")) {
                    return;
                }
                String projectName = CommonUtils.toString(properties.get("project"));
                DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                if (project == null) {
                    log.error((Object)("Project '" + projectName + "' not found"));
                    return;
                }
                Map objectProperties = JSONUtils.getObject((Map)properties, (String)"first");
                this.leftContainer = this.loadContainer(monitor, project, objectProperties);
                this.leftKeys = this.loadAttributes(monitor, (DBSEntity)this.leftContainer, objectProperties);
                objectProperties = JSONUtils.getObject((Map)properties, (String)"second");
                this.rightContainer = this.loadContainer(monitor, project, objectProperties);
                this.rightKeys = this.loadAttributes(monitor, (DBSEntity)this.rightContainer, objectProperties);
                this.mappings.clear();
                this.mappings.putAll(this.loadMappings(monitor, (DBSEntity)this.leftContainer, (DBSEntity)this.rightContainer, properties));
                this.comparedRowsLimit = CommonUtils.toLong(properties.get("comparedRowsLimit"), (long)0L);
                this.differentRowsLimit = CommonUtils.toLong(properties.get("differentRowsLimit"), (long)10000L);
                this.fetchSize = CommonUtils.toInt(properties.get("fetchSize"), (int)10000);
                this.includeModifiedRows = CommonUtils.getBoolean(properties.get("includeModifiedRows"), (boolean)true);
                this.includeDeletedRows = CommonUtils.getBoolean(properties.get("includeDeletedRows"), (boolean)true);
                this.includeInsertedRows = CommonUtils.getBoolean(properties.get("includeInsertedRows"), (boolean)true);
                this.openNewConnections = CommonUtils.getBoolean(properties.get("openNewConnections"), (boolean)false);
                this.openViewerOnFinish = CommonUtils.getBoolean(properties.get("openViewerOnFinish"), (boolean)true);
                this.queryRowsCount = CommonUtils.getBoolean(properties.get("queryRowsCount"), (boolean)false);
                this.outputFilePath = CommonUtils.toString(properties.get("outputFilePath"), null);
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
    }

    @Nullable
    private DBSDataContainer loadContainer(DBRProgressMonitor monitor, DBPProject project, Map<String, Object> properties) {
        String objectId = CommonUtils.toString((Object)properties.get("objectId"));
        monitor.beginTask("Load object '" + objectId + "'", 1);
        try {
            DBSDataContainer dBSDataContainer = (DBSDataContainer)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)objectId);
            return dBSDataContainer;
        }
        catch (DBException e) {
            log.error((Object)("Can't find object '" + objectId + "' in project '" + project.getName() + "'"), (Throwable)e);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    @Nullable
    private DBSAttributeBase[] loadAttributes(DBRProgressMonitor monitor, DBSEntity entity, Map<String, Object> properties) {
        if (entity == null) {
            return null;
        }
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
        for (String column : JSONUtils.getStringList(properties, (String)"attributes")) {
            DBSAttributeBase attribute = this.loadAttribute(monitor, entity, column, "key");
            if (attribute == null) {
                return null;
            }
            attributes.add(attribute);
        }
        return attributes.toArray(new DBSAttributeBase[0]);
    }

    @NotNull
    private Map<DBSAttributeBase, DBSAttributeBase> loadMappings(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity sourceEntity, @NotNull DBSEntity targetEntity, @NotNull Map<String, Object> properties) {
        HashMap<DBSAttributeBase, DBSAttributeBase> mappings = new HashMap<DBSAttributeBase, DBSAttributeBase>();
        for (Map mapping : JSONUtils.getObjectList(properties, (String)"mappings")) {
            String source = CommonUtils.toString(mapping.get("source"));
            String target = CommonUtils.toString(mapping.get("target"));
            DBSAttributeBase sourceAttribute = this.loadAttribute(monitor, sourceEntity, source, "source");
            DBSAttributeBase targetAttribute = this.loadAttribute(monitor, targetEntity, target, "target");
            if (sourceAttribute == null || targetAttribute == null) continue;
            mappings.put(sourceAttribute, targetAttribute);
        }
        return mappings;
    }

    @Nullable
    private DBSAttributeBase loadAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity sourceEntity, @NotNull String name, @NotNull String which) {
        DBSEntityAttribute attribute;
        try {
            try {
                monitor.beginTask("Load " + which + " attribute '" + name + "'", 1);
                attribute = sourceEntity.getAttribute(monitor, name);
            }
            catch (DBException e) {
                log.error((Object)("Can't load " + which + " attribute '" + name + "'"), (Throwable)e);
                monitor.done();
                return null;
            }
        }
        finally {
            monitor.done();
        }
        if (attribute == null) {
            log.error((Object)("Can't find " + which + " attribute '" + name + "'"));
            return null;
        }
        return attribute;
    }

    public void saveConfiguration(@NotNull Map<String, Object> state) {
        state.put("project", this.leftContainer.getDataSource().getContainer().getProject().getName());
        LinkedHashMap<String, Object> objectProperties = new LinkedHashMap<String, Object>();
        objectProperties.put("objectId", DBUtils.getObjectFullId((DBSObject)this.leftContainer));
        objectProperties.put("attributes", Arrays.stream(this.leftKeys).map(DBPNamedObject::getName).collect(Collectors.toList()));
        state.put("first", objectProperties);
        objectProperties = new LinkedHashMap();
        objectProperties.put("objectId", DBUtils.getObjectFullId((DBSObject)this.rightContainer));
        objectProperties.put("attributes", Arrays.stream(this.rightKeys).map(DBPNamedObject::getName).collect(Collectors.toList()));
        state.put("second", objectProperties);
        ArrayList mappingsProperties = new ArrayList();
        for (Map.Entry<DBSAttributeBase, DBSAttributeBase> entry : this.mappings.entrySet()) {
            LinkedHashMap<String, String> mappingProperties = new LinkedHashMap<String, String>();
            mappingProperties.put("source", entry.getKey().getName());
            mappingProperties.put("target", entry.getValue().getName());
            mappingsProperties.add(mappingProperties);
        }
        state.put("mappings", mappingsProperties);
        if (this.comparedRowsLimit != 0L) {
            state.put("comparedRowsLimit", this.comparedRowsLimit);
        }
        if (this.differentRowsLimit != 0L) {
            state.put("differentRowsLimit", this.differentRowsLimit);
        }
        if (this.fetchSize != 0) {
            state.put("fetchSize", this.fetchSize);
        }
        state.put("includeModifiedRows", this.includeModifiedRows);
        state.put("includeDeletedRows", this.includeDeletedRows);
        state.put("includeInsertedRows", this.includeInsertedRows);
        state.put("openNewConnections", this.openNewConnections);
        state.put("openViewerOnFinish", this.openViewerOnFinish);
        state.put("queryRowsCount", this.queryRowsCount);
        if (!CommonUtils.isEmptyTrimmed((String)this.outputFilePath)) {
            state.put("outputFilePath", this.outputFilePath);
        }
    }

    public void loadSettingsFromInput(List<DBSDataContainer> objects) {
        if (objects.size() > 0) {
            this.leftContainer = objects.get(0);
        }
        if (objects.size() > 1) {
            this.rightContainer = objects.get(1);
        }
        if (objects.size() > 2) {
            log.warn((Object)("Too many containers: " + objects.size()));
        }
    }

    public DBSDataContainer getLeftContainer() {
        return this.leftContainer;
    }

    public void setLeftContainer(DBSDataContainer leftContainer) {
        this.leftContainer = leftContainer;
    }

    public DBSDataContainer getRightContainer() {
        return this.rightContainer;
    }

    public void setRightContainer(DBSDataContainer rightContainer) {
        this.rightContainer = rightContainer;
    }

    public DBSAttributeBase[] getLeftKeys() {
        return this.leftKeys;
    }

    public void setLeftKeys(DBSAttributeBase[] leftKeys) {
        this.leftKeys = leftKeys;
    }

    public DBSAttributeBase[] getRightKeys() {
        return this.rightKeys;
    }

    public void setRightKeys(DBSAttributeBase[] rightKeys) {
        this.rightKeys = rightKeys;
    }

    @NotNull
    public Map<DBSAttributeBase, DBSAttributeBase> getMappings() {
        return this.mappings;
    }

    public void setMappings(@NotNull Map<DBSAttributeBase, DBSAttributeBase> mappings) {
        this.mappings.clear();
        this.mappings.putAll(mappings);
    }

    public long getComparedRowsLimit() {
        return this.comparedRowsLimit;
    }

    public void setComparedRowsLimit(long comparedRowsLimit) {
        this.comparedRowsLimit = comparedRowsLimit;
    }

    public long getDifferentRowsLimit() {
        return this.differentRowsLimit;
    }

    public void setDifferentRowsLimit(long differentRowsLimit) {
        this.differentRowsLimit = differentRowsLimit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isIncludeModifiedRows() {
        return this.includeModifiedRows;
    }

    public void setIncludeModifiedRows(boolean includeModifiedRows) {
        this.includeModifiedRows = includeModifiedRows;
    }

    public boolean isIncludeDeletedRows() {
        return this.includeDeletedRows;
    }

    public void setIncludeDeletedRows(boolean includeDeletedRows) {
        this.includeDeletedRows = includeDeletedRows;
    }

    public boolean isIncludeInsertedRows() {
        return this.includeInsertedRows;
    }

    public void setIncludeInsertedRows(boolean includeInsertedRows) {
        this.includeInsertedRows = includeInsertedRows;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public boolean isOpenViewerOnFinish() {
        return this.openViewerOnFinish;
    }

    public void setOpenViewerOnFinish(boolean openViewerOnFinish) {
        this.openViewerOnFinish = openViewerOnFinish;
    }

    public boolean isQueryRowsCount() {
        return this.queryRowsCount;
    }

    public void setQueryRowsCount(boolean queryRowsCount) {
        this.queryRowsCount = queryRowsCount;
    }

    @Nullable
    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(@Nullable String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }
}

