/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.tasks;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.impl.DCCompareEngineImpl;
import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskHandler
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) {
        DCCompareTaskSettings taskSettings = new DCCompareTaskSettings();
        taskSettings.loadConfiguration(runnableContext, task.getProperties());
        DBCStatistics statistics = new DBCStatistics();
        try {
            runnableContext.run(true, true, monitor -> {
                Exception error;
                DBSDataContainer leftContainer = taskSettings.getLeftContainer();
                DBSDataContainer rightContainer = taskSettings.getRightContainer();
                if (leftContainer == null || rightContainer == null) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "Containers are missing");
                    return;
                }
                DBSAttributeBase[] leftColumns = taskSettings.getLeftKeys();
                DBSAttributeBase[] rightColumns = taskSettings.getRightKeys();
                if (leftColumns == null || rightColumns == null) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "Constraint columns are missing");
                    return;
                }
                if (!(taskSettings.isIncludeModifiedRows() || taskSettings.isIncludeDeletedRows() || taskSettings.isIncludeInsertedRows())) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "At least one row state must be included");
                    return;
                }
                int totalRowsCount = -1;
                if (taskSettings.isQueryRowsCount()) {
                    try {
                        totalRowsCount = (int)this.getMaximumRowsCount(taskSettings, monitor);
                    }
                    catch (DBException e) {
                        DBWorkbench.getPlatformUI().showError("Data Compare", "Error counting rows", (Throwable)e);
                    }
                }
                monitor.beginTask("Compare '" + DBUtils.getObjectFullName((DBPNamedObject)leftContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' <-> '" + DBUtils.getObjectFullName((DBPNamedObject)rightContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'", totalRowsCount);
                Log.setLogWriter((OutputStream)logStream);
                listener.taskStarted(task);
                try {
                    DCInput leftInput = this.createInput(taskSettings, true);
                    DCInput rightInput = this.createInput(taskSettings, false);
                    DCSettings settings = new DCSettings(leftInput, rightInput);
                    settings.setComparedRowsLimit(taskSettings.getComparedRowsLimit());
                    settings.setDifferentRowsLimit(taskSettings.getDifferentRowsLimit());
                    settings.setFetchSize(taskSettings.getFetchSize());
                    settings.setIncludeModifiedRows(taskSettings.isIncludeModifiedRows());
                    settings.setIncludeDeletedRows(taskSettings.isIncludeDeletedRows());
                    settings.setIncludeInsertedRows(taskSettings.isIncludeInsertedRows());
                    settings.setOpenNewConnections(taskSettings.isOpenNewConnections());
                    settings.setOutputLogStream(logStream);
                    if (!CommonUtils.isEmptyTrimmed((String)taskSettings.getOutputFilePath())) {
                        settings.setOutputFile(new File(taskSettings.getOutputFilePath()));
                    }
                    DCCompareEngineImpl engine = new DCCompareEngineImpl();
                    Throwable throwable = null;
                    Object var19_22 = null;
                    try (DCSummary summary = engine.compare(monitor, settings);){
                        log.debug((Object)"--- Data compare result ---");
                        log.debug((Object)(" - Compare Time: " + summary.getCompareTime() + "ms"));
                        log.debug((Object)(" - Inserted Rows Count: " + summary.getInsertedRowsCount()));
                        log.debug((Object)(" - Deleted Rows Count:  " + summary.getDeletedRowsCount()));
                        log.debug((Object)(" - Modified Rows Count: " + summary.getModifiedRowsCount()));
                        log.debug((Object)(" - Total Compared Rows Count:   " + summary.getTotalComparedRowsCount()));
                        log.debug((Object)(" - Total Different Rows Count:  " + summary.getTotalDifferentRowsCount()));
                        log.debug((Object)"--- Data compare result ---");
                        if (settings.getOutputFile() != null) {
                            DBPDataSource dataSource = summary.getSettings().getRightInput().getContainer().getDataSource();
                            DBEPersistAction[] actions = summary.getActions(monitor, false);
                            Throwable throwable2 = null;
                            Object var24_29 = null;
                            try (FileWriter writer = new FileWriter(settings.getOutputFile());){
                                writer.write(SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])actions, (boolean)false));
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        listener.taskFinished(task, (Object)summary, null, (Object)settings);
                        statistics.accumulate(summary.getStatistics());
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    monitor.worked(1);
                    return;
                }
                catch (Exception e) {
                    error = e;
                }
                finally {
                    monitor.done();
                    Log.setLogWriter(null);
                }
                listener.taskFinished(task, null, (Throwable)error, (Object)taskSettings);
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data Compare", "Error comparing data", e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
        return DBTTaskRunStatus.makeStatisticsStatus((DBCStatistics)statistics);
    }

    @NotNull
    private DCInput createInput(@NotNull DCCompareTaskSettings settings, boolean left) {
        DBSDataContainer container = left ? settings.getLeftContainer() : settings.getRightContainer();
        DBSAttributeBase[] keys = left ? settings.getLeftKeys() : settings.getRightKeys();
        return new DCInput(container, keys, settings.getMappings(), this.createFilter(keys));
    }

    @NotNull
    private DBDDataFilter createFilter(@NotNull DBSAttributeBase[] attributes) {
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        DBSAttributeBase[] dBSAttributeBaseArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSAttributeBase attribute = dBSAttributeBaseArray[n2];
            int position = constraints.size() + 1;
            DBDAttributeConstraint constraint = new DBDAttributeConstraint(attribute, position);
            constraint.setOrderPosition(position);
            constraints.add(constraint);
            ++n2;
        }
        return new DBDDataFilter(constraints);
    }

    private long getMaximumRowsCount(@NotNull DCCompareTaskSettings settings, @NotNull DBRProgressMonitor monitor) throws DBException {
        long leftContainerRowsCount = this.getRowsCount(settings.getLeftContainer(), monitor);
        long rightContainerRowsCount = this.getRowsCount(settings.getRightContainer(), monitor);
        long totalRowsCount = Math.min(leftContainerRowsCount, rightContainerRowsCount);
        if (settings.getComparedRowsLimit() > 0L) {
            totalRowsCount = Math.min(totalRowsCount, settings.getComparedRowsLimit());
        }
        if (settings.getDifferentRowsLimit() > 0L) {
            totalRowsCount = Math.min(totalRowsCount, settings.getDifferentRowsLimit());
        }
        return totalRowsCount;
    }

    private long getRowsCount(@NotNull DBSDataContainer container, @NotNull DBRProgressMonitor monitor) throws DBException {
        DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
        AbstractExecutionSource source = new AbstractExecutionSource(container, context, (Object)this);
        Throwable throwable = null;
        Object var6_7 = null;
        try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Count rows for data compare");){
            return container.countData((DBCExecutionSource)source, session, null, 0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

