/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class DCSummaryImpl
implements DCSummary {
    private final DCSettings settings;
    private final DCRowDiff[] changes;
    private final DBCStatistics statistics;
    private long totalComparedRowsCount;
    private long insertedRowsCount;
    private long deletedRowsCount;
    private long modifiedRowsCount;
    private long compareTime;
    private boolean success;

    public DCSummaryImpl(@NotNull DCSettings settings, @NotNull DCRowDiff[] changes, @NotNull DBCStatistics statistics) {
        this.settings = settings;
        this.changes = changes;
        this.statistics = statistics;
    }

    @Override
    @NotNull
    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public long getCompareTime() {
        return this.compareTime;
    }

    public void setCompareTime(long compareTime) {
        this.compareTime = compareTime;
    }

    @Override
    public long getInsertedRowsCount() {
        return this.insertedRowsCount;
    }

    public void setInsertedRowsCount(long insertedRowsCount) {
        this.insertedRowsCount = insertedRowsCount;
    }

    @Override
    public long getDeletedRowsCount() {
        return this.deletedRowsCount;
    }

    public void setDeletedRowsCount(long deletedRowsCount) {
        this.deletedRowsCount = deletedRowsCount;
    }

    @Override
    public long getModifiedRowsCount() {
        return this.modifiedRowsCount;
    }

    public void setModifiedRowsCount(long modifiedRowsCount) {
        this.modifiedRowsCount = modifiedRowsCount;
    }

    @Override
    public long getTotalComparedRowsCount() {
        return this.totalComparedRowsCount;
    }

    public void setTotalComparedRowsCount(long comparedRowsCount) {
        this.totalComparedRowsCount = comparedRowsCount;
    }

    @Override
    public long getTotalDifferentRowsCount() {
        return this.changes.length;
    }

    @Override
    @NotNull
    public DCSettings getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public DBEPersistAction[] getActions(@NotNull DBRProgressMonitor monitor, boolean left) throws DBException {
        ArrayList actions = new ArrayList(this.changes.length);
        DCInput input = left ? this.settings.getLeftInput() : this.settings.getRightInput();
        DBSDataContainer container = input.getContainer();
        if (container instanceof DBSDataManipulator) {
            monitor.beginTask("Generate persist actions for SQL diff", this.changes.length);
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Collect diff actions");){
                    DBSDataManipulator manipulator = (DBSDataManipulator)container;
                    ExecutionSource source = new ExecutionSource(input);
                    DCRowDiff[] changes = (DCRowDiff[])this.changes.clone();
                    Arrays.sort(changes, Comparator.comparing(DCRowDiff::getState));
                    DCRowDiff[] dCRowDiffArray = changes;
                    int n = changes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBSDataManipulator.ExecuteBatch batch;
                        DCRowDiff change = dCRowDiffArray[n2];
                        DBSAttributeBase[] sourceAttributes = DBDAttributeValue.getAttributes((DBDAttributeValue[])change.getSourceValues());
                        DBSAttributeBase[] targetAttributes = DBDAttributeValue.getAttributes((DBDAttributeValue[])change.getTargetValues());
                        DBSAttributeBase[] keyAttributes = DBDAttributeValue.getAttributes((DBDAttributeValue[])change.getKeys());
                        Object[] sourceValues = DBDAttributeValue.getValues((DBDAttributeValue[])change.getSourceValues());
                        DBDAttributeValue.getValues((DBDAttributeValue[])change.getTargetValues());
                        Object[] keyValues = DBDAttributeValue.getValues((DBDAttributeValue[])change.getKeys());
                        switch (change.getState().getRelativeTo(left)) {
                            case INSERTED: {
                                batch = manipulator.insertData(session, sourceAttributes, null, (DBCExecutionSource)source, Collections.emptyMap());
                                batch.add(sourceValues);
                                break;
                            }
                            case DELETED: {
                                batch = manipulator.deleteData(session, keyAttributes, (DBCExecutionSource)source);
                                batch.add(keyValues);
                                break;
                            }
                            default: {
                                batch = manipulator.updateData(session, targetAttributes, keyAttributes, null, (DBCExecutionSource)source);
                                batch.add(ArrayUtils.concatArrays((Object[])sourceValues, (Object[])keyValues));
                            }
                        }
                        batch.generatePersistActions(session, actions, Collections.emptyMap());
                        monitor.worked(1);
                        ++n2;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        return actions.toArray(new DBEPersistAction[0]);
    }

    @Override
    @NotNull
    public Iterator<DCRowDiff> iterator() {
        return new Iterator<DCRowDiff>(){
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < DCSummaryImpl.this.changes.length;
            }

            @Override
            public DCRowDiff next() {
                if (this.hasNext()) {
                    return DCSummaryImpl.this.changes[this.offset++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void close() {
    }

    private static class ExecutionSource
    implements DBCExecutionSource {
        private final DCInput input;

        public ExecutionSource(@NotNull DCInput input) {
            this.input = input;
        }

        @Nullable
        public DBSDataContainer getDataContainer() {
            return this.input.getContainer();
        }

        @Nullable
        public Object getExecutionController() {
            return null;
        }

        @Nullable
        public Object getSourceDescriptor() {
            return null;
        }

        @Nullable
        public DBCScriptContext getScriptContext() {
            return null;
        }
    }
}

