/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCCompareEngine;
import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.model.DCRowState;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.impl.DCSummaryImpl;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareEngineImpl
implements DCCompareEngine {
    private static final Log log = Log.getLog(DCCompareEngineImpl.class);
    private Phaser phaser;
    private Receiver leftReceiver;
    private Receiver rightReceiver;
    private volatile boolean terminated;
    private List<DCRowDiff> diff;
    private long comparedRowsCount = 0L;
    private long insertedRowsCount = 0L;
    private long deletedRowsCount = 0L;
    private long modifiedRowsCount = 0L;

    @Override
    @NotNull
    public DCSummary compare(final @NotNull DBRProgressMonitor monitor, final @NotNull DCSettings settings) throws DBException {
        this.phaser = new Phaser(2){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                log.info((Object)"Comparing next segments");
                long comparedRows = DCCompareEngineImpl.this.compareSegment(monitor, settings);
                monitor.worked((int)comparedRows);
                return super.onAdvance(phase, registeredParties);
            }
        };
        this.leftReceiver = new Receiver(monitor, settings, settings.getLeftInput());
        this.rightReceiver = new Receiver(monitor, settings, settings.getRightInput());
        this.diff = new ArrayList<DCRowDiff>();
        long compareTimeStart = System.currentTimeMillis();
        this.leftReceiver.schedule();
        this.rightReceiver.schedule();
        while (!this.phaser.isTerminated()) {
            this.phaser.awaitAdvance(this.phaser.getPhase());
        }
        DBCStatistics totalStatistics = new DBCStatistics();
        totalStatistics.accumulate(this.leftReceiver.getStatistics());
        totalStatistics.accumulate(this.rightReceiver.getStatistics());
        DCSummaryImpl summary = new DCSummaryImpl(settings, this.diff.toArray(new DCRowDiff[0]), totalStatistics);
        summary.setSuccess(true);
        summary.setCompareTime(System.currentTimeMillis() - compareTimeStart);
        summary.setTotalComparedRowsCount(this.comparedRowsCount);
        summary.setInsertedRowsCount(this.insertedRowsCount);
        summary.setDeletedRowsCount(this.deletedRowsCount);
        summary.setModifiedRowsCount(this.modifiedRowsCount);
        return summary;
    }

    private long compareSegment(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) {
        Receiver.Row row;
        long comparedRowsCountBefore = this.comparedRowsCount;
        while (this.leftReceiver.isAvailable() && this.rightReceiver.isAvailable() && this.verifyLimits(monitor, settings)) {
            Map<DBDAttributeValue, DBDAttributeValue> differences;
            Receiver.Row rightRow;
            ++this.comparedRowsCount;
            Receiver.Row leftRow = this.leftReceiver.poll();
            int keys = leftRow.compareKeys(rightRow = this.rightReceiver.poll());
            if (keys != 0) {
                if (keys < 0) {
                    this.rightReceiver.push(rightRow);
                    if (!settings.isIncludeDeletedRows()) continue;
                    this.diff.add(new DCRowDiff(DCRowState.DELETED, leftRow.getKeyValues(), leftRow.getAllValues(), leftRow.position));
                    ++this.deletedRowsCount;
                    continue;
                }
                this.leftReceiver.push(leftRow);
                if (!settings.isIncludeInsertedRows()) continue;
                this.diff.add(new DCRowDiff(DCRowState.INSERTED, rightRow.getKeyValues(), rightRow.getAllValues(), rightRow.position));
                ++this.insertedRowsCount;
                continue;
            }
            if (!settings.isIncludeModifiedRows() || (differences = leftRow.compareValues(rightRow, settings.getLeftInput().getMappings())).isEmpty()) continue;
            DBDAttributeValue[] sourceValues = differences.keySet().toArray(new DBDAttributeValue[0]);
            DBDAttributeValue[] targetValues = differences.values().toArray(new DBDAttributeValue[0]);
            this.diff.add(new DCRowDiff(DCRowState.MODIFIED, leftRow.getKeyValues(), sourceValues, targetValues, rightRow.position));
            ++this.modifiedRowsCount;
        }
        while (this.leftReceiver.isAvailable() && this.leftReceiver.isClosed() && this.verifyLimits(monitor, settings)) {
            ++this.comparedRowsCount;
            row = this.leftReceiver.poll();
            if (!settings.isIncludeDeletedRows()) continue;
            ++this.deletedRowsCount;
            this.diff.add(new DCRowDiff(DCRowState.DELETED, row.getKeyValues(), row.getAllValues(), row.position));
        }
        while (this.rightReceiver.isAvailable() && this.rightReceiver.isClosed() && this.verifyLimits(monitor, settings)) {
            ++this.comparedRowsCount;
            row = this.rightReceiver.poll();
            if (!settings.isIncludeInsertedRows()) continue;
            ++this.insertedRowsCount;
            this.diff.add(new DCRowDiff(DCRowState.INSERTED, row.getKeyValues(), row.getAllValues(), row.position));
        }
        if (!this.verifyLimits(monitor, settings)) {
            this.terminated = true;
        }
        return this.comparedRowsCount - comparedRowsCountBefore;
    }

    private boolean verifyLimits(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) {
        long comparedRowsLimit = settings.getComparedRowsLimit();
        long differentRowsLimit = settings.getDifferentRowsLimit();
        if (comparedRowsLimit != 0L && comparedRowsLimit <= this.comparedRowsCount) {
            return false;
        }
        if (differentRowsLimit != 0L && differentRowsLimit <= (long)this.diff.size()) {
            return false;
        }
        return !monitor.isCanceled();
    }

    private static int[] getAttributesPositions(@NotNull DBRProgressMonitor monitor, @NotNull DCInput input) throws DBException {
        DBSAttributeBase[] attributes = input.getKeys();
        DBSEntity entity = (DBSEntity)input.getContainer();
        int[] positions = new int[attributes.length];
        int index = 0;
        while (index < attributes.length) {
            positions[index] = DCCompareEngineImpl.getAttributePosition(monitor, entity, attributes[index]);
            ++index;
        }
        return positions;
    }

    private static int getAttributePosition(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull DBSAttributeBase attribute) throws DBException {
        return CommonUtils.safeList((List)entity.getAttributes(monitor)).stream().map(x -> x).filter(x -> !DBUtils.isPseudoAttribute((DBSAttributeBase)x) && !DBUtils.isHiddenObject((Object)x)).collect(Collectors.toList()).indexOf(attribute);
    }

    private class Receiver
    extends AbstractJob
    implements DBDDataReceiver {
        private final DBCStatistics statistics;
        private final DCSettings settings;
        private final DCInput input;
        private final Deque<Row> rows;
        private final int[] keys;
        private DBDAttributeBinding[] attributes;
        private DBDValueHandler[] handlers;
        private long offset;
        private boolean closed;

        private Receiver(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings, DCInput input) throws DBException {
            super("Data Compare Receiver [" + DBUtils.getObjectFullName((DBPNamedObject)input.getContainer(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "]");
            this.statistics = new DBCStatistics();
            this.settings = settings;
            this.input = input;
            this.rows = new ArrayDeque<Row>(settings.getFetchSize());
            this.keys = DCCompareEngineImpl.getAttributesPositions(monitor, input);
        }

        @NotNull
        public DBCStatistics getStatistics() {
            return this.statistics;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            DBSDataContainer dataContainer = this.input.getContainer();
            DBDDataFilter filter = this.input.getFilter();
            DBPDataSourceContainer dataSourceContainer = DBUtils.getContainer((DBSObject)dataContainer);
            boolean isDriverForeign = dataSourceContainer == null || !dataSourceContainer.getDriver().isEmbedded();
            boolean useIsolatedContext = this.settings.isOpenNewConnections() || isDriverForeign;
            DBCExecutionContext executionContext = null;
            DBCSession targetSession = null;
            try {
                try {
                    Log.setLogWriter((OutputStream)this.settings.getOutputLogStream());
                    monitor.beginTask("Read data to compare", 1);
                    executionContext = useIsolatedContext ? DBUtils.getObjectOwnerInstance((DBSObject)dataContainer).openIsolatedContext(monitor, "Data compare", null) : DBUtils.getDefaultContext((DBSObject)dataContainer, (boolean)false);
                    targetSession = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Data compare data read");
                    targetSession.enableLogging(false);
                    AbstractExecutionSource source = new AbstractExecutionSource(dataContainer, executionContext, (Object)this);
                    this.statistics.accumulate(dataContainer.readData((DBCExecutionSource)source, targetSession, (DBDDataReceiver)this, filter, 0L, 0L, 0L, 0));
                    monitor.worked(1);
                }
                catch (TerminationException terminationException) {
                    if (executionContext != null && useIsolatedContext) {
                        executionContext.close();
                    }
                    if (targetSession != null) {
                        targetSession.close();
                    }
                    monitor.done();
                    Log.setLogWriter(null);
                }
                catch (Throwable e) {
                    IStatus iStatus;
                    block13: {
                        DCCompareEngineImpl.this.phaser.forceTermination();
                        iStatus = GeneralUtils.makeErrorStatus((String)"Error reading data", (Throwable)e);
                        if (executionContext == null || !useIsolatedContext) break block13;
                        executionContext.close();
                    }
                    if (targetSession != null) {
                        targetSession.close();
                    }
                    monitor.done();
                    Log.setLogWriter(null);
                    return iStatus;
                }
            }
            finally {
                if (executionContext != null && useIsolatedContext) {
                    executionContext.close();
                }
                if (targetSession != null) {
                    targetSession.close();
                }
                monitor.done();
                Log.setLogWriter(null);
            }
            return Status.OK_STATUS;
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.attributes = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.input.getContainer(), (DBCResultSetMetaData)resultSet.getMeta());
            this.handlers = (DBDValueHandler[])Arrays.stream(this.attributes).map(x -> DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)x)).toArray(DBDValueHandler[]::new);
            this.offset = offset;
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
            if (this.settings.getFetchSize() != 0 && this.settings.getFetchSize() <= this.rows.size()) {
                log.info((Object)(String.valueOf(this.getName()) + ": Segment is ready (" + this.rows.size() + ")"));
                DCCompareEngineImpl.this.phaser.arriveAndAwaitAdvance();
            }
            if (this.isCanceled() || DCCompareEngineImpl.this.terminated) {
                throw new TerminationException("Fetch was terminated");
            }
            Object[] values = new Object[this.attributes.length];
            int index = 0;
            while (index < this.attributes.length) {
                values[index] = this.handlers[index].getValueFromObject(session, (DBSTypedObject)this.attributes[index], resultSet.getAttributeValue(index), false, false);
                ++index;
            }
            this.rows.add(new Row(this.offset, values));
            ++this.offset;
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) {
        }

        public void close() {
            log.info((Object)(String.valueOf(this.getName()) + ": Terminated, sending last segment (" + this.rows.size() + ")"));
            this.closed = true;
            DCCompareEngineImpl.this.phaser.arriveAndDeregister();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isAvailable() {
            return !this.rows.isEmpty();
        }

        @NotNull
        public Row poll() {
            return this.rows.removeFirst();
        }

        public void push(@NotNull Row row) {
            this.rows.offerFirst(row);
        }

        private class Row {
            private final long position;
            private final Object[] values;

            public Row(@NotNull long position, Object[] values) {
                this.position = position;
                this.values = values;
            }

            public int compareKeys(@NotNull Row other) {
                int index = 0;
                while (index < Receiver.this.keys.length) {
                    Object value = this.values[Receiver.this.keys[index]];
                    Object otherValue = other.values[other.getKeys()[index]];
                    int result = DBUtils.compareDataValues((Object)value, (Object)otherValue);
                    if (result != 0) {
                        return result;
                    }
                    ++index;
                }
                return 0;
            }

            @NotNull
            public Map<DBDAttributeValue, DBDAttributeValue> compareValues(@NotNull Row other, @NotNull Map<DBSAttributeBase, DBSAttributeBase> mappings) {
                HashMap<DBDAttributeValue, DBDAttributeValue> differences = new HashMap<DBDAttributeValue, DBDAttributeValue>();
                for (Map.Entry<DBSAttributeBase, DBSAttributeBase> mapping : mappings.entrySet()) {
                    Object targetValue;
                    Object sourceValue = DBUtils.getAttributeValue((DBDAttributeBinding)Objects.requireNonNull(DBUtils.findBinding((DBDAttributeBinding[])Receiver.this.attributes, (DBSAttributeBase)mapping.getKey())), (DBDAttributeBinding[])Receiver.this.attributes, (Object[])this.values);
                    if (Objects.equals(sourceValue, targetValue = DBUtils.getAttributeValue((DBDAttributeBinding)Objects.requireNonNull(DBUtils.findBinding((DBDAttributeBinding[])other.getAttributes(), (DBSAttributeBase)mapping.getValue())), (DBDAttributeBinding[])other.getAttributes(), (Object[])other.values))) continue;
                    differences.put(new DBDAttributeValue(mapping.getKey(), sourceValue), new DBDAttributeValue(mapping.getValue(), targetValue));
                }
                return differences;
            }

            @NotNull
            public DBDAttributeValue[] getAllValues() {
                DBDAttributeValue[] values = new DBDAttributeValue[Receiver.this.attributes.length];
                int i = 0;
                while (i < values.length) {
                    values[i] = new DBDAttributeValue((DBSAttributeBase)Receiver.this.attributes[i], this.values[i]);
                    ++i;
                }
                return values;
            }

            @NotNull
            public DBDAttributeValue[] getKeyValues() {
                DBDAttributeValue[] values = new DBDAttributeValue[Receiver.this.keys.length];
                int i = 0;
                while (i < values.length) {
                    values[i] = new DBDAttributeValue((DBSAttributeBase)Receiver.this.attributes[Receiver.this.keys[i]], this.values[Receiver.this.keys[i]]);
                    ++i;
                }
                return values;
            }

            @NotNull
            private int[] getKeys() {
                return Receiver.this.keys;
            }

            @NotNull
            private DBDAttributeBinding[] getAttributes() {
                return Receiver.this.attributes;
            }
        }

        private class TerminationException
        extends DBCException {
            public TerminationException(String message) {
                super(message);
            }
        }
    }
}

