/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model;

import com.dbeaver.data.compare.model.DCRowState;
import java.util.Arrays;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;

public class DCRowDiff {
    private final DCRowState state;
    private final DBDAttributeValue[] keys;
    private final DBDAttributeValue[] sourceValues;
    private final DBDAttributeValue[] targetValues;
    private final long position;

    public DCRowDiff(@NotNull DCRowState state, @NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues, @NotNull DBDAttributeValue[] targetValues, long position) {
        this.state = state;
        this.keys = keys;
        this.sourceValues = sourceValues;
        this.targetValues = targetValues;
        this.position = position;
    }

    public DCRowDiff(@NotNull DCRowState state, @NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] values, long position) {
        this(state, keys, values, values, position);
    }

    @NotNull
    public DCRowState getState() {
        return this.state;
    }

    @NotNull
    public DBDAttributeValue[] getKeys() {
        return this.keys;
    }

    @NotNull
    public DBDAttributeValue[] getSourceValues() {
        return this.sourceValues;
    }

    @NotNull
    public DBDAttributeValue[] getTargetValues() {
        return this.targetValues;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DCRowDiff diff = (DCRowDiff)o;
        return this.position == diff.position && this.state == diff.state && Arrays.equals(this.keys, diff.keys) && Arrays.equals(this.sourceValues, diff.sourceValues) && Arrays.equals(this.targetValues, diff.targetValues);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.state, this.position});
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.sourceValues);
        result = 31 * result + Arrays.hashCode(this.targetValues);
        return result;
    }
}

