/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.gcp.auth;

import com.dbeaver.net.auth.gcp.AuthModelGCP;
import com.dbeaver.net.auth.gcp.AuthModelGCPAbstract;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AuthModelGoogleSQL
extends AuthModelGCPAbstract {
    public static final String ID = "gcp_sql_iam";
    private static final Log log = Log.getLog(AuthModelGCP.class);

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelGCPCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (configuration.getAuthProperties() != null && CommonUtils.getBoolean((String)((String)configuration.getAuthProperties().get("gcp.iam_auth")), (boolean)Boolean.FALSE)) {
            connProperties.put("enableIamAuth", Boolean.TRUE.toString());
            connProperties.put("sslmode", "disable");
            connProperties.put("password", "password");
        }
        credentials.initializeConnection(monitor);
        try {
            String credFactoryClassName = "com.dbeaver.net.auth.google.ServiceAccountCredentialsFactory";
            Object driverInstance = dataSource.getContainer().getDriver().getDriverInstance(monitor);
            ClassLoader classLoader = driverInstance.getClass().getClassLoader();
            Class<?> credFactoryClass = classLoader.loadClass(credFactoryClassName);
            Method setStaticCredentialsPathMethod = credFactoryClass.getMethod("setStaticCredentialsPath", String.class);
            Method setStaticTokenMethod = credFactoryClass.getMethod("setStaticToken", String.class);
            if (credentials.getAuthType() == GCPAuthType.SERVICE_ACCOUNT) {
                setStaticCredentialsPathMethod.invoke(null, credentials.getServiceAccountConfigPath());
                System.setProperty("cloudSql.socketFactory.credentialFactory", credFactoryClassName);
            } else if (credentials.getAuthType() == GCPAuthType.SSO_OVER_CLI && CommonUtils.isNotEmpty((String)credentials.getToken())) {
                setStaticTokenMethod.invoke(null, credentials.getToken());
                System.setProperty("cloudSql.socketFactory.credentialFactory", credFactoryClassName);
            } else {
                setStaticCredentialsPathMethod.invoke(null, new Object[1]);
                System.clearProperty("cloudSql.socketFactory.credentialFactory");
            }
            Class<?> csfClass = classLoader.loadClass("com.google.cloud.sql.core.CoreSocketFactory");
            Field coreSocketFactoryField = csfClass.getDeclaredField("coreSocketFactory");
            coreSocketFactoryField.setAccessible(true);
            coreSocketFactoryField.set(null, null);
        }
        catch (Exception exception) {
            log.debug((Object)"Error resetting GCP core socket factory");
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelGCPCredentials credentials) throws DBException {
        credentials.refreshSession(monitor);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

