/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.s3.internal.signing.S3SigningUtils;
import software.amazon.awssdk.services.s3.model.S3Request;

@SdkInternalApi
public final class SignerOverrideInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        return S3SigningUtils.internalSignerOverride((S3Request)context.request()).map(signer -> this.setRequestOverrideSignerIfNotExist(context.request(), (Signer)signer, executionAttributes)).orElseGet(() -> ((Context.ModifyRequest)context).request());
    }

    private SdkRequest setRequestOverrideSignerIfNotExist(SdkRequest request, Signer signer, ExecutionAttributes executionAttributes) {
        if (this.existsOverrideSigner(request, executionAttributes)) {
            return request;
        }
        return this.setOverrideSigner(request, signer);
    }

    private boolean existsOverrideSigner(SdkRequest request, ExecutionAttributes executionAttributes) {
        Optional<Object> isClientSignerOverridden = Optional.ofNullable(executionAttributes.getAttribute(SdkExecutionAttribute.SIGNER_OVERRIDDEN));
        Optional requestSigner = request.overrideConfiguration().flatMap(RequestOverrideConfiguration::signer);
        return isClientSignerOverridden.isPresent() || requestSigner.isPresent();
    }

    private SdkRequest setOverrideSigner(SdkRequest request, Signer signer) {
        return request.overrideConfiguration().flatMap(config -> config.signer().map(existingOverrideSigner -> request)).orElseGet(() -> this.createNewRequest(request, signer));
    }

    private SdkRequest createNewRequest(SdkRequest request, Signer signer) {
        return ((AwsRequest)request).toBuilder().overrideConfiguration(c -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)c.signer(signer);
        }).build();
    }
}

