/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class NetezzaGenericView
extends GenericView
implements DBPOverloadedObject {
    private String tableType;
    private Date createDate;
    private String owner;
    private String schema;

    NetezzaGenericView(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        this.tableType = tableType;
        if (dbResult != null) {
            this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATEDATE");
            this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
            this.schema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEM");
        }
    }

    @Property(viewable=true, order=7)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, order=8)
    public String getOwner() {
        return this.owner;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public boolean isSystem() {
        return this.tableType.equals("SYSTEM VIEW") || this.tableType.equals("MANAGEMENT VIEW");
    }

    @NotNull
    public String getOverloadedName() {
        if (((NetezzaDataSourceExt)this.getDataSource()).showOwnerNamesForTables()) {
            return String.valueOf(this.getCatalog().getName()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.owner) + "." + this.getName();
        }
        if (((GenericDataSource)this.getDataSource()).getContainer().getNavigatorSettings().isMergeEntities()) {
            return DBUtils.getObjectFullName((DBPNamedObject)this, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        return this.getName();
    }
}

