/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaGenericTable;
import com.dbeaver.db.netezza.model.NetezzaTableCache;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class NetezzaGenericSchema
extends GenericSchema
implements DBPObjectStatisticsCollector,
DBPQualifiedObject {
    private static final Log log = Log.getLog(NetezzaGenericSchema.class);
    private String name;
    private long schemaId;
    private String owner;
    private Date createDate;
    private volatile boolean hasStatistics;

    public NetezzaGenericSchema(@NotNull GenericDataSource dataSource, @NotNull GenericCatalog catalog, String schemaName, long schemaId, String owner, Date createDate) {
        super(dataSource, catalog, schemaName);
        this.name = schemaName;
        this.schemaId = schemaId;
        this.owner = owner;
        this.createDate = createDate;
    }

    public NetezzaGenericSchema(@NotNull GenericDataSource dataSource, @NotNull GenericCatalog catalog, String schemaName) {
        super(dataSource, catalog, schemaName);
        this.name = schemaName;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableCache createTableCache(GenericDataSource datasource) {
        return new NetezzaTableCache(datasource);
    }

    @Property(viewable=false)
    public long getSchemaId() {
        return this.schemaId;
    }

    @Property(viewable=true)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false)
    public Date getCreateDate() {
        return this.createDate;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics || forceRefresh) {
            return;
        }
        GenericCatalog catalog = this.getCatalog();
        if (catalog == null) {
            throw new DBCException("No catalog!");
        }
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                    String curSessionCatalog = session.getCatalog();
                    if (catalog.getName() != null && !CommonUtils.equalObjects((Object)curSessionCatalog, (Object)catalog.getName())) {
                        session.setCatalog(catalog.getName());
                    } else {
                        curSessionCatalog = null;
                    }
                    try {
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * from " + DBUtils.getQuotedIdentifier((DBSObject)this.getCatalog()) + ".DEFINITION_SCHEMA._V_TABLE_STORAGE_STAT WHERE SCHEMA=?");){
                            dbStat.setString(1, this.getName());
                            Throwable throwable3 = null;
                            Object var13_19 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.next()) {
                                    String tableName = dbResult.getString("TABLENAME");
                                    GenericTableBase table = this.getTable(monitor, tableName);
                                    if (!(table instanceof NetezzaGenericTable)) continue;
                                    ((NetezzaGenericTable)table).fetchStatistics(dbResult);
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (curSessionCatalog != null) {
                            try {
                                session.setCatalog(curSessionCatalog);
                            }
                            catch (Exception e) {
                                log.debug((Object)e);
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.hasStatistics = false;
        return super.refreshObject(monitor);
    }

    public List<NetezzaGenericTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        return super.getPhysicalTables(monitor);
    }

    public List<NetezzaGenericTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return super.getTables(monitor);
    }

    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return NetezzaGenericTable.class;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this});
    }
}

