/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.model;

import com.dbeaver.ee.mockdata.engine.internal.MockDataMessages;
import com.dbeaver.ee.mockdata.engine.model.MockValueGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.datatype.DataTypeAbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class MockGeneratorDescriptor
extends DataTypeAbstractDescriptor<MockValueGenerator> {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.mockGenerator";
    public static final String BOOLEAN_RANDOM_GENERATOR_ID = "booleanRandomGenerator";
    public static final String DATETIME_RANDOM_GENERATOR_ID = "dateRandomGenerator";
    public static final String NUMERIC_ADVANCED_GENERATOR_ID = "numericAdvancedGenerator";
    public static final String STRING_TEXT_GENERATOR_ID = "stringTextGenerator";
    public static final String ZERO_GENERATOR_ID = "zeroGenerator";
    public static final String TAG_PRESET = "preset";
    private Preset preset;
    private String label;
    private String description;
    private final String link;
    private final String url;
    private final DBPImage icon;
    private List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private List<Preset> presets = new ArrayList<Preset>();
    private List<String> tags = new ArrayList<String>();
    private String[] replaces;

    public MockGeneratorDescriptor(IConfigurationElement config) {
        super(config, MockValueGenerator.class);
        List<String> tags;
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.link = config.getAttribute("link");
        this.url = config.getAttribute("url");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        String replacesAttr = config.getAttribute("replaces");
        if (!CommonUtils.isEmpty((String)replacesAttr)) {
            this.replaces = replacesAttr.split("\\.");
        }
        if (!ZERO_GENERATOR_ID.equals(this.getId())) {
            IConfigurationElement[] iConfigurationElementArray = config.getChildren("propertyGroup");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement prop = iConfigurationElementArray[n2];
                this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
                ++n2;
            }
            iConfigurationElementArray = config.getChildren(TAG_PRESET);
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                IConfigurationElement preset = iConfigurationElementArray[n2];
                this.presets.add(new Preset(preset.getAttribute("id"), preset.getAttribute("label"), preset.getAttribute("mnemonics"), preset.getAttribute("description"), PropertyDescriptor.extractProperties((IConfigurationElement)preset), this.extractTags(preset)));
                ++n2;
            }
            if (this.getSupportedTypes().contains(DBPDataKind.STRING)) {
                this.properties.add((DBPPropertyDescriptor)new PropertyDescriptor("General", "lowercase", MockDataMessages.tools_mockdata_prop_lowercase_label, null, false, PropertyDescriptor.PropertyType.t_boolean.getValueType(), (Object)false, null));
                this.properties.add((DBPPropertyDescriptor)new PropertyDescriptor("General", "uppercase", MockDataMessages.tools_mockdata_prop_uppercase_label, null, false, PropertyDescriptor.PropertyType.t_boolean.getValueType(), (Object)false, null));
            }
            this.properties.add((DBPPropertyDescriptor)new PropertyDescriptor("General", "nulls", MockDataMessages.tools_mockdata_prop_nulls_label, MockDataMessages.tools_mockdata_prop_nulls_description, false, PropertyDescriptor.PropertyType.t_integer.getValueType(), (Object)0, null));
        }
        if ((tags = this.extractTags(config)) != null) {
            this.tags = tags;
        }
    }

    public String[] getReplaces() {
        return this.replaces;
    }

    public MockGeneratorDescriptor(IConfigurationElement config, Preset preset) {
        this(config);
        this.preset = preset;
        this.label = "   " + preset.label;
        if (!CommonUtils.isEmpty((String)preset.description)) {
            this.description = preset.description;
        }
        for (DBPPropertyDescriptor prop : preset.getProperties()) {
            this.setDefaultProperty(prop.getId(), prop.getDefaultValue());
        }
        if (preset.getTags() != null) {
            this.tags.addAll(preset.getTags());
        }
        this.presets.clear();
    }

    private List<String> extractTags(IConfigurationElement config) {
        String tagsAttr = config.getAttribute("tags");
        if (!CommonUtils.isEmpty((String)tagsAttr)) {
            return Arrays.asList((String[])tagsAttr.split(",").clone());
        }
        return null;
    }

    private void setDefaultProperty(Object id, Object defaultValue) {
        for (DBPPropertyDescriptor property : this.properties) {
            if (!property.getId().equals(id)) continue;
            ((PropertyDescriptor)property).setDefaultValue(defaultValue);
            break;
        }
    }

    public String getId() {
        if (this.preset != null) {
            return String.valueOf(super.getId()) + "_" + this.preset.id;
        }
        return super.getId();
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String getLink() {
        return this.link;
    }

    public String getUrl() {
        return this.url;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public DBPPropertyDescriptor getProperty(Object id) {
        for (DBPPropertyDescriptor descriptor : this.getProperties()) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }

    public boolean supportsType(DBSTypedObject typedObject) {
        return typedObject.getDataKind() == DBPDataKind.STRING || super.supportsType(typedObject);
    }

    @NotNull
    public MockValueGenerator createGenerator() {
        return (MockValueGenerator)this.createInstance();
    }

    public List<Preset> getPresets() {
        return this.presets;
    }

    public static class Preset {
        private final String id;
        private final String label;
        private final String mnemonics;
        private final String description;
        private final List<DBPPropertyDescriptor> properties;
        private List<String> tags = new ArrayList<String>();

        public Preset(String id, String label, String mnemonics, String description, List<DBPPropertyDescriptor> properties, List<String> tags) {
            this.id = id;
            this.label = label;
            this.mnemonics = mnemonics;
            this.description = description;
            this.properties = properties;
            this.tags = tags;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getMnemonics() {
            return this.mnemonics;
        }

        public String getDescription() {
            return this.description;
        }

        public List<DBPPropertyDescriptor> getProperties() {
            return this.properties;
        }

        public List<String> getTags() {
            return this.tags;
        }
    }
}

