/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qm;

import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.qm.QMDisposable;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class QMEventListener
implements QMMetaListener {
    private static final Log log = Log.getLog(QMEventListener.class);
    private final QMService qmService = new QMEmbeddedService();

    public void dispose() {
        if (QMDisposable.class.isAssignableFrom(this.qmService.getClass())) {
            ((QMDisposable)this.qmService).dispose();
        }
    }

    public synchronized void metaInfoChanged(@NotNull DBRProgressMonitor monitor, @NotNull List<QMMetaEvent> events) {
        monitor.beginTask("Persist events", events.size());
        int i = events.size();
        while (i > 0) {
            QMMetaEvent event = events.get(i - 1);
            monitor.subTask("Event " + event.getObject().getObjectId());
            try {
                this.processEvent(monitor, event);
            }
            catch (Exception e) {
                log.debug((Object)"QMDB error", (Throwable)e);
            }
            monitor.worked(1);
            --i;
        }
        monitor.done();
    }

    private synchronized void processEvent(DBRProgressMonitor monitor, QMMetaEvent event) throws SQLException, DBException {
        if (event.getAction() == QMEventAction.UPDATE) {
            return;
        }
        this.qmService.saveEvent(event, monitor);
    }
}

