/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.win32.com;

import com.dbeaver.model.win32.com.COMUtils;
import com.dbeaver.model.win32.com.ICollection;
import com.dbeaver.model.win32.com.IRegisteredTask;
import com.dbeaver.model.win32.com.ITaskDefinition;
import com.dbeaver.model.win32.com.TaskCreationFlags;
import com.dbeaver.model.win32.com.TaskLogon;
import com.sun.jna.platform.win32.COM.COMLateBindingObject;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.Variant;
import java.io.Closeable;
import java.util.EnumSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class ITaskFolder
extends COMLateBindingObject
implements Closeable {
    public ITaskFolder(@NotNull IDispatch dispatch) {
        super(dispatch);
    }

    @NotNull
    public ICollection<IRegisteredTask> getTasks() {
        IDispatch dispatch = (IDispatch)this.invoke("GetTasks", COMUtils.makeVariant(0L)).getValue();
        return new ICollection<IRegisteredTask>(dispatch){

            @Override
            @NotNull
            protected IRegisteredTask createItemObject(@NotNull IDispatch dispatch) {
                return new IRegisteredTask(dispatch);
            }
        };
    }

    @NotNull
    public IRegisteredTask registerTask(@NotNull String path, @NotNull ITaskDefinition definition, @NotNull EnumSet<TaskCreationFlags> flags, @Nullable String userId, @Nullable String password, TaskLogon logon, @Nullable String securityDescriptor) {
        Variant.VARIANT pathVariant = COMUtils.makeVariant(path);
        Variant.VARIANT userIdVariant = COMUtils.makeVariant(userId);
        Variant.VARIANT passwordVariant = COMUtils.makeVariant(password);
        Variant.VARIANT securityDescriptorVariant = COMUtils.makeVariant(securityDescriptor);
        try {
            IRegisteredTask iRegisteredTask = new IRegisteredTask((IDispatch)this.invoke("RegisterTaskDefinition", new Variant.VARIANT[]{pathVariant, definition.toVariant(), COMUtils.makeVariant(flags), userIdVariant, passwordVariant, COMUtils.makeVariant(logon), securityDescriptorVariant}).getValue());
            return iRegisteredTask;
        }
        finally {
            COMUtils.freeVariant(pathVariant);
            COMUtils.freeVariant(userIdVariant);
            COMUtils.freeVariant(passwordVariant);
            COMUtils.freeVariant(securityDescriptorVariant);
        }
    }

    public void deleteFolder(@NotNull String subFolderName) {
        Variant.VARIANT nameVariant = COMUtils.makeVariant(subFolderName);
        try {
            this.invokeNoReply("DeleteFolder", nameVariant, COMUtils.makeVariant(0L));
        }
        finally {
            COMUtils.freeVariant(nameVariant);
        }
    }

    public void deleteTask(@NotNull String name) {
        Variant.VARIANT nameVariant = COMUtils.makeVariant(name);
        try {
            this.invokeNoReply("DeleteTask", nameVariant, COMUtils.makeVariant(0L));
        }
        finally {
            COMUtils.freeVariant(nameVariant);
        }
    }

    @NotNull
    public ICollection<ITaskFolder> getFolders() {
        IDispatch dispatch = (IDispatch)this.invoke("GetFolders", COMUtils.makeVariant(0L)).getValue();
        return new ICollection<ITaskFolder>(dispatch){

            @Override
            @NotNull
            protected ITaskFolder createItemObject(@NotNull IDispatch dispatch) {
                return new ITaskFolder(dispatch);
            }
        };
    }

    @NotNull
    public ITaskFolder createFolder(@NotNull String name, @NotNull String securityDescriptor) {
        Variant.VARIANT nameVariant = COMUtils.makeVariant(name);
        Variant.VARIANT securityDescriptorVariant = COMUtils.makeVariant(securityDescriptor);
        try {
            ITaskFolder iTaskFolder = new ITaskFolder((IDispatch)this.invoke("CreateFolder", nameVariant, securityDescriptorVariant).getValue());
            return iTaskFolder;
        }
        finally {
            COMUtils.freeVariant(nameVariant);
            COMUtils.freeVariant(securityDescriptorVariant);
        }
    }

    @NotNull
    public String getName() {
        return this.getStringProperty("Name");
    }

    @Override
    public void close() {
        this.release();
    }
}

