/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.cron;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.IOUtils;

final class CrontabEditor {
    private static final Log log = Log.getLog(CrontabEditor.class);
    private static final String START_OF_DBEAVER_TASKS_BLOCK = "##### DBEAVER CRON JOBS DO NOT MODIFY BY HAND";
    private static final String END_OF_DBEAVER_TASKS_BLOCK = "##### END OF DBEAVER CRON JOBS";
    private final String beginning;
    private final Map<String, String> tasks;
    private final String ending;

    private CrontabEditor(String beginning, Map<String, String> tasks, String ending) {
        this.beginning = beginning;
        this.tasks = tasks;
        this.ending = ending;
    }

    static CrontabEditor loadCrontab(Function<String, String> runTaskParameterParser) throws IOException {
        StringBuilder ending;
        HashMap<String, String> tasks;
        StringBuilder beginning;
        block20: {
            Process process;
            block18: {
                String line;
                process = new ProcessBuilder("crontab", "-l").start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                boolean foundStartOfBlock = false;
                beginning = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    beginning.append(line);
                    if (!line.equals(START_OF_DBEAVER_TASKS_BLOCK)) continue;
                    foundStartOfBlock = true;
                    break;
                }
                if (!foundStartOfBlock) {
                    beginning.append(START_OF_DBEAVER_TASKS_BLOCK);
                    return new CrontabEditor(beginning.toString(), new HashMap<String, String>(), END_OF_DBEAVER_TASKS_BLOCK);
                }
                tasks = new HashMap<String, String>();
                while ((line = reader.readLine()) != null && !line.equals(END_OF_DBEAVER_TASKS_BLOCK)) {
                    String runTaskParameter = runTaskParameterParser.apply(line);
                    tasks.put(runTaskParameter, line);
                }
                ending = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    ending.append(line);
                }
                if (ending.length() == 0) {
                    ending.append(END_OF_DBEAVER_TASKS_BLOCK);
                }
                try {
                    try {
                        int resultCode = process.waitFor();
                        if (resultCode == 0) break block18;
                        String resultCodeString = "crontab process ended with result code " + resultCode;
                        StringWriter buf = new StringWriter();
                        Throwable throwable = null;
                        Object var12_14 = null;
                        try (InputStreamReader errorReader = new InputStreamReader(process.getErrorStream());){
                            IOUtils.copyText((Reader)errorReader, (Writer)buf);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        throw new IOException(String.valueOf(resultCodeString) + "\n\n" + buf.toString());
                    }
                    catch (InterruptedException e) {
                        log.info((Object)e);
                        process.destroy();
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    process.destroy();
                    throw throwable;
                }
            }
            process.destroy();
        }
        return new CrontabEditor(beginning.toString(), tasks, ending.toString());
    }

    void upsert(String runTaskParameter, String entry) {
        this.tasks.put(runTaskParameter, entry);
    }

    void remove(String runTaskParameter) {
        this.tasks.remove(runTaskParameter);
    }

    static String getRawContents() throws IOException {
        Process process = new ProcessBuilder("crontab", "-l").start();
        try {
            int resultCode = process.waitFor();
            if (resultCode == 0) {
                String string = CrontabEditor.accumulateStreamIntoString(process.getInputStream());
                return string;
            }
            if (resultCode == 1) {
                String string = CrontabEditor.accumulateStreamIntoString(process.getErrorStream());
                return string;
            }
            try {
                String resultCodeString = "Crontab process ended with result code " + resultCode;
                throw new IOException(String.valueOf(resultCodeString) + "\n\n" + CrontabEditor.accumulateStreamIntoString(process.getErrorStream()));
            }
            catch (InterruptedException e) {
                log.info((Object)e);
                throw new IOException(e);
            }
        }
        finally {
            process.destroy();
        }
    }

    private static String accumulateStreamIntoString(InputStream stream) throws IOException {
        String line;
        StringBuilder contents = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            contents.append(line).append('\n');
        }
        return contents.toString();
    }

    @Nullable
    String get(String runTaskParameter) {
        return this.tasks.get(runTaskParameter);
    }

    Map<String, String> getTasks() {
        return Collections.unmodifiableMap(this.tasks);
    }

    void flush() throws IOException {
        block25: {
            ArrayList<String> contents = new ArrayList<String>(this.tasks.size() + 2);
            contents.add(this.beginning);
            contents.addAll(this.tasks.values());
            contents.add(this.ending);
            Process crontab = new ProcessBuilder("crontab", "-").start();
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(crontab.getOutputStream()));){
                for (String line : contents) {
                    writer.append(line);
                    writer.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                try {
                    int resultCode = crontab.waitFor();
                    if (resultCode == 0) break block25;
                    String resultCodeString = "crontab process ended with result code " + resultCode;
                    StringWriter buf = new StringWriter();
                    Throwable throwable3 = null;
                    Iterator iterator = null;
                    try (InputStreamReader errorReader = new InputStreamReader(crontab.getErrorStream());){
                        IOUtils.copyText((Reader)errorReader, (Writer)buf);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    throw new IOException(String.valueOf(resultCodeString) + "\n\n" + buf.toString());
                }
                catch (InterruptedException e) {
                    log.info((Object)e);
                    crontab.destroy();
                }
            }
            finally {
                crontab.destroy();
            }
        }
    }
}

