/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.config;

import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.registry.CPCloudConfigurationProviderCustom;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;

public class GcpLocalConfigurationProvider
implements CPCloudConfigurationProviderCustom<GCPCloudConfiguration> {
    private static final Log log = Log.getLog(GcpLocalConfigurationProvider.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private List<GCPCloudConfiguration> gcpConfigs;
    private static final String CLOUD_CONFIG_FOLDER = ".cloud-data";
    private static final String CLOUD_CONFIG_FILE = "gcp-clouds.json";

    @NotNull
    public static Gson createGson(boolean saveSecureProperties) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().setLenient();
        if (!saveSecureProperties) {
            builder.addSerializationExclusionStrategy((ExclusionStrategy)new SecurePropertiesExclusionStrategy());
        }
        return builder.create();
    }

    @NotNull
    public GCPCloudConfiguration[] getCloudConfigurations() {
        if (this.gcpConfigs == null) {
            ArrayList<GCPCloudConfiguration> cfgList = new ArrayList<GCPCloudConfiguration>();
            Path cloudConfigFile = this.getCloudConfigFile(false);
            if (Files.exists(cloudConfigFile, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader cr = Files.newBufferedReader(cloudConfigFile, StandardCharsets.UTF_8);){
                        GCPCloudConfiguration[] gcpConfigs = (GCPCloudConfiguration[])this.gson.fromJson((Reader)cr, GCPCloudConfiguration[].class);
                        Collections.addAll(cfgList, gcpConfigs);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.gcpConfigs = cfgList;
        }
        return this.gcpConfigs.toArray(new GCPCloudConfiguration[0]);
    }

    private boolean useSecureStorage() {
        return DBWorkbench.getPlatform().getApplication().getSecureStorage().useSecurePreferences();
    }

    private ISecurePreferences getCloudPrefNode(GCPCloudConfiguration cfg) {
        DBASecureStorage secureStorage = DBWorkbench.getPlatform().getApplication().getSecureStorage();
        ISecurePreferences securePreferences = secureStorage.getSecurePreferences();
        return securePreferences.node("gcp").node("credentials").node(cfg.getCloudId());
    }

    @NotNull
    public GCPCloudConfiguration createConfiguration() {
        return new GCPCloudConfiguration();
    }

    public void saveConfigurations(@NotNull Collection<GCPCloudConfiguration> configurations) {
        this.gcpConfigs = new ArrayList<GCPCloudConfiguration>(configurations);
        this.saveConfigurationsInFile();
        CPCloudConfigurationRegistry.getInstance().fireCloudConfigurationChange();
    }

    public void saveConfigurationsInFile() {
        this.flushConfiguration(true);
    }

    public Map<String, Object> serializeCloudConfiguration(GCPCloudConfiguration configuration) {
        Gson gson = GcpLocalConfigurationProvider.createGson(false);
        String jsonString = gson.toJson((Object)configuration, configuration.getClass());
        return JSONUtils.parseMap((Gson)gson, (Reader)new StringReader(jsonString));
    }

    public GCPCloudConfiguration loadCloudConfiguration(DBPExternalConfiguration externalConfiguration) {
        Gson gson = GcpLocalConfigurationProvider.createGson(false);
        String jsonString = gson.toJson((Object)externalConfiguration.getProperties());
        GCPCloudConfiguration cloudConfiguration = (GCPCloudConfiguration)gson.fromJson(jsonString, GCPCloudConfiguration.class);
        this.gcpConfigs.add(cloudConfiguration);
        this.saveConfigurationsInFile();
        return cloudConfiguration;
    }

    private void flushConfiguration(boolean saveSecureProperties) {
        Gson saveGson = GcpLocalConfigurationProvider.createGson(saveSecureProperties);
        Path cloudConfigFile = this.getCloudConfigFile(true);
        ContentUtils.makeFileBackup((Path)cloudConfigFile);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter cr = Files.newBufferedWriter(cloudConfigFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                JsonWriter jsonWriter = saveGson.newJsonWriter((Writer)cr);
                saveGson.toJson(this.gcpConfigs, this.gcpConfigs.getClass(), jsonWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private Path getCloudConfigFile(boolean create) {
        return this.getCloudConfigFolder(create).resolve(CLOUD_CONFIG_FILE);
    }

    @NotNull
    private Path getCloudConfigFolder(boolean create) {
        Path cloudsFolder = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(CLOUD_CONFIG_FOLDER);
        if (create && !Files.exists(cloudsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(cloudsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Cannot create directory '" + cloudsFolder.toAbsolutePath() + "'"), (Throwable)e);
            }
        }
        return cloudsFolder;
    }

    private static class EmptyExclusionStrategy
    implements ExclusionStrategy {
        private EmptyExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    private static class SecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private SecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

