/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.config;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.registry.CPCloudConfigurationProviderCustom;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class AwsLocalConfigurationProvider
implements CPCloudConfigurationProviderCustom<AWSCloudConfiguration> {
    private static final Log log = Log.getLog(AwsLocalConfigurationProvider.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private List<AWSCloudConfiguration> awsConfigs;
    private static final String CLOUD_CONFIG_FOLDER = ".cloud-data";
    private static final String CLOUD_CONFIG_FILE = "aws-clouds.json";

    @NotNull
    public static Gson createGson(boolean saveSecureProperties) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().setLenient();
        if (!saveSecureProperties) {
            builder.addSerializationExclusionStrategy((ExclusionStrategy)new SecurePropertiesExclusionStrategy());
        }
        return builder.create();
    }

    @NotNull
    public AWSCloudConfiguration[] getCloudConfigurations() {
        if (this.awsConfigs == null) {
            ArrayList<AWSCloudConfiguration> cfgList = new ArrayList<AWSCloudConfiguration>();
            Path cloudConfigFile = this.getCloudConfigFile(false);
            if (Files.exists(cloudConfigFile, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader cr = Files.newBufferedReader(cloudConfigFile, StandardCharsets.UTF_8);){
                        AWSCloudConfiguration[] awsConfigs = (AWSCloudConfiguration[])this.gson.fromJson((Reader)cr, AWSCloudConfiguration[].class);
                        if (this.useSecureStorage()) {
                            AWSCloudConfiguration[] aWSCloudConfigurationArray = awsConfigs;
                            int n = awsConfigs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                AWSCloudConfiguration cfg = aWSCloudConfigurationArray[n2];
                                this.readAuthParametersFromPreferences(cfg);
                                ++n2;
                            }
                        }
                        Collections.addAll(cfgList, awsConfigs);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.awsConfigs = cfgList;
        }
        return this.awsConfigs.toArray(new AWSCloudConfiguration[0]);
    }

    private boolean useSecureStorage() {
        return DBWorkbench.getPlatform().getApplication().getSecureStorage().useSecurePreferences();
    }

    private ISecurePreferences getCloudPrefNode(AWSCloudConfiguration cfg) {
        DBASecureStorage secureStorage = DBWorkbench.getPlatform().getApplication().getSecureStorage();
        ISecurePreferences securePreferences = secureStorage.getSecurePreferences();
        return securePreferences.node("aws").node("credentials").node(cfg.getCloudId());
    }

    private void readAuthParametersFromPreferences(AWSCloudConfiguration cfg) {
        try {
            ISecurePreferences cloudPrefNode = this.getCloudPrefNode(cfg);
            String accessKey = cloudPrefNode.get("access-key", null);
            String secretKey = cloudPrefNode.get("secret-key", null);
            String sessionToken = cloudPrefNode.get("session-token", null);
            if (!CommonUtils.isEmpty((String)accessKey)) {
                cfg.getCredentials().setAwsAccessKey(accessKey);
            }
            if (!CommonUtils.isEmpty((String)secretKey)) {
                cfg.getCredentials().setAwsSecretKey(secretKey);
            }
            if (!CommonUtils.isEmpty((String)sessionToken)) {
                cfg.getCredentials().setAwsSessionToken(sessionToken);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private boolean saveAuthParametersToPreferences(AWSCloudConfiguration cfg) {
        try {
            String sessionToken;
            String secretKey;
            ISecurePreferences cloudPrefNode = this.getCloudPrefNode(cfg);
            String accessKey = cfg.getCredentials().getAwsAccessKey();
            if (!CommonUtils.isEmpty((String)accessKey)) {
                cloudPrefNode.put("access-key", accessKey, true);
            }
            if (!CommonUtils.isEmpty((String)(secretKey = cfg.getCredentials().getAwsSecretKey()))) {
                cloudPrefNode.put("secret-key", secretKey, true);
            }
            if (!CommonUtils.isEmpty((String)(sessionToken = cfg.getCredentials().getAwsSessionToken()))) {
                cloudPrefNode.put("session-token", sessionToken, true);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
    }

    private void removeAuthParametersToPreferences(AWSCloudConfiguration cfg) {
    }

    @NotNull
    public AWSCloudConfiguration createConfiguration() {
        return new AWSCloudConfiguration();
    }

    public void saveConfigurations(@NotNull Collection<AWSCloudConfiguration> configurations) {
        this.awsConfigs = new ArrayList<AWSCloudConfiguration>(configurations);
        this.saveConfigurationsInFile();
        CPCloudConfigurationRegistry.getInstance().fireCloudConfigurationChange();
    }

    public void saveConfigurationsInFile() {
        boolean securePropsSaved = false;
        if (this.useSecureStorage()) {
            securePropsSaved = true;
            for (AWSCloudConfiguration cfg : this.awsConfigs) {
                if (this.saveAuthParametersToPreferences(cfg)) continue;
                securePropsSaved = false;
            }
        }
        this.flushConfiguration(!securePropsSaved);
    }

    public Map<String, Object> serializeCloudConfiguration(AWSCloudConfiguration configuration) {
        Gson gson = AwsLocalConfigurationProvider.createGson(false);
        String jsonString = gson.toJson((Object)configuration, configuration.getClass());
        return JSONUtils.parseMap((Gson)gson, (Reader)new StringReader(jsonString));
    }

    public AWSCloudConfiguration loadCloudConfiguration(DBPExternalConfiguration externalConfiguration) {
        Gson gson = AwsLocalConfigurationProvider.createGson(false);
        String jsonString = gson.toJson((Object)externalConfiguration.getProperties());
        AWSCloudConfiguration cloudConfiguration = (AWSCloudConfiguration)gson.fromJson(jsonString, AWSCloudConfiguration.class);
        this.awsConfigs.add(cloudConfiguration);
        this.saveConfigurationsInFile();
        return cloudConfiguration;
    }

    private void flushConfiguration(boolean saveSecureProperties) {
        Gson saveGson = AwsLocalConfigurationProvider.createGson(saveSecureProperties);
        Path cloudConfigFile = this.getCloudConfigFile(true);
        ContentUtils.makeFileBackup((Path)cloudConfigFile);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter cr = Files.newBufferedWriter(cloudConfigFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                JsonWriter jsonWriter = saveGson.newJsonWriter((Writer)cr);
                saveGson.toJson(this.awsConfigs, this.awsConfigs.getClass(), jsonWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private Path getCloudConfigFile(boolean create) {
        return this.getCloudConfigFolder(create).resolve(CLOUD_CONFIG_FILE);
    }

    @NotNull
    private Path getCloudConfigFolder(boolean create) {
        Path cloudsFolder = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(CLOUD_CONFIG_FOLDER);
        if (create && !Files.exists(cloudsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(cloudsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Cannot create directory '" + cloudsFolder.toAbsolutePath() + "'"), (Throwable)e);
            }
        }
        return cloudsFolder;
    }

    private static class EmptyExclusionStrategy
    implements ExclusionStrategy {
        private EmptyExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }

    private static class SecurePropertiesExclusionStrategy
    implements ExclusionStrategy {
        private SecurePropertiesExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(SecureProperty.class) != null;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

