/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLException;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;

class XSLExtFunctions
implements XSLExprConstants {
    XSLExtFunctions() {
    }

    static void callMethod(Method method, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Object object;
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object object2 = null;
        Object object3 = XPathSequence.convertType((OXMLSequence)fastVector.elementAt(0), clazz);
        for (int i = 0; i < classArray.length; ++i) {
            object = (OXMLSequence)fastVector.elementAt(i + 1);
            objectArray[i] = XPathSequence.convertType((OXMLSequence)object, classArray[i]);
        }
        try {
            object2 = method.invoke(object3, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1044, method.getName(), invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            object = new XPathException(1900, exception.getMessage());
            ((XMLException)object).setException(exception);
            throw object;
        }
        if (object2 != null) {
            XPathSequence.setExtensionValue(oXMLSequence, object2);
        } else {
            XPathSequence.setStringValue(oXMLSequence, "");
        }
    }

    static void callStaticMethod(Method method, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object object = null;
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = XPathSequence.convertType((OXMLSequence)fastVector.elementAt(i), classArray[i]);
        }
        try {
            object = method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1044, method.getName(), invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        if (object != null) {
            XPathSequence.setExtensionValue(oXMLSequence, object);
        }
    }

    static void callConstructor(Constructor constructor, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object var5_5 = null;
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = XPathSequence.convertType((OXMLSequence)fastVector.elementAt(i), classArray[i]);
        }
        try {
            var5_5 = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1039, constructor.getName());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        XPathSequence.setExtensionValue(oXMLSequence, var5_5);
    }

    static Constructor getConstructor(String string, FastVector fastVector) throws XPathException {
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor[] constructorArray2 = new Constructor[constructorArray.length];
            int n = 0;
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                int n2 = constructorArray[i].getModifiers();
                if (!Modifier.isPublic(n2) || fastVector.size() != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j < classArray.length; ++j) {
                    if (XPathSequence.checkType((OXMLSequence)fastVector.elementAt(j), classArray[j])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (n == 0) {
                    constructorArray2[n++] = constructorArray[i];
                    continue;
                }
                throw new XPathException(1040, constructorArray[i].getName());
            }
            if (n == 0) {
                throw new XPathException(1041, string);
            }
            return constructorArray2[0];
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static Method getMethod(String string, String string2, FastVector fastVector) throws XPathException {
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Method[] methodArray = clazz.getMethods();
            Method[] methodArray2 = new Method[methodArray.length];
            int n = 0;
            String string3 = XSLExtFunctions.getJavaMethodName(string2);
            for (int i = 0; i < methodArray.length; ++i) {
                int n2 = methodArray[i].getModifiers();
                if (!Modifier.isPublic(n2) || !methodArray[i].getName().equals(string3)) continue;
                boolean bl = Modifier.isStatic(n2);
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                int n3 = classArray.length;
                if ((!bl || fastVector.size() != n3) && (bl || fastVector.size() != n3 + 1)) continue;
                int n4 = bl ? 0 : 1;
                boolean bl2 = true;
                for (int j = 0; j < classArray.length; ++j) {
                    if (XPathSequence.checkType((OXMLSequence)fastVector.elementAt(j + n4), classArray[j])) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                if (n == 0) {
                    methodArray2[n++] = methodArray[i];
                    continue;
                }
                throw new XPathException(1042, methodArray[i].getName());
            }
            if (n == 0) {
                throw new XPathException(1043, string2);
            }
            return methodArray2[0];
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static boolean checkMethod(String string, String string2) throws XPathException {
        if (string2.equals("new")) {
            return true;
        }
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Method[] methodArray = clazz.getMethods();
            String string3 = XSLExtFunctions.getJavaMethodName(string2);
            for (int i = 0; i < methodArray.length; ++i) {
                if (!Modifier.isPublic(methodArray[i].getModifiers()) || !methodArray[i].getName().equals(string3)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static String getJavaMethodName(String string) {
        if (string.indexOf(45) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '-' && i < n - 1) {
                if (cArray[++i] >= 'a' && cArray[i] <= 'z') {
                    cArray[n2++] = (char)(cArray[i] - 97 + 65);
                    continue;
                }
                cArray[n2++] = cArray[i];
                continue;
            }
            cArray[n2++] = cArray[i];
        }
        return new String(cArray, 0, n2);
    }

    static Class getClass(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Class.forName(string);
        }
        catch (NullPointerException nullPointerException) {
            return Class.forName(string);
        }
    }
}

