/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.system.cron;

import com.dbeaver.ee.sched.system.BaseSystemScheduler;
import com.dbeaver.ee.sched.system.GenericTaskScheduleInfo;
import com.dbeaver.ee.sched.system.cron.ConfigurationConverter;
import com.dbeaver.ee.sched.system.cron.CrontabEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.utils.CommonUtils;

public class CronSystemScheduler
extends BaseSystemScheduler {
    private static final Function<String, String> RUN_TASK_ARG_PARSER = s -> {
        int beginning = s.indexOf("-runTask") + 8;
        int ending = s.indexOf("-nosplash");
        return CommonUtils.unescapeBourneShellString((String)s.substring(beginning, ending).trim());
    };

    @NotNull
    public String getSchedulerName() {
        return "Local CRON scheduler";
    }

    public boolean supportsFeature(String feature) {
        switch (feature) {
            case "frequency.hourly.executionMinute": 
            case "frequency.daily": 
            case "frequency.minutely": 
            case "frequency.hourly": 
            case "frequency.monthly": 
            case "frequency.weekly": {
                return true;
            }
        }
        return false;
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return DBTScheduler.RecurrenceType.Cron;
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() {
        CrontabEditor editor;
        try {
            editor = CrontabEditor.loadCrontab(RUN_TASK_ARG_PARSER);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
        ArrayList<GenericTaskScheduleInfo> info = new ArrayList<GenericTaskScheduleInfo>();
        for (Map.Entry<String, String> task : editor.getTasks().entrySet()) {
            info.add(new GenericTaskScheduleInfo(task.getKey(), ConfigurationConverter.nextRunInfo(this.extractCronExpression(task.getValue())), null));
        }
        return Collections.unmodifiableList(info);
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        CrontabEditor editor;
        try {
            editor = CrontabEditor.loadCrontab(RUN_TASK_ARG_PARSER);
        }
        catch (IOException iOException) {
            return null;
        }
        String cronEntry = editor.get(CronSystemScheduler.getRunTaskParameter(task));
        if (cronEntry == null) {
            return null;
        }
        return new GenericTaskScheduleInfo(task.getId(), ConfigurationConverter.nextRunInfo(this.extractCronExpression(cronEntry)), null);
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        CrontabEditor editor;
        try {
            editor = CrontabEditor.loadCrontab(RUN_TASK_ARG_PARSER);
        }
        catch (IOException e) {
            throw new DBException("Unable to load crontab", (Throwable)e);
        }
        String entry = editor.get(CronSystemScheduler.getRunTaskParameter(task));
        if (entry == null) {
            return null;
        }
        String cronExpression = this.extractCronExpression(entry);
        if (cronExpression == null) {
            return null;
        }
        return ConfigurationConverter.toDBTTaskScheduleConfiguration(cronExpression);
    }

    public void setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        String runTaskParameter = CronSystemScheduler.getRunTaskParameter(task);
        String crontabEntry = this.generateCrontabEntry(runTaskParameter, scheduleConfiguration);
        try {
            CrontabEditor editor = CrontabEditor.loadCrontab(RUN_TASK_ARG_PARSER);
            editor.upsert(CronSystemScheduler.getRunTaskParameter(task), crontabEntry);
            editor.flush();
        }
        catch (IOException e) {
            throw new DBException("Unable to read or write to crontab", (Throwable)e);
        }
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        try {
            CrontabEditor editor = CrontabEditor.loadCrontab(RUN_TASK_ARG_PARSER);
            editor.remove(CronSystemScheduler.getRunTaskParameter(task));
            editor.flush();
        }
        catch (IOException e) {
            throw new DBException("Unable to read or write to crontab", (Throwable)e);
        }
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) {
    }

    public DBTSchedulerExternalSettings openSchedulerSettings() throws DBException {
        try {
            DBTSchedulerExternalSettings settings = new DBTSchedulerExternalSettings();
            settings.setPlaintextDetails(CrontabEditor.getRawContents());
            return settings;
        }
        catch (IOException e) {
            throw new DBException("Error reading crontab", (Throwable)e);
        }
    }

    private String generateCrontabEntry(String runTaskParameter, DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        String cronExpr = ConfigurationConverter.toCronExpression(scheduleConfiguration);
        return String.valueOf(cronExpr) + " PATH=" + CommonUtils.escapeBourneShellString((String)System.getenv("PATH")) + " " + CommonUtils.escapeBourneShellString((String)System.getProperty("eclipse.launcher")) + " -runTask " + CommonUtils.escapeBourneShellString((String)runTaskParameter) + " -nosplash";
    }

    private String extractCronExpression(String cronEntry) {
        int countOfSpaces = 0;
        int i = 0;
        while (i < cronEntry.length()) {
            if (cronEntry.charAt(i) == ' ') {
                ++countOfSpaces;
            }
            if (countOfSpaces == 5) {
                return cronEntry.substring(0, i);
            }
            ++i;
        }
        return null;
    }
}

