/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class BulkMutation
implements Serializable {
    private static final long serialVersionUID = 3522061250439399088L;
    private final String tableId;
    private transient MutateRowsRequest.Builder builder;

    public static BulkMutation create(String tableId) {
        return new BulkMutation(tableId);
    }

    private BulkMutation(@Nonnull String tableId) {
        Preconditions.checkNotNull((Object)tableId);
        this.tableId = tableId;
        this.builder = MutateRowsRequest.newBuilder();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (MutateRowsRequest.Builder)MutateRowsRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public BulkMutation add(@Nonnull String rowKey, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)rowKey);
        Preconditions.checkNotNull((Object)mutation);
        return this.add(ByteString.copyFromUtf8((String)rowKey), mutation);
    }

    public BulkMutation add(@Nonnull ByteString rowKey, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)rowKey);
        Preconditions.checkNotNull((Object)mutation);
        this.builder.addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(rowKey).addAllMutations(mutation.getMutations()).build());
        return this;
    }

    @InternalApi
    public MutateRowsRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }
}

