/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.properties.PropertyEditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PropertyDescriptorDelegate
implements IPropertyDescriptor {
    private static final ILabelProvider DEFAULT_LABEL_PROVIDER = new ColumnLabelProvider(){

        public String getText(Object element) {
            if (element instanceof DBPNamedObject) {
                return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)element), (DBPEvaluationContext)DBPEvaluationContext.UI);
            }
            return CommonUtils.toString((Object)GeneralUtils.makeDisplayString((Object)element));
        }

        public Image getImage(Object element) {
            DBPImage image;
            if (element instanceof DBPObject && (image = DBValueFormatting.getObjectImage((DBPObject)((DBPObject)element), (boolean)false)) != null) {
                return DBeaverIcons.getImage(image);
            }
            return super.getImage(element);
        }
    };
    private final DBPPropertySource propSource;
    private final DBPPropertyDescriptor delegate;

    public PropertyDescriptorDelegate(DBPPropertySource propSource, DBPPropertyDescriptor delegate) {
        this.propSource = propSource;
        this.delegate = delegate;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.delegate.isEditable(this.propSource.getEditableValue())) {
            return null;
        }
        return PropertyEditorUtils.createCellEditor(parent, this.propSource.getEditableValue(), this.delegate, 0);
    }

    public String getCategory() {
        return this.delegate.getCategory();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String[] getFilterFlags() {
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return this.delegate.getId();
    }

    public ILabelProvider getLabelProvider() {
        return DEFAULT_LABEL_PROVIDER;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }
}

