/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DataCompareMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskWizardPageSettings
extends ActiveWizardPage<DCCompareTaskWizard> {
    private Text comparedRowsLimitText;
    private Text differentRowsLimitText;
    private Text fetchSizeText;
    private Button showModifiedRowsCheckbox;
    private Button showDeletedRowsCheckbox;
    private Button showInsertedRowsCheckbox;

    protected DCCompareTaskWizardPageSettings() {
        super(DataCompareMessages.data_compare_wizard_settings_name);
        this.setTitle(DataCompareMessages.data_compare_wizard_settings_title);
        this.setDescription(DataCompareMessages.data_compare_wizard_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        final DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group group = UIUtils.createControlGroup((Composite)composite, (String)DataCompareMessages.data_compare_wizard_settings_group_general_title, (int)2, (int)2, (int)0);
        ((GridData)group.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)group) * 40;
        UIUtils.createControlLabel((Composite)group, (String)DataCompareMessages.data_compare_wizard_settings_group_general_compared_rows_limit_label);
        this.comparedRowsLimitText = new Text((Composite)group, 2048);
        this.comparedRowsLimitText.setLayoutData((Object)new GridData(768));
        this.comparedRowsLimitText.setToolTipText(DataCompareMessages.data_compare_wizard_settings_group_general_compared_rows_limit_tip);
        this.comparedRowsLimitText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.comparedRowsLimitText.addModifyListener(e -> {
            String text = this.comparedRowsLimitText.getText();
            if (!CommonUtils.isEmpty((String)text)) {
                settings.setComparedRowsLimit(CommonUtils.toLong((Object)text));
            }
            this.updatePageCompletion();
        });
        UIUtils.createControlLabel((Composite)group, (String)DataCompareMessages.data_compare_wizard_settings_group_general_different_rows_limit_label);
        this.differentRowsLimitText = new Text((Composite)group, 2048);
        this.differentRowsLimitText.setLayoutData((Object)new GridData(768));
        this.differentRowsLimitText.setToolTipText(DataCompareMessages.data_compare_wizard_settings_group_general_different_rows_limit_tip);
        this.differentRowsLimitText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.differentRowsLimitText.addModifyListener(e -> {
            String text = this.differentRowsLimitText.getText();
            if (!CommonUtils.isEmpty((String)text)) {
                settings.setDifferentRowsLimit(CommonUtils.toLong((Object)text));
            }
            this.updatePageCompletion();
        });
        UIUtils.createControlLabel((Composite)group, (String)DataCompareMessages.data_compare_wizard_settings_group_general_fetch_size_label);
        this.fetchSizeText = new Text((Composite)group, 2048);
        this.fetchSizeText.setLayoutData((Object)new GridData(768));
        this.fetchSizeText.setToolTipText(DataCompareMessages.data_compare_wizard_settings_group_general_fetch_size_tip);
        this.fetchSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.fetchSizeText.addModifyListener(e -> {
            String text = this.fetchSizeText.getText();
            if (!CommonUtils.isEmpty((String)text)) {
                settings.setFetchSize(CommonUtils.toInt((Object)text));
            }
            this.updatePageCompletion();
        });
        group = UIUtils.createControlGroup((Composite)composite, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_title, (int)2, (int)2, (int)0);
        ((GridData)group.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)group) * 40;
        this.showModifiedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_show_modified_rows_label, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_show_modified_rows_tip, (boolean)false, (int)2);
        this.showModifiedRowsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIncludeModifiedRows(DCCompareTaskWizardPageSettings.this.showModifiedRowsCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.showDeletedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_show_deleted_rows_label, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_show_deleted_rows_tip, (boolean)false, (int)2);
        this.showDeletedRowsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIncludeDeletedRows(DCCompareTaskWizardPageSettings.this.showDeletedRowsCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        this.showInsertedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_show_inserted_rows_label, (String)DataCompareMessages.data_compare_wizard_settings_group_visibility_show_inserted_rows_tip, (boolean)false, (int)2);
        this.showInsertedRowsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setIncludeInsertedRows(DCCompareTaskWizardPageSettings.this.showInsertedRowsCheckbox.getSelection());
                DCCompareTaskWizardPageSettings.this.updatePageCompletion();
            }
        });
        ((DCCompareTaskWizard)this.getWizard()).createTaskSaveButtons(composite, true, 1);
        this.setControl((Control)composite);
    }

    public void activatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        this.comparedRowsLimitText.setText(String.valueOf(settings.getComparedRowsLimit()));
        this.differentRowsLimitText.setText(String.valueOf(settings.getDifferentRowsLimit()));
        this.fetchSizeText.setText(String.valueOf(settings.getFetchSize()));
        this.showModifiedRowsCheckbox.setSelection(settings.isIncludeModifiedRows());
        this.showDeletedRowsCheckbox.setSelection(settings.isIncludeDeletedRows());
        this.showInsertedRowsCheckbox.setSelection(settings.isIncludeInsertedRows());
        this.updatePageCompletion();
    }

    public void performHelp() {
        UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-compare"));
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        ((DCCompareTaskWizard)this.getWizard()).updateSaveTaskButtons();
    }

    protected boolean determinePageCompletion() {
        return !CommonUtils.isEmpty((String)this.comparedRowsLimitText.getText()) && !CommonUtils.isEmpty((String)this.differentRowsLimitText.getText()) && !CommonUtils.isEmpty((String)this.fetchSizeText.getText()) && (this.showModifiedRowsCheckbox.getSelection() || this.showDeletedRowsCheckbox.getSelection() || this.showInsertedRowsCheckbox.getSelection());
    }
}

