/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DataCompareMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskWizardPageConstraints
extends ActiveWizardPage<DCCompareTaskWizard> {
    private ConstraintSelectorPanel leftConstraintPanel;
    private ConstraintSelectorPanel rightConstraintPanel;

    protected DCCompareTaskWizardPageConstraints() {
        super(DataCompareMessages.data_compare_wizard_constraints_name);
        this.setTitle(DataCompareMessages.data_compare_wizard_constraints_title);
        this.setDescription(DataCompareMessages.data_compare_wizard_constraints_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        Composite group = UIUtils.createComposite((Composite)composite, (int)2);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.leftConstraintPanel = new ConstraintSelectorPanel(group, DataCompareMessages.data_compare_wizard_constraints_first_container_title);
        this.rightConstraintPanel = new ConstraintSelectorPanel(group, DataCompareMessages.data_compare_wizard_constraints_second_container_title);
        CLabel label = UIUtils.createInfoLabel((Composite)composite, (String)DataCompareMessages.data_compare_wizard_constraints_hint);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.setControl((Control)composite);
    }

    public void activatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        this.leftConstraintPanel.setEntity((DBSEntity)settings.getLeftContainer());
        this.rightConstraintPanel.setEntity((DBSEntity)settings.getRightContainer());
    }

    public void performHelp() {
        UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-compare"));
    }

    protected boolean determinePageCompletion() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        Object[] leftAttributes = settings.getLeftAttributes();
        Object[] rightAttributes = settings.getRightAttributes();
        if (ArrayUtils.isEmpty((Object[])leftAttributes) || ArrayUtils.isEmpty((Object[])rightAttributes)) {
            this.setErrorMessage(DataCompareMessages.data_compare_wizard_constraints_error_no_columns_selected);
            return false;
        }
        if (leftAttributes.length != rightAttributes.length) {
            this.setErrorMessage(DataCompareMessages.data_compare_wizard_constraints_error_unequal_columns_count);
            return false;
        }
        return true;
    }

    private void saveAttributes(ConstraintSelectorPanel panel, List<? extends DBSAttributeBase> attributes) {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        DBSAttributeBase[] attributesList = attributes.toArray(new DBSAttributeBase[0]);
        if (panel == this.leftConstraintPanel) {
            settings.setLeftAttributes(attributesList);
        } else {
            settings.setRightAttributes(attributesList);
        }
    }

    private class ConstraintSelectorPanel
    extends AttributesSelectorPage {
        private final Map<DBSEntityReferrer, List<DBSEntityAttribute>> constraints = new LinkedHashMap<DBSEntityReferrer, List<DBSEntityAttribute>>();
        private Combo constraintsCombo;

        public ConstraintSelectorPanel(@NotNull Composite parent, String title) {
            this.createControl((Composite)UIUtils.createControlGroup((Composite)parent, (String)title, (int)1, (int)1808, (int)0));
        }

        protected Composite createPageContents(Composite parent) {
            Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
            composite.setLayoutData((Object)new GridData(1808));
            this.createConstraintCombo(composite);
            this.createColumnsGroup(composite);
            return composite;
        }

        private void createConstraintCombo(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(768));
            UIUtils.createControlLabel((Composite)composite, (String)DataCompareMessages.data_compare_wizard_constraints_group_key_label);
            this.constraintsCombo = new Combo(composite, 12);
            this.constraintsCombo.setLayoutData((Object)new GridData(1808));
            this.constraintsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String name = ConstraintSelectorPanel.this.constraintsCombo.getItem(ConstraintSelectorPanel.this.constraintsCombo.getSelectionIndex());
                    for (Map.Entry entry : ConstraintSelectorPanel.this.constraints.entrySet()) {
                        if (!((DBSEntityReferrer)entry.getKey()).getName().equals(name)) continue;
                        DCCompareTaskWizardPageConstraints.this.saveAttributes(ConstraintSelectorPanel.this, (List)entry.getValue());
                        ConstraintSelectorPanel.this.updateColumnSelection(((List)entry.getValue())::contains);
                        DCCompareTaskWizardPageConstraints.this.updatePageCompletion();
                        break;
                    }
                }
            });
        }

        protected void handleColumnsChange() {
            List selectedAttributes = this.getSelectedAttributes();
            DCCompareTaskWizardPageConstraints.this.saveAttributes(this, selectedAttributes);
            this.updateSelectedConstraint(selectedAttributes);
            DCCompareTaskWizardPageConstraints.this.updatePageCompletion();
        }

        protected void onAttributesLoad() {
            DBSAttributeBase[] attributes;
            DBSEntity entity;
            DCCompareTaskSettings settings = ((DCCompareTaskWizard)DCCompareTaskWizardPageConstraints.this.getWizard()).getSettings();
            if (DCCompareTaskWizardPageConstraints.this.leftConstraintPanel == this) {
                entity = (DBSEntity)settings.getLeftContainer();
                attributes = settings.getLeftAttributes();
            } else {
                entity = (DBSEntity)settings.getRightContainer();
                attributes = settings.getRightAttributes();
            }
            this.constraintsCombo.removeAll();
            this.constraints.clear();
            AbstractJob job = new AbstractJob("Load entity constraints"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    monitor.beginTask("Load constraints", 1);
                    try {
                        for (DBSEntityConstraint constraint : CommonUtils.safeCollection((Collection)entity.getConstraints(monitor))) {
                            if (!(constraint instanceof DBSEntityReferrer)) continue;
                            DBSEntityReferrer referrer = (DBSEntityReferrer)constraint;
                            ArrayList<DBSEntityAttribute> references = new ArrayList<DBSEntityAttribute>();
                            for (DBSEntityAttributeRef ref : CommonUtils.safeCollection((Collection)referrer.getAttributeReferences(monitor))) {
                                references.add(ref.getAttribute());
                            }
                            ConstraintSelectorPanel.this.constraints.put(referrer, references);
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (DBException e) {
                        IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Error loading constraints", (Throwable)e);
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    UIUtils.syncExec(() -> {
                        for (DBSEntityReferrer constraint : ConstraintSelectorPanel.this.constraints.keySet()) {
                            ConstraintSelectorPanel.this.constraintsCombo.add(constraint.getName());
                        }
                        List selectedAttributes = !ArrayUtils.isEmpty((Object[])attributes) ? Arrays.asList(attributes) : (!ConstraintSelectorPanel.this.constraints.isEmpty() ? (List)ConstraintSelectorPanel.this.constraints.values().iterator().next() : null);
                        if (!CommonUtils.isEmpty(selectedAttributes)) {
                            ConstraintSelectorPanel.this.updateColumnSelection(selectedAttributes::contains);
                            ConstraintSelectorPanel.this.updateSelectedConstraint(selectedAttributes);
                            DCCompareTaskWizardPageConstraints.this.saveAttributes(ConstraintSelectorPanel.this, selectedAttributes);
                        }
                        DCCompareTaskWizardPageConstraints.this.updatePageCompletion();
                    });
                }
            });
            job.schedule();
        }

        protected void setEntity(DBSEntity entity) {
            super.setEntity(entity);
        }

        private void updateSelectedConstraint(@NotNull List<? extends DBSAttributeBase> selectedAttributes) {
            this.constraintsCombo.deselectAll();
            if (!selectedAttributes.isEmpty()) {
                int index = 0;
                for (List<DBSEntityAttribute> attributes : this.constraints.values()) {
                    if (attributes.equals(selectedAttributes)) {
                        this.constraintsCombo.select(index);
                        break;
                    }
                    ++index;
                }
            }
        }
    }
}

