/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.editor;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.ui.editor.DCCompareViewer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetLabelProvider;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.utils.ArrayUtils;

public class DCCompareViewerPane
extends Composite
implements IResultSetContainer,
IResultSetListener {
    private final DCCompareViewer compareViewer;
    private final ResultSetViewer resultSetViewer;
    private final List<DCRowDiff> diffs = new ArrayList<DCRowDiff>();
    private boolean left;
    private DCInput input;

    public DCCompareViewerPane(@NotNull Composite parent, @NotNull DCCompareViewer viewer, boolean left) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.compareViewer = viewer;
        this.resultSetViewer = new ResultSetViewer((Composite)this, viewer.getCompareConfiguration().getContainer().getWorkbenchPart().getSite(), (IResultSetContainer)this);
        this.resultSetViewer.addListener((IResultSetListener)this);
        this.left = left;
    }

    public void refresh(int offset, int count) {
        this.resultSetViewer.setDataFilter(this.createFilter(offset, count), false);
        this.resultSetViewer.resetHistory();
        this.resultSetViewer.refresh();
        this.diffs.clear();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.input == null ? null : DBUtils.getDefaultContext((DBSObject)this.input.getContainer(), (boolean)false);
    }

    @Nullable
    public DBPProject getProject() {
        return this.input == null ? null : this.input.getContainer().getDataSource().getContainer().getProject();
    }

    @Nullable
    public IResultSetController getResultSetController() {
        return null;
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.input.getContainer();
    }

    public boolean isReadyToRun() {
        return true;
    }

    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
        DBWorkbench.getPlatformUI().showError("Data container", "Not supported");
    }

    public IResultSetDecorator createResultSetDecorator() {
        return new ResultSetDecorator();
    }

    public void dispose() {
        this.resultSetViewer.removeListener((IResultSetListener)this);
        super.dispose();
    }

    public void handleResultSetLoad() {
        this.resultSetViewer.setDataFilter(this.createFilter(this.getRowCount(), this.getRowSegment()), false);
        if (this.diffs.isEmpty()) {
            for (DCRowDiff diff : this.compareViewer.getSummary()) {
                if (!diff.getState().isRelated(this.left)) continue;
                this.diffs.add(diff);
            }
        }
        this.compareViewer.signalDataLoad(this);
    }

    public void handleResultSetChange() {
    }

    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        IResultSetSelection selection = (IResultSetSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ResultSetRow selectedRow = (ResultSetRow)selection.getSelectedRows().get(0);
        if (this.diffs.size() <= selectedRow.getVisualNumber()) {
            return;
        }
        DCCompareViewerPane oppositePane = this.compareViewer.getOppositePane(this);
        int index = oppositePane.diffs.indexOf(this.diffs.get(selectedRow.getVisualNumber()));
        if (index >= 0) {
            Spreadsheet spreadsheet = this.getSpreadsheet();
            Spreadsheet oppositeSpreadsheet = oppositePane.getSpreadsheet();
            if (spreadsheet != null && oppositeSpreadsheet != null) {
                int topIndex = spreadsheet.getTopIndex();
                int topOffset = selectedRow.getVisualNumber() - topIndex;
                oppositeSpreadsheet.setSelection(index);
                oppositeSpreadsheet.showItem(index, topOffset);
                this.compareViewer.redrawRuler();
            }
        }
    }

    public int getRowCount() {
        return this.resultSetViewer.getModel().getRowCount();
    }

    public int getRowSegment() {
        return this.resultSetViewer.getSegmentMaxRows();
    }

    @Nullable
    public SpreadsheetPresentation getPresentation() {
        IResultSetPresentation presentation = this.resultSetViewer.getActivePresentation();
        return presentation instanceof SpreadsheetPresentation ? (SpreadsheetPresentation)presentation : null;
    }

    @Nullable
    public Spreadsheet getSpreadsheet() {
        SpreadsheetPresentation presentation = this.getPresentation();
        return presentation != null ? presentation.getSpreadsheet() : null;
    }

    @Nullable
    public ResultSetRow getResultSetRow(@NotNull DCRowDiff diff) {
        int index = this.diffs.indexOf(diff);
        if (index < 0) {
            return null;
        }
        ResultSetModel model = this.resultSetViewer.getModel();
        if (model.getRowCount() <= index) {
            return null;
        }
        return model.getRow(index);
    }

    public void setInput(@NotNull DCInput input, boolean left) {
        this.input = input;
        this.left = left;
    }

    private DBDDataFilter createFilter(int rowOffset, int rowCount) {
        DBSAttributeBase[] attributes = this.input.getAttributes();
        List values = IntStream.range(0, attributes.length).mapToObj(ArrayList::new).collect(Collectors.toList());
        for (DCRowDiff diff : this.compareViewer.getSummary()) {
            if (!diff.getState().isRelated(this.left)) continue;
            Object[] keys = diff.getKeys();
            int index = 0;
            while (index < attributes.length) {
                ((List)values.get(index)).add(keys[index]);
                ++index;
            }
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        int index = 0;
        while (index < attributes.length) {
            int position = constraints.size() + 1;
            DBDAttributeConstraint constraint = new DBDAttributeConstraint(attributes[index], position);
            constraint.setOrderPosition(position);
            constraint.setOperator(DBCLogicalOperator.IN);
            constraint.setValue((Object)((List)values.get(index)).toArray());
            constraints.add(constraint);
            ++index;
        }
        return new DBDDataFilter(constraints);
    }

    private class ResultSetDecorator
    extends QueryResultsDecorator
    implements IResultSetLabelProvider {
        private ResultSetDecorator() {
        }

        public long getDecoratorFeatures() {
            return 0L;
        }

        public String getPreferredPresentation() {
            return "spreadsheet";
        }

        public IResultSetLabelProvider getDataLabelProvider() {
            return this;
        }

        @Nullable
        public DBPImage getCellImage(DBDAttributeBinding attribute, ResultSetRow row) {
            return null;
        }

        @Nullable
        public Color getCellForeground(DBDAttributeBinding attribute, ResultSetRow row) {
            return null;
        }

        @Nullable
        public Color getCellBackground(DBDAttributeBinding attribute, ResultSetRow row) {
            if (DCCompareViewerPane.this.diffs.size() <= row.getVisualNumber()) {
                return null;
            }
            DCRowDiff diff = (DCRowDiff)DCCompareViewerPane.this.diffs.get(row.getVisualNumber());
            SpreadsheetPresentation presentation = DCCompareViewerPane.this.getPresentation();
            if (presentation == null) {
                return null;
            }
            switch (diff.getState()) {
                case INSERTED: {
                    if (!DCCompareViewerPane.this.left) {
                        return presentation.getBackgroundAdded();
                    }
                }
                case DELETED: {
                    if (DCCompareViewerPane.this.left) {
                        return presentation.getBackgroundDeleted();
                    }
                }
                case MODIFIED: {
                    if (!ArrayUtils.contains((int[])diff.getColumns(), (int)attribute.getOrdinalPosition())) break;
                    return presentation.getBackgroundModified();
                }
            }
            return null;
        }
    }
}

