/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.editor;

import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.model.DCRowState;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.ui.editor.DCCompareEditorItem;
import com.dbeaver.data.compare.ui.editor.DCCompareViewerPane;
import com.dbeaver.data.compare.ui.internal.DataCompareMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DCCompareViewer
extends ContentMergeViewer {
    private static final Log log = Log.getLog(DCCompareViewer.class);
    private static final int CENTER_WIDTH = 32;
    private static final int RESOLVE_SIZE = 5;
    private AncestorPane ancestorPane;
    private DCCompareViewerPane leftPane;
    private DCCompareViewerPane rightPane;
    private final Set<DCCompareViewerPane> finishedViewers = new HashSet<DCCompareViewerPane>();
    private double[] baseCenterCurve;
    private int[] baseCenterCurvePoints;

    public DCCompareViewer(@NotNull Composite parent, @NotNull CompareConfiguration configuration) {
        super(0, ResourceBundle.getBundle("com.dbeaver.data.compare.ui.internal.DataCompareMessages"), configuration);
        this.buildControl(parent);
    }

    protected void createControls(Composite composite) {
        this.ancestorPane = new AncestorPane(composite);
        this.leftPane = new DCCompareViewerPane(composite, this, true);
        this.rightPane = new DCCompareViewerPane(composite, this, false);
    }

    protected void createToolItems(ToolBarManager tbm) {
        try {
            ImageDescriptor swapIcon = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LINK_TO_EDITOR);
            ImageDescriptor propertiesIcon = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_MAIN_DETAILS);
            ActionContributionItem swapItem = (ActionContributionItem)tbm.getItems()[1];
            swapItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            swapItem.getAction().setImageDescriptor(swapIcon);
            swapItem.getAction().setDisabledImageDescriptor(swapIcon);
            swapItem.getAction().setHoverImageDescriptor(swapIcon);
            ActionContributionItem ancestorItem = (ActionContributionItem)tbm.getItems()[2];
            ancestorItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            ancestorItem.getAction().setImageDescriptor(propertiesIcon);
            ancestorItem.getAction().setDisabledImageDescriptor(propertiesIcon);
            ancestorItem.getAction().setHoverImageDescriptor(propertiesIcon);
        }
        catch (Throwable e) {
            log.debug((Object)"Error changing toolbar icons", e);
        }
    }

    protected Control createCenterControl(Composite parent) {
        Control control = super.createCenterControl(parent);
        control.addPaintListener(event -> {
            Spreadsheet leftSpreadsheet = this.leftPane.getSpreadsheet();
            Spreadsheet rightSpreadsheet = this.rightPane.getSpreadsheet();
            if (leftSpreadsheet == null || rightSpreadsheet == null) {
                return;
            }
            Display display = control.getDisplay();
            GC gc = event.gc;
            Point size = control.getSize();
            Color normalColor = display.getSystemColor(18);
            gc.setBackground(control.getBackground());
            gc.fillRectangle(1, 0, size.x - 2, size.y);
            gc.setBackground(normalColor);
            gc.fillRectangle(0, 0, 1, size.y);
            gc.fillRectangle(size.x - 1, 0, 1, size.y);
            int visibleHeight = rightSpreadsheet.getClientArea().height;
            int leftTopLine = leftSpreadsheet.getTopIndex();
            int leftBottomLine = leftSpreadsheet.getBottomIndex();
            int rightTopLine = rightSpreadsheet.getTopIndex();
            int rightBottomLine = rightSpreadsheet.getBottomIndex();
            int lh = leftSpreadsheet.getItemHeight();
            int rh = rightSpreadsheet.getItemHeight();
            for (DCRowDiff diff : this.getSummary()) {
                int ry;
                int ly;
                if (diff.getState() != DCRowState.MODIFIED) continue;
                ResultSetRow leftRow = this.leftPane.getResultSetRow(diff);
                ResultSetRow rightRow = this.rightPane.getResultSetRow(diff);
                if (leftRow == null || rightRow == null) continue;
                int leftRowNum = leftRow.getVisualNumber();
                int rightRowNum = rightRow.getVisualNumber();
                if (leftRowNum < leftTopLine || leftRowNum > leftBottomLine || rightRowNum < rightTopLine || rightRowNum > rightBottomLine || Math.max((ly = DCCompareViewer.getRowPosition(leftSpreadsheet, leftRow)) + lh, (ry = DCCompareViewer.getRowPosition(rightSpreadsheet, rightRow)) + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                boolean isSelected = leftSpreadsheet.isRowSelected(leftRowNum) || rightSpreadsheet.isRowSelected(rightRowNum);
                Color fillColor = isSelected ? normalColor : control.getBackground();
                Color strokeColor = control.getForeground();
                gc.setBackground(fillColor);
                gc.fillRectangle(0, ly, 3, lh);
                gc.fillRectangle(size.x - 3, ry, 3, rh);
                gc.setLineWidth(0);
                gc.setForeground(strokeColor);
                gc.drawRectangle(-1, ly, 3, lh - 1);
                gc.drawRectangle(size.x - 3, ry, 3, rh - 1);
                int[] points = this.getCenterCurvePoints(3, ly + lh / 2, size.x - 3, ry + rh / 2);
                int i = 1;
                while (i < points.length) {
                    gc.drawLine(i - 1 + 3, points[i - 1], i + 3, points[i]);
                    ++i;
                }
                int cx = (size.x - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                gc.setBackground(fillColor);
                gc.fillRectangle(cx, cy, 5, 5);
                gc.setForeground(strokeColor);
                gc.drawRectangle(cx, cy, 5, 5);
            }
        });
        return control;
    }

    private static int getRowPosition(Spreadsheet spreadsheet, ResultSetRow row) {
        return spreadsheet.getHeaderHeight() + (row.getVisualNumber() - spreadsheet.getTopIndex()) * (spreadsheet.getItemHeight() + 1);
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        this.ancestorPane.setBounds(x, y, width, height);
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        this.leftPane.setBounds(x, y, leftWidth, height);
        this.rightPane.setBounds(x + leftWidth + centerWidth, y, rightWidth, height);
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        DCCompareEditorItem leftItem = (DCCompareEditorItem)left;
        DCCompareEditorItem rightItem = (DCCompareEditorItem)right;
        this.ancestorPane.update(leftItem.getSummary());
        this.setPaneInput(this.leftPane, leftItem, true);
        this.setPaneInput(this.rightPane, rightItem, false);
        new AbstractUIJob("Read data"){

            protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                DCCompareViewer.this.finishedViewers.clear();
                DCCompareViewer.this.leftPane.refresh(DCCompareViewer.this.leftPane.getRowCount(), DCCompareViewer.this.leftPane.getRowSegment());
                DCCompareViewer.this.rightPane.refresh(DCCompareViewer.this.rightPane.getRowCount(), DCCompareViewer.this.rightPane.getRowSegment());
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void copy(boolean leftToRight) {
        DBWorkbench.getPlatformUI().showError("Data container", "Not supported");
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected int getCenterWidth() {
        return 32;
    }

    @NotNull
    public CompareConfiguration getCompareConfiguration() {
        return super.getCompareConfiguration();
    }

    @NotNull
    public DCCompareViewerPane getOppositePane(@NotNull DCCompareViewerPane pane) {
        return pane == this.leftPane ? this.rightPane : this.leftPane;
    }

    @NotNull
    public DCSummary getSummary() {
        DiffNode input = (DiffNode)this.getInput();
        DCCompareEditorItem item = (DCCompareEditorItem)input.getLeft();
        return item.getSummary();
    }

    public void signalDataLoad(@NotNull DCCompareViewerPane viewerPane) {
        if (!this.finishedViewers.add(viewerPane)) {
            return;
        }
        if (this.finishedViewers.size() < 2) {
            return;
        }
        for (DCCompareViewerPane pane : this.finishedViewers) {
            final Spreadsheet spreadsheet = pane.getSpreadsheet();
            final Spreadsheet oppositeSpreadsheet = this.getOppositePane(pane).getSpreadsheet();
            if (spreadsheet == null || oppositeSpreadsheet == null) {
                log.debug((Object)"Can't obtain spreadsheets to apply listeners to");
                continue;
            }
            SelectionAdapter horizontalScrollListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selection;
                    ScrollBar scroll1 = spreadsheet.getHorizontalBar();
                    ScrollBar scroll2 = oppositeSpreadsheet.getHorizontalBar();
                    if (scroll1.getSelection() > 0) {
                        float ratio = (float)(scroll1.getMaximum() - scroll1.getMinimum()) / (float)scroll1.getSelection();
                        selection = (int)((float)(scroll2.getMaximum() - scroll2.getMinimum()) / ratio);
                    } else {
                        selection = 0;
                    }
                    if (selection != scroll2.getSelection()) {
                        scroll2.setSelection(selection);
                        oppositeSpreadsheet.redrawGrid();
                    }
                }
            };
            SelectionAdapter verticalScrollListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DCCompareViewer.this.redrawRuler();
                }
            };
            UIExecutionQueue.queueExec(() -> this.lambda$1(spreadsheet, (SelectionListener)horizontalScrollListener, (SelectionListener)verticalScrollListener));
        }
        this.finishedViewers.clear();
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.baseCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = (double)(endy - starty) / 2.0;
        int width = endx - startx;
        if (this.baseCenterCurvePoints == null || this.baseCenterCurvePoints.length != width) {
            this.baseCenterCurvePoints = new int[width];
        }
        int i = 0;
        while (i < width) {
            this.baseCenterCurvePoints[i] = (int)(-height * this.baseCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return this.baseCenterCurvePoints;
    }

    private void buildBaseCenterCurve(int w) {
        this.baseCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / (double)w;
            this.baseCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    public void redrawRuler() {
        this.getCenterControl().redraw();
    }

    private void setPaneInput(@NotNull DCCompareViewerPane pane, @NotNull DCCompareEditorItem item, boolean left) {
        CompareConfiguration configuration = this.getCompareConfiguration();
        DBSDataContainer container = item.getInput().getContainer();
        if (configuration.isMirrored()) {
            boolean bl = left = !left;
        }
        if (left) {
            configuration.setLeftLabel(DCCompareViewer.getPaneLabel((DBSObject)container));
            configuration.setLeftImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)container)));
        } else {
            configuration.setRightLabel(DCCompareViewer.getPaneLabel((DBSObject)container));
            configuration.setRightImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)container)));
        }
        configuration.setAncestorLabel(DataCompareMessages.data_compare_editor_ancestor_label);
        pane.setInput(item.getInput(), left);
        pane.refresh(pane.getRowCount(), pane.getRowSegment());
    }

    @NotNull
    private static String getPaneLabel(@NotNull DBSObject object) {
        return NLS.bind((String)"{0} - {1}", (Object)DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI), (Object)object.getDataSource().getContainer().getName());
    }

    private /* synthetic */ void lambda$1(Spreadsheet spreadsheet, SelectionListener selectionListener, SelectionListener selectionListener2) {
        spreadsheet.getHorizontalBar().addSelectionListener(selectionListener);
        spreadsheet.getVerticalBar().addSelectionListener(selectionListener2);
        this.redrawRuler();
    }

    private class AncestorPane
    extends Composite {
        private final Table statisticsTable;
        private final Label leftContainerLabel;
        private final Link leftContainerLink;
        private final Label rightContainerLabel;
        private final Link rightContainerLink;
        private DBSDataContainer leftContainer;
        private DBSDataContainer rightContainer;

        public AncestorPane(Composite parent) {
            super(parent, 0);
            this.setLayoutData(new GridData(1808));
            this.setLayout((Layout)new GridLayout(2, false));
            this.statisticsTable = new Table((Composite)this, 67588);
            UIUtils.createTableColumn((Table)this.statisticsTable, (int)16384, (String)DataCompareMessages.data_compare_editor_ancestor_summary_name_label);
            UIUtils.createTableColumn((Table)this.statisticsTable, (int)16384, (String)DataCompareMessages.data_compare_editor_ancestor_summary_value_label);
            SelectionAdapter adapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBSDataContainer object = e.getSource() == AncestorPane.this.leftContainerLink ? AncestorPane.this.leftContainer : AncestorPane.this.rightContainer;
                    UIUtils.runUIJob((String)"Open object editor", arg_0 -> 1.lambda$0((DBSObject)object, arg_0));
                }

                private static /* synthetic */ void lambda$0(DBSObject dBSObject, DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)dBSObject, (boolean)true);
                    if (node != null) {
                        NavigatorUtils.openNavigatorNode((Object)node, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
                    }
                }
            };
            Composite composite = UIUtils.createComposite((Composite)this, (int)3);
            composite.setLayoutData((Object)new GridData(4, 4, false, false));
            UIUtils.createControlLabel((Composite)composite, (String)DataCompareMessages.data_compare_editor_ancestor_container_left_title);
            this.leftContainerLabel = UIUtils.createLabel((Composite)composite, (DBPImage)DBIcon.TREE_TABLE);
            this.leftContainerLink = UIUtils.createLink((Composite)composite, (String)"N/A", (SelectionListener)adapter);
            UIUtils.createControlLabel((Composite)composite, (String)DataCompareMessages.data_compare_editor_ancestor_container_right_title);
            this.rightContainerLabel = UIUtils.createLabel((Composite)composite, (DBPImage)DBIcon.TREE_TABLE);
            this.rightContainerLink = UIUtils.createLink((Composite)composite, (String)"N/A", (SelectionListener)adapter);
        }

        public void update(@NotNull DCSummary summary) {
            DCSettings settings = summary.getSettings();
            if (DCCompareViewer.this.getCompareConfiguration().isMirrored()) {
                this.leftContainer = settings.getRightInput().getContainer();
                this.rightContainer = settings.getLeftInput().getContainer();
            } else {
                this.leftContainer = settings.getLeftInput().getContainer();
                this.rightContainer = settings.getRightInput().getContainer();
            }
            this.statisticsTable.removeAll();
            this.add(DataCompareMessages.data_compare_editor_ancestor_summary_item_elapsed_time_label, RuntimeUtils.formatExecutionTime((long)summary.getCompareTime()));
            this.add(DataCompareMessages.data_compare_editor_ancestor_summary_item_modified_rows_label, summary.getModifiedRowsCount());
            this.add(DataCompareMessages.data_compare_editor_ancestor_summary_item_deleted_rows_label, summary.getDeletedRowsCount());
            this.add(DataCompareMessages.data_compare_editor_ancestor_summary_item_inserted_rows_label, summary.getInsertedRowsCount());
            this.add(DataCompareMessages.data_compare_editor_ancestor_summary_item_total_compared_rows_label, summary.getTotalComparedRowsCount());
            this.add(DataCompareMessages.data_compare_editor_ancestor_summary_item_total_different_rows_label, String.format("%d (%.2f%%)", summary.getTotalDifferentRowsCount(), (double)summary.getTotalDifferentRowsCount() / (double)summary.getTotalComparedRowsCount() * 100.0));
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.statisticsTable, (boolean)false));
            this.leftContainerLink.setText("<a>" + DBUtils.getObjectFullName((DBPNamedObject)this.leftContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "</a>");
            this.leftContainerLink.setToolTipText(DCCompareViewer.getPaneLabel((DBSObject)this.leftContainer));
            this.rightContainerLink.setText("<a>" + DBUtils.getObjectFullName((DBPNamedObject)this.rightContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "</a>");
            this.rightContainerLink.setToolTipText(DCCompareViewer.getPaneLabel((DBSObject)this.rightContainer));
            UIUtils.runUIJob((String)"Load objects icons", monitor -> {
                DBNDatabaseNode rightContainerNode;
                DBNDatabaseNode leftContainerNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)this.leftContainer, (boolean)true);
                if (leftContainerNode != null) {
                    this.leftContainerLabel.setImage(DBeaverIcons.getImage((DBPImage)leftContainerNode.getNodeIcon()));
                }
                if ((rightContainerNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)this.rightContainer, (boolean)true)) != null) {
                    this.rightContainerLabel.setImage(DBeaverIcons.getImage((DBPImage)rightContainerNode.getNodeIcon()));
                }
                this.leftContainerLabel.getParent().layout(true, true);
            });
        }

        private void add(@NotNull String name, @NotNull Object value) {
            TableItem item = new TableItem(this.statisticsTable, 0);
            item.setText(0, name);
            item.setText(1, DBUtils.getObjectShortName((Object)value));
        }
    }
}

