/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui;

import com.dbeaver.data.compare.ui.DataCompareEngine;
import com.dbeaver.data.compare.ui.DataCompareResultsViewer;
import com.dbeaver.data.compare.ui.internal.DataCompareActivator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.utils.CommonUtils;

public class DataCompareViewer
extends ContentMergeViewer {
    private static final int CENTER_WIDTH = 32;
    private static final int RESOLVE_SIZE = 5;
    private static final int MAX_DIFF_LINES = 100;
    private Composite ancestor;
    private DataCompareResultsViewer leftPane;
    private DataCompareResultsViewer rightPane;
    private Set<DataCompareResultsViewer> finishedViewers = new HashSet<DataCompareResultsViewer>();
    private DataCompareEngine compareEngine;
    private SelectionListener verticalScrollListener;
    private boolean fHighlightRanges = true;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    private double[] fBasicCenterCurve;

    DataCompareViewer(Composite parent, CompareConfiguration compareConfiguration) {
        super(0, ResourceBundle.getBundle("com.dbeaver.data.compare.ui.internal.DataCompareMessages"), compareConfiguration);
        this.buildControl(parent);
    }

    public DataCompareEngine getCompareEngine() {
        return this.compareEngine;
    }

    public boolean isAttributeMissing(DataCompareResultsViewer resultsViewer, DBDAttributeBinding attribute) {
        Set<DBDAttributeBinding> missing;
        if (this.compareEngine == null) {
            return false;
        }
        Set<DBDAttributeBinding> set = missing = resultsViewer == this.leftPane ? this.compareEngine.getLeftAttrMissing() : this.compareEngine.getRightAttrMissing();
        return !missing.isEmpty() && missing.contains(attribute);
    }

    public CompareConfiguration getCompareConfiguration() {
        return super.getCompareConfiguration();
    }

    protected void createControls(Composite composite) {
        this.ancestor = new Tree(composite, 4);
        this.leftPane = new DataCompareResultsViewer(composite, this, null);
        this.rightPane = new DataCompareResultsViewer(composite, this, null);
    }

    private void syncVerticalScroll(DataCompareResultsViewer rsv) {
        ResultSetRow currentRow = rsv.getResultSetController().getCurrentRow();
        if (currentRow == null) {
            return;
        }
        DataCompareResultsViewer oppositeViewer = this.getOppositeResultsViewer(rsv);
        Map<ResultSetRow, ResultSetRow> rowMap = rsv == this.leftPane ? this.compareEngine.getLeftToRightMap() : this.compareEngine.getRightToLeftMap();
        ResultSetRow oppositeRow = rowMap.get(currentRow);
        if (oppositeRow != null) {
            int topIndex = rsv.getSpreadsheet().getTopIndex();
            int topOffset = currentRow.getVisualNumber() - topIndex;
            oppositeViewer.getSpreadsheet().setSelection(oppositeRow.getVisualNumber());
            oppositeViewer.getSpreadsheet().showItem(oppositeRow.getVisualNumber(), topOffset);
            this.redrawCenterControl();
        }
    }

    private void handleVerticalScroll(SelectionEvent e) {
        this.redrawCenterControl();
    }

    private void redrawCenterControl() {
        this.getCenterControl().redraw();
    }

    private void handleHorizontalScroll(DataCompareResultsViewer rsv, SelectionEvent e) {
        int newSelection;
        DataCompareResultsViewer second = this.getOppositeResultsViewer(rsv);
        ScrollBar hsb = rsv.getSpreadsheet().getHorizontalBar();
        ScrollBar hsb2 = second.getSpreadsheet().getHorizontalBar();
        int oldSelection = hsb2.getSelection();
        if (hsb.getSelection() == 0) {
            newSelection = 0;
        } else {
            float ratio = (float)(hsb.getMaximum() - hsb.getMinimum()) / (float)hsb.getSelection();
            newSelection = (int)((float)(hsb2.getMaximum() - hsb2.getMinimum()) / ratio);
        }
        if (oldSelection != newSelection) {
            hsb2.setValues(newSelection, 0, hsb2.getMaximum(), hsb2.getThumb(), hsb2.getIncrement(), hsb2.getPageIncrement());
            second.getSpreadsheet().redrawGrid();
        }
    }

    private DataCompareResultsViewer getOppositeResultsViewer(DataCompareResultsViewer rsv) {
        return rsv == this.leftPane ? this.rightPane : this.leftPane;
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        this.ancestor.setBounds(x, y, width, height);
    }

    protected void handleResizeLeftRight(int x, int y, int leftWidth, int centerWidth, int rightWidth, int height) {
        this.leftPane.setBounds(x, y, leftWidth, height);
        this.rightPane.setBounds(x + leftWidth + centerWidth, y, rightWidth, height);
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.refreshData(left, right);
    }

    private void refreshData(Object left, Object right) {
        this.setPaneInput(this.leftPane, left, true);
        this.setPaneInput(this.rightPane, right, false);
        new AbstractUIJob("Read data"){

            protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                DataCompareViewer.this.finishedViewers.clear();
                try {
                    DataCompareViewer.this.leftPane.applyFilters(monitor);
                    DataCompareViewer.this.rightPane.applyFilters(monitor);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Data read error", "Error extracting data from entities", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void setPaneInput(DataCompareResultsViewer pane, Object input, boolean left) {
        if (input instanceof DBSWrapper) {
            input = ((DBSWrapper)input).getObject();
        }
        if (input instanceof DBSDataContainer) {
            DBSDataContainer dataContainer = (DBSDataContainer)input;
            CompareConfiguration compareConfiguration = this.getCompareConfiguration();
            if (compareConfiguration.isMirrored()) {
                boolean bl = left = !left;
            }
            if (left) {
                compareConfiguration.setLeftLabel(String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI)) + "   [" + dataContainer.getDataSource().getContainer().getName() + "]");
                compareConfiguration.setLeftImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)dataContainer)));
            } else {
                compareConfiguration.setRightLabel(String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI)) + "   [" + dataContainer.getDataSource().getContainer().getName() + "]");
                compareConfiguration.setRightImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)dataContainer)));
            }
            pane.setDataContainer(dataContainer);
        }
    }

    protected int getCenterWidth() {
        return 32;
    }

    protected final Control createCenterControl(Composite parent) {
        Control centerControl = super.createCenterControl(parent);
        centerControl.addPaintListener(e -> this.paintCenter(centerControl, e.gc));
        return centerControl;
    }

    protected void copy(boolean leftToRight) {
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    public void signalDataLoad(DataCompareResultsViewer resultsViewer) {
        if (this.finishedViewers.contains((Object)resultsViewer)) {
            return;
        }
        this.finishedViewers.add(resultsViewer);
        if (this.finishedViewers.size() == 2) {
            if (this.verticalScrollListener == null) {
                this.verticalScrollListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DataCompareViewer.this.handleVerticalScroll(e);
                    }
                };
                UIExecutionQueue.queueExec(() -> {
                    this.finishedViewers.forEach(rsv -> {
                        rsv.getSpreadsheet().getVerticalBar().addSelectionListener(this.verticalScrollListener);
                        SelectionAdapter horizontalScrollListener = new SelectionAdapter((DataCompareResultsViewer)((Object)((Object)rsv))){
                            private final /* synthetic */ DataCompareResultsViewer val$rsv;
                            {
                                this.val$rsv = dataCompareResultsViewer;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                DataCompareViewer.this.handleHorizontalScroll(this.val$rsv, e);
                            }
                        };
                        rsv.getSpreadsheet().getHorizontalBar().addSelectionListener((SelectionListener)horizontalScrollListener);
                        rsv.getSpreadsheet().addSelectionListener((SelectionListener)new SelectionAdapter((DataCompareResultsViewer)((Object)((Object)rsv))){
                            private final /* synthetic */ DataCompareResultsViewer val$rsv;
                            {
                                this.val$rsv = dataCompareResultsViewer;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                DataCompareViewer.this.syncVerticalScroll(this.val$rsv);
                            }
                        });
                    });
                    this.finishedViewers.clear();
                });
            }
            this.runDataCompare();
        }
    }

    private void runDataCompare() {
        new AbstractUIJob("Compare data"){

            protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                DataCompareViewer.this.performDataCompare(monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void performDataCompare(DBRProgressMonitor monitor) {
        this.compareEngine = new DataCompareEngine();
        this.compareEngine.performCompare(monitor, this.leftPane.getResultSetController(), this.rightPane.getResultSetController());
        UIExecutionQueue.queueExec(() -> {
            this.initSpreadsheet(this.leftPane);
            this.initSpreadsheet(this.rightPane);
            this.redrawCenterControl();
        });
    }

    private void initSpreadsheet(DataCompareResultsViewer viewer) {
        viewer.getPresentation().setShowOddRows(false);
        viewer.getPresentation().setAutoFetchSegments(false);
        viewer.getSpreadsheet().redraw();
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        toolBarManager.add((IAction)new Action("Next change", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_DOWN)){

            public void run() {
                DataCompareViewer.this.navigateToChange(true);
            }
        });
        toolBarManager.add((IAction)new Action("Previous change", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ARROW_UP)){

            public void run() {
                DataCompareViewer.this.navigateToChange(false);
            }
        });
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)new ControlContribution("Max rows"){

            protected Control createControl(Composite parent) {
                Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
                Text text = UIUtils.createLabelText((Composite)composite, (String)"Batch size", (String)("" + DataCompareActivator.getDefault().getPreferences().getInt("data.compare.batch.size")), (int)2048);
                ((GridData)text.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)text) * 6;
                text.addModifyListener(e -> DataCompareActivator.getDefault().getPreferences().setValue("data.compare.batch.size", CommonUtils.toInt((Object)text.getText())));
                return composite;
            }
        });
        toolBarManager.add((IAction)new Action("Re-run data compare", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

            public void run() {
                DataCompareViewer.this.refreshData(DataCompareViewer.this.leftPane.getDataContainer(), DataCompareViewer.this.rightPane.getDataContainer());
            }
        });
        toolBarManager.add((IContributionItem)new Separator());
    }

    private void navigateToChange(boolean next) {
        List<ResultSetRow> rowsChanged;
        DataCompareResultsViewer viewer;
        if (this.leftPane.getSpreadsheet().isFocusControl()) {
            viewer = this.leftPane;
            rowsChanged = this.compareEngine.getLeftRowsChanged();
        } else {
            viewer = this.rightPane;
            rowsChanged = this.compareEngine.getRightRowsChanged();
        }
        if (rowsChanged.isEmpty()) {
            return;
        }
        ResultSetRow currentRow = viewer.getResultSetController().getCurrentRow();
        if (currentRow == null) {
            if (viewer.getResultSetController().getModel().getRowCount() <= 0) {
                return;
            }
            currentRow = viewer.getResultSetController().getModel().getRow(0);
        }
        ResultSetRow nextRow = null;
        if (next) {
            int i = rowsChanged.indexOf(currentRow) + 1;
            while (i < rowsChanged.size()) {
                ResultSetRow resultSetRow = rowsChanged.get(i);
                if (resultSetRow.getVisualNumber() > currentRow.getVisualNumber()) {
                    nextRow = resultSetRow;
                    break;
                }
                ++i;
            }
            if (nextRow == null) {
                nextRow = rowsChanged.get(0);
            }
        } else {
            int i = rowsChanged.indexOf(currentRow);
            while (i > 0) {
                ResultSetRow resultSetRow = rowsChanged.get(i - 1);
                if (resultSetRow.getVisualNumber() < currentRow.getVisualNumber()) {
                    nextRow = resultSetRow;
                    break;
                }
                --i;
            }
            if (nextRow == null) {
                nextRow = rowsChanged.get(rowsChanged.size() - 1);
            }
        }
        viewer.getResultSetController().setCurrentRow(nextRow);
        viewer.getSpreadsheet().setSelection(nextRow.getVisualNumber());
        viewer.getSpreadsheet().showItem(nextRow.getVisualNumber());
        this.syncVerticalScroll(viewer);
    }

    private boolean isAnySideEditable() {
        return true;
    }

    private void paintCenter(Control canvas, GC g) {
        Display display = canvas.getDisplay();
        Spreadsheet leftSpreadsheet = this.leftPane.getSpreadsheet();
        Spreadsheet rightSpreadsheet = this.rightPane.getSpreadsheet();
        if (leftSpreadsheet == null || rightSpreadsheet == null) {
            return;
        }
        leftSpreadsheet.getItemHeight();
        rightSpreadsheet.getItemHeight();
        int visibleHeight = rightSpreadsheet.getClientArea().height;
        Point size = canvas.getSize();
        int x = 0;
        int w = size.x;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x + 1, 0, w - 2, size.y);
        g.setBackground(display.getSystemColor(18));
        g.fillRectangle(0, 0, 1, size.y);
        g.fillRectangle(w - 1, 0, 1, size.y);
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.compareEngine.hasChanges()) {
            int totalLines = 0;
            int leftTopLine = leftSpreadsheet.getTopIndex();
            int leftBottomLine = leftSpreadsheet.getBottomIndex();
            int rightTopLine = rightSpreadsheet.getTopIndex();
            int rightBottomLine = rightSpreadsheet.getBottomIndex();
            int[] fPts = new int[8];
            for (ResultSetRow leftRow : this.compareEngine.getLeftRowsChanged()) {
                int i;
                int rh;
                int ry;
                int lh;
                ResultSetRow rightRow = this.compareEngine.getLeftToRightMap().get(leftRow);
                if (rightRow == null) continue;
                int leftRowNum = leftRow.getVisualNumber();
                int rightRowNum = rightRow.getVisualNumber();
                if ((leftRowNum < leftTopLine || leftRowNum > leftBottomLine) && (rightRowNum < rightTopLine || rightRowNum > rightBottomLine)) continue;
                boolean isSelected = leftSpreadsheet.isRowSelected(leftRowNum) || rightSpreadsheet.isRowSelected(rightRowNum);
                int ly = this.leftPane.getRowPosition(leftSpreadsheet, leftRow);
                if (Math.max(ly + (lh = leftSpreadsheet.getItemHeight()), (ry = this.rightPane.getRowPosition(rightSpreadsheet, rightRow)) + (rh = rightSpreadsheet.getItemHeight())) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                fPts[0] = x;
                fPts[1] = ly;
                fPts[2] = w;
                fPts[3] = ry;
                fPts[6] = x;
                fPts[7] = ly + lh;
                fPts[4] = w;
                fPts[5] = ry + rh;
                Color fillColor = this.getFillColor(canvas, isSelected, false);
                Color strokeColor = this.getStrokeColor(canvas, false);
                if (this.fUseSingleLine) {
                    int w2 = 3;
                    g.setBackground(fillColor);
                    g.fillRectangle(0, ly, w2, lh);
                    g.fillRectangle(w - w2, ry, w2, rh);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawRectangle(-1, ly, w2, lh - 1);
                    g.drawRectangle(w - w2, ry, w2, rh - 1);
                    if (this.fUseSplines) {
                        int[] points = this.getCenterCurvePoints(w2, ly + lh / 2, w - w2, ry + rh / 2);
                        i = 1;
                        while (i < points.length) {
                            g.drawLine(w2 + i - 1, points[i - 1], w2 + i, points[i]);
                            ++i;
                        }
                    } else {
                        g.drawLine(w2, ly + lh / 2, w - w2, ry + rh / 2);
                    }
                } else if (this.fUseSplines) {
                    g.setBackground(fillColor);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    int[] topPoints = this.getCenterCurvePoints(fPts[0], fPts[1], fPts[2], fPts[3]);
                    int[] bottomPoints = this.getCenterCurvePoints(fPts[6], fPts[7], fPts[4], fPts[5]);
                    g.setForeground(fillColor);
                    g.drawLine(0, bottomPoints[0], 0, topPoints[0]);
                    i = 1;
                    while (i < bottomPoints.length) {
                        g.setForeground(fillColor);
                        g.drawLine(i, bottomPoints[i], i, topPoints[i]);
                        g.setForeground(strokeColor);
                        g.drawLine(i - 1, topPoints[i - 1], i, topPoints[i]);
                        g.drawLine(i - 1, bottomPoints[i - 1], i, bottomPoints[i]);
                        ++i;
                    }
                } else {
                    g.setBackground(fillColor);
                    g.fillPolygon(fPts);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawLine(fPts[0], fPts[1], fPts[2], fPts[3]);
                    g.drawLine(fPts[6], fPts[7], fPts[4], fPts[5]);
                }
                if (this.fUseSingleLine && this.isAnySideEditable()) {
                    int cx = (w - 5) / 2;
                    int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                    g.setBackground(fillColor);
                    g.fillRectangle(cx, cy, 5, 5);
                    g.setForeground(strokeColor);
                    g.drawRectangle(cx, cy, 5, 5);
                }
                ++totalLines;
            }
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private Color getFillColor(Control canvas, boolean isSelected, boolean showAdditionRemoval) {
        return isSelected ? canvas.getDisplay().getSystemColor(18) : canvas.getBackground();
    }

    private Color getStrokeColor(Control canvas, boolean showAdditionRemoval) {
        return canvas.getForeground();
    }
}

