/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui;

import com.dbeaver.data.compare.ui.DataCompareResultsDecorator;
import com.dbeaver.data.compare.ui.DataCompareViewer;
import com.dbeaver.data.compare.ui.internal.DataCompareActivator;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.utils.CommonUtils;

public class DataCompareResultsViewer
extends Composite
implements IResultSetContainer,
IResultSetListener {
    private DataCompareViewer compareViewer;
    private DBSDataContainer dataContainer;
    private final ResultSetViewer resultSetViewer;
    private String errorMessage;
    private String errorDescription;

    DataCompareResultsViewer(Composite parent, DataCompareViewer compareViewer, DBSDataContainer dataContainer) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.compareViewer = compareViewer;
        this.dataContainer = dataContainer;
        this.resultSetViewer = new ResultSetViewer((Composite)this, compareViewer.getCompareConfiguration().getContainer().getWorkbenchPart().getSite(), (IResultSetContainer)this);
        DBPPreferenceStore preferenceStore = DataCompareActivator.getDefault().getPreferences();
        this.resultSetViewer.setSegmentFetchSize(Integer.valueOf(preferenceStore.getInt("data.compare.batch.size")));
        DBPPreferenceListener preferenceListener = event -> {
            if ("data.compare.batch.size".equals(event.getProperty())) {
                this.resultSetViewer.setSegmentFetchSize(Integer.valueOf(CommonUtils.toInt((Object)event.getNewValue())));
            }
        };
        preferenceStore.addPropertyChangeListener(preferenceListener);
        parent.addDisposeListener(e -> preferenceStore.removePropertyChangeListener(preferenceListener));
        this.resultSetViewer.addListener((IResultSetListener)this);
    }

    public DataCompareViewer getCompareViewer() {
        return this.compareViewer;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public DBPProject getProject() {
        return this.dataContainer == null ? null : this.dataContainer.getDataSource().getContainer().getProject();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return DBUtils.getDefaultContext((DBSObject)this.dataContainer, (boolean)false);
    }

    @NotNull
    public IResultSetController getResultSetController() {
        return this.resultSetViewer;
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    void setDataContainer(DBSDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    void applyFilters(DBRProgressMonitor monitor) throws DBException {
        DBVEntityConstraint vConstraint;
        DBVEntity virtualEntity;
        if (!(this.dataContainer instanceof DBSEntity)) {
            this.errorMessage = "Error reading data";
            this.errorDescription = "Data container '" + this.dataContainer.getName() + "' is not entity";
            return;
        }
        List pkColumns = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)this.dataContainer));
        if (CommonUtils.isEmpty((Collection)pkColumns) && (virtualEntity = DBVUtils.getVirtualEntity((DBSEntity)((DBSEntity)this.dataContainer), (boolean)false)) != null && (vConstraint = virtualEntity.getBestIdentifier()) != null) {
            pkColumns = DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)vConstraint);
        }
        if (CommonUtils.isEmpty((Collection)pkColumns)) {
            this.errorMessage = "Error reading data";
            this.errorDescription = "Table '" + this.dataContainer.getName() + "' doesn't have a unique key or index";
            return;
        }
        this.errorMessage = "Data extraction in progress ...";
        DBDDataFilter dataFilter = new DBDDataFilter();
        StringBuilder orderBy = new StringBuilder();
        for (DBSEntityAttribute attr : pkColumns) {
            if (orderBy.length() > 0) {
                orderBy.append(",");
            }
            orderBy.append(DBUtils.getQuotedIdentifier((DBSObject)attr));
        }
        dataFilter.setOrder(orderBy.toString());
        this.resultSetViewer.setDataFilter(dataFilter, false);
        this.resultSetViewer.resetHistory();
        this.resultSetViewer.refresh();
    }

    public boolean isReadyToRun() {
        return true;
    }

    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
    }

    public IResultSetDecorator createResultSetDecorator() {
        return new DataCompareResultsDecorator(this);
    }

    public void handleResultSetLoad() {
        this.compareViewer.signalDataLoad(this);
    }

    public void handleResultSetChange() {
    }

    public void handleResultSetSelectionChange(SelectionChangedEvent event) {
    }

    public SpreadsheetPresentation getPresentation() {
        IResultSetPresentation activePresentation = this.resultSetViewer.getActivePresentation();
        return activePresentation instanceof SpreadsheetPresentation ? (SpreadsheetPresentation)activePresentation : null;
    }

    public Spreadsheet getSpreadsheet() {
        SpreadsheetPresentation presentation = this.getPresentation();
        return presentation == null ? null : presentation.getSpreadsheet();
    }

    public int getRowPosition(Spreadsheet spreadsheet, ResultSetRow row) {
        return spreadsheet.getHeaderHeight() + (row.getVisualNumber() - spreadsheet.getTopIndex()) * (spreadsheet.getItemHeight() + 1);
    }
}

