/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui;

import com.dbeaver.data.compare.ui.DataCompareRowId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;

public class DataCompareEngine {
    private Map<ResultSetRow, ResultSetRow> leftToRightMap = new IdentityHashMap<ResultSetRow, ResultSetRow>();
    private Map<ResultSetRow, ResultSetRow> rightToLeftMap = new IdentityHashMap<ResultSetRow, ResultSetRow>();
    private int leftRowAdded;
    private int leftRowDuplicated;
    private int rightRowAdded;
    private int rightRowDuplicated;
    private List<ResultSetRow> leftRowsChanged = new ArrayList<ResultSetRow>();
    private List<ResultSetRow> rightRowsChanged = new ArrayList<ResultSetRow>();
    private Set<DBDAttributeBinding> leftAttrMissing = new HashSet<DBDAttributeBinding>();
    private Set<DBDAttributeBinding> rightAttrMissing = new HashSet<DBDAttributeBinding>();

    public List<ResultSetRow> getLeftRowsChanged() {
        return this.leftRowsChanged;
    }

    public List<ResultSetRow> getRightRowsChanged() {
        return this.rightRowsChanged;
    }

    public Map<ResultSetRow, ResultSetRow> getLeftToRightMap() {
        return this.leftToRightMap;
    }

    public Map<ResultSetRow, ResultSetRow> getRightToLeftMap() {
        return this.rightToLeftMap;
    }

    public Set<DBDAttributeBinding> getLeftAttrMissing() {
        return this.leftAttrMissing;
    }

    public Set<DBDAttributeBinding> getRightAttrMissing() {
        return this.rightAttrMissing;
    }

    public int getLeftRowAdded() {
        return this.leftRowAdded;
    }

    public int getLeftRowDuplicated() {
        return this.leftRowDuplicated;
    }

    public int getRightRowAdded() {
        return this.rightRowAdded;
    }

    public int getRightRowDuplicated() {
        return this.rightRowDuplicated;
    }

    public boolean hasChanges() {
        return !this.leftRowsChanged.isEmpty();
    }

    public void performCompare(DBRProgressMonitor monitor, IResultSetController leftViewer, IResultSetController rightViewer) {
        ResultSetModel leftModel = leftViewer.getModel();
        ResultSetModel rightModel = rightViewer.getModel();
        DBDRowIdentifier id1 = this.getRowIdentifier(leftModel);
        this.getRowIdentifier(rightModel);
        int[] id1Indexes = this.makeIdentifierIndexes(id1);
        int[] id2Indexes = this.makeIdentifierIndexes(id1);
        HashMap leftRowMap = new HashMap();
        HashMap rightRowMap = new HashMap();
        List leftAllRows = leftModel.getAllRows();
        List rightAllRows = rightModel.getAllRows();
        leftAllRows.forEach(row -> {
            ResultSetRow resultSetRow = leftRowMap.putIfAbsent(new DataCompareRowId((ResultSetRow)row, id1Indexes), row);
        });
        rightAllRows.forEach(row -> {
            ResultSetRow resultSetRow = rightRowMap.putIfAbsent(new DataCompareRowId((ResultSetRow)row, id2Indexes), row);
        });
        boolean[] leftRowsChecked = new boolean[leftAllRows.size()];
        boolean[] rightRowsChecked = new boolean[rightAllRows.size()];
        int i = 0;
        while (i < leftAllRows.size()) {
            ResultSetRow leftRow = (ResultSetRow)leftAllRows.get(i);
            ResultSetRow rightRow = (ResultSetRow)rightRowMap.get(new DataCompareRowId(leftRow, id1Indexes));
            if (rightRow == null) {
                leftRow.setState((byte)2);
                ++this.leftRowAdded;
            } else if (rightRowsChecked[rightRow.getRowNumber()]) {
                leftRow.setState((byte)2);
                ++this.leftRowDuplicated;
            } else {
                this.leftToRightMap.put(leftRow, rightRow);
                this.rightToLeftMap.put(rightRow, leftRow);
                this.compareRows(leftModel, leftRow, rightModel, rightRow, this.leftAttrMissing);
                this.compareRows(rightModel, rightRow, leftModel, leftRow, this.rightAttrMissing);
                leftRowsChecked[i] = true;
                rightRowsChecked[rightRow.getRowNumber()] = true;
                if (leftRow.isChanged()) {
                    this.leftRowsChanged.add(leftRow);
                }
                if (rightRow.isChanged()) {
                    this.rightRowsChanged.add(leftRow);
                }
            }
            ++i;
        }
        i = 0;
        while (i < rightAllRows.size()) {
            ResultSetRow rightRow = (ResultSetRow)rightAllRows.get(i);
            ResultSetRow leftRow = (ResultSetRow)leftRowMap.get(new DataCompareRowId(rightRow, id2Indexes));
            if (leftRow == null) {
                rightRow.setState((byte)2);
                ++this.rightRowAdded;
            } else if (!rightRowsChecked[rightRow.getRowNumber()]) {
                rightRow.setState((byte)2);
                ++this.rightRowDuplicated;
            }
            ++i;
        }
    }

    private void compareRows(ResultSetModel leftModel, ResultSetRow leftRow, ResultSetModel rightModel, ResultSetRow rightRow, Set<DBDAttributeBinding> missingAttributes) {
        for (DBDAttributeBinding la : leftModel.getVisibleAttributes()) {
            Object rightValue;
            DBDAttributeBinding ra = (DBDAttributeBinding)DBUtils.findObject((Collection)rightModel.getVisibleAttributes(), (String)la.getName());
            if (ra == null || this.isDifferentAttributes(la, ra)) {
                missingAttributes.add(la);
                continue;
            }
            Object leftValue = leftRow.values[la.getOrdinalPosition()];
            if (DBUtils.compareDataValues((Object)leftValue, (Object)(rightValue = rightRow.values[ra.getOrdinalPosition()])) == 0) continue;
            leftRow.addChange(la, rightValue);
        }
    }

    private boolean isDifferentAttributes(DBDAttributeBinding a1, DBDAttributeBinding a2) {
        return a1.getDataKind() != a2.getDataKind();
    }

    private int[] makeIdentifierIndexes(DBDRowIdentifier id) {
        List attributes = id.getAttributes();
        int[] indexes = new int[attributes.size()];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = ((DBDAttributeBinding)attributes.get(i)).getOrdinalPosition();
            ++i;
        }
        return indexes;
    }

    private DBDRowIdentifier getRowIdentifier(ResultSetModel model) {
        DBDRowIdentifier id = model.getDefaultRowIdentifier();
        if (id == null || !id.isValidIdentifier()) {
            DBVEntity vEntity = model.getVirtualEntity(true);
            id = new DBDRowIdentifier((DBSEntity)vEntity, (DBSEntityConstraint)vEntity.getBestIdentifier());
        }
        return id;
    }
}

