/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;

public class DataCompareEditorInput
extends CompareEditorInput {
    private static final String CONTENT_TYPE_DATA_ID = "org.jkiss.dbeaver.data";
    private static final String CONTENT_TYPE_DATA_EXT = "databasedata";
    private static final Log log = Log.getLog(DataCompareEditorInput.class);
    private DBSObject leftEntity;
    private DBSObject rightEntity;

    public DataCompareEditorInput(DBSObject leftEntity, DBSObject rightEntity) {
        super(new CompareConfiguration());
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
        this.setTitle(String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)leftEntity, (DBPEvaluationContext)DBPEvaluationContext.UI)) + " / " + DBUtils.getObjectFullName((DBPNamedObject)rightEntity, (DBPEvaluationContext)DBPEvaluationContext.UI));
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ITypedElement ancestor = null;
        CompareItem left = new CompareItem(this.leftEntity);
        CompareItem right = new CompareItem(this.rightEntity);
        return new DiffNode(null, 12, ancestor, (ITypedElement)left, (ITypedElement)right);
    }

    static class CompareItem
    implements ITypedElement,
    DBSWrapper {
        private String name;
        private DBSObject entity;

        public CompareItem(DBSObject entity) {
            this.entity = entity;
        }

        public DBSObject getEntity() {
            return this.entity;
        }

        public String getName() {
            return this.entity == null ? "" : this.entity.getName();
        }

        public String getType() {
            return DataCompareEditorInput.CONTENT_TYPE_DATA_EXT;
        }

        public Image getImage() {
            return null;
        }

        public DBSObject getObject() {
            return this.entity;
        }
    }
}

