/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks.ui;

import com.dbeaver.ee.tasks.CompositeTaskSettings;
import com.dbeaver.ee.tasks.ui.CompositeTaskWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskReference;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTaskTransfer;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksSelectorDialog;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksTree;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class CompositeTaskWizardPageSettings
extends ActiveWizardPage<CompositeTaskWizard> {
    private final Image createTaskIcon = ActionUtils.findCommandImage((String)"org.jkiss.dbeaver.task.create").createImage();
    private final Image deleteTaskIcon = ActionUtils.findCommandImage((String)"org.eclipse.ui.edit.delete").createImage();
    private final Image editTaskIcon = ActionUtils.findCommandImage((String)"org.jkiss.dbeaver.task.edit").createImage();
    private TreeViewer taskViewer;
    private final List<CompositeTaskSettings.TaskReference> tasks = new ArrayList<CompositeTaskSettings.TaskReference>();
    private Runnable actionUpdater;
    private Button ignoreErrorCheck;

    CompositeTaskWizardPageSettings(CompositeTaskWizard wizard) {
        super("Composite task");
        this.setTitle("Composite task settings");
        this.setDescription("Configure composite task contents");
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.createTaskIcon);
        UIUtils.dispose((Resource)this.deleteTaskIcon);
        super.dispose();
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public void createControl(Composite parent) {
        CompositeTaskSettings compSettings = ((CompositeTaskWizard)this.getWizard()).getSettings();
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group tasksGroup = UIUtils.createControlGroup((Composite)composite, (String)"Tasks", (int)2, (int)1808, (int)0);
        this.taskViewer = new TreeViewer((Composite)tasksGroup, 67586);
        final Tree tree = this.taskViewer.getTree();
        tree.setHeaderVisible(true);
        UIUtils.createTreeColumn((Tree)tree, (int)16384, (String)"Task");
        UIUtils.createTreeColumn((Tree)tree, (int)131072, (String)"Type");
        tree.setLayoutData((Object)new GridData(1808));
        ToolBar buttonsToolbar = new ToolBar((Composite)tasksGroup, 512);
        buttonsToolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Add existing task", (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseTasksSelectorDialog dialog = new DatabaseTasksSelectorDialog(CompositeTaskWizardPageSettings.this.getShell());
                if (dialog.open() == 0) {
                    CompositeTaskWizardPageSettings.this.addTasksToTable(-1, dialog.getSelectedTasks());
                }
            }
        });
        UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Create and add new task", (Image)this.createTaskIcon, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskConfigurationWizardDialog dialog = new TaskConfigurationWizardDialog(UIUtils.getActiveWorkbenchWindow());
                dialog.setModal(false);
                dialog.setSelectorMode(true);
                if (dialog.open() == 0) {
                    CompositeTaskWizardPageSettings.this.addTasksToTable(-1, Collections.singletonList(dialog.getTask()));
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar, (int)256);
        ToolItem editItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Edit task", (Image)this.editTaskIcon, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Object[] items = ((IStructuredSelection)CompositeTaskWizardPageSettings.this.taskViewer.getSelection()).toArray();
                    if (items.length == 0) {
                        return;
                    }
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item instanceof DBTTaskReference) {
                            DBTTask task = ((DBTTaskReference)item).getTask();
                            TaskConfigurationWizard wizard = TaskUIRegistry.getInstance().createConfigurator(task.getType()).createTaskConfigWizard(task);
                            if (wizard != null) {
                                TaskConfigurationWizardDialog dialog = new TaskConfigurationWizardDialog(UIUtils.getActiveWorkbenchWindow(), wizard);
                                dialog.setEditMode(true);
                                dialog.open();
                            }
                        }
                        ++n2;
                    }
                }
                catch (Throwable e2) {
                    DBWorkbench.getPlatformUI().showError("Task configuration", "Error opening task configuration editor", e2);
                }
            }
        });
        ToolItem deleteItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Remove task from composite", (Image)this.deleteTaskIcon, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items = ((IStructuredSelection)CompositeTaskWizardPageSettings.this.taskViewer.getSelection()).toArray();
                if (!UIUtils.confirmAction((Shell)CompositeTaskWizardPageSettings.this.getShell(), (String)"Remove tasks", (String)("Are you sure you want to remove " + items.length + " task(s) from composite task?"))) {
                    return;
                }
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof CompositeTaskSettings.TaskReference) {
                        CompositeTaskWizardPageSettings.this.removeTaskFromTable((CompositeTaskSettings.TaskReference)item);
                    }
                    ++n2;
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar, (int)256);
        ToolItem moveUpItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Move task up", (DBPImage)UIIcon.ARROW_UP, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = CompositeTaskWizardPageSettings.this.getSelectedTaskIndex();
                if (selectionIndex > 0) {
                    CompositeTaskSettings.TaskReference prevTask = (CompositeTaskSettings.TaskReference)CompositeTaskWizardPageSettings.this.tasks.get(selectionIndex - 1);
                    CompositeTaskWizardPageSettings.this.tasks.set(selectionIndex - 1, (CompositeTaskSettings.TaskReference)CompositeTaskWizardPageSettings.this.tasks.get(selectionIndex));
                    CompositeTaskWizardPageSettings.this.tasks.set(selectionIndex, prevTask);
                    CompositeTaskWizardPageSettings.this.refreshTasks();
                }
            }
        });
        ToolItem moveDownItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)"Move task down", (DBPImage)UIIcon.ARROW_DOWN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = CompositeTaskWizardPageSettings.this.getSelectedTaskIndex();
                if (selectionIndex < tree.getItemCount() - 1) {
                    CompositeTaskSettings.TaskReference nextTask = (CompositeTaskSettings.TaskReference)CompositeTaskWizardPageSettings.this.tasks.get(selectionIndex + 1);
                    CompositeTaskWizardPageSettings.this.tasks.set(selectionIndex + 1, (CompositeTaskSettings.TaskReference)CompositeTaskWizardPageSettings.this.tasks.get(selectionIndex));
                    CompositeTaskWizardPageSettings.this.tasks.set(selectionIndex, nextTask);
                    CompositeTaskWizardPageSettings.this.refreshTasks();
                }
            }
        });
        deleteItem.setEnabled(false);
        moveUpItem.setEnabled(false);
        moveDownItem.setEnabled(false);
        this.actionUpdater = () -> {
            int selectionIndex = this.getSelectedTaskIndex();
            deleteItem.setEnabled(selectionIndex != -1);
            editItem.setEnabled(selectionIndex != -1);
            moveUpItem.setEnabled(selectionIndex > 0);
            moveDownItem.setEnabled(selectionIndex < tree.getItemCount() - 1);
        };
        this.taskViewer.addSelectionChangedListener(event -> this.actionUpdater.run());
        this.taskViewer.getControl().addPaintListener(e -> {
            if (tree.getItemCount() == 0) {
                UIUtils.drawMessageOverControl((Control)this.taskViewer.getControl(), (PaintEvent)e, (String)"You can drag-and-drop tasks here from tasks view", (int)0);
            }
        });
        this.addDragAndDropSupport();
        this.taskViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() instanceof CompositeTaskSettings.TaskReference) {
                    CompositeTaskSettings.TaskReference task = (CompositeTaskSettings.TaskReference)cell.getElement();
                    if (task.getTask().getType().getIcon() != null) {
                        if (cell.getColumnIndex() == 0) {
                            cell.setText(task.getTask().getName());
                            cell.setImage(DBeaverIcons.getImage((DBPImage)task.getTask().getType().getIcon()));
                        } else {
                            cell.setText(task.getTask().getType().getName());
                        }
                    }
                    if (!CompositeTaskWizardPageSettings.this.tasks.contains(task)) {
                        cell.setForeground(CompositeTaskWizardPageSettings.this.getShell().getDisplay().getSystemColor(18));
                    }
                }
            }
        });
        this.taskViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                DBTTask curTask;
                if (parentElement instanceof List) {
                    return ((List)parentElement).toArray();
                }
                if (parentElement instanceof CompositeTaskSettings.TaskReference && (curTask = ((CompositeTaskSettings.TaskReference)parentElement).getTask()).getType().getId().equals("composite")) {
                    CompositeTaskSettings childSettings = new CompositeTaskSettings();
                    childSettings.loadConfiguration(((CompositeTaskWizard)CompositeTaskWizardPageSettings.this.getWizard()).getRunnableContext(), curTask.getProperties());
                    return childSettings.getTasks().toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof CompositeTaskSettings.TaskReference) {
                    return ((CompositeTaskSettings.TaskReference)element).getTask().getType().getId().equals("composite");
                }
                return false;
            }
        });
        this.tasks.addAll(compSettings.getTasks());
        this.taskViewer.setInput(this.tasks);
        Composite settingsComposite = UIUtils.createComposite((Composite)composite, (int)2);
        settingsComposite.setLayoutData((Object)new GridData(768));
        Composite runSettingsComposite = UIUtils.createComposite((Composite)settingsComposite, (int)1);
        runSettingsComposite.setLayoutData((Object)new GridData(768));
        this.ignoreErrorCheck = UIUtils.createCheckbox((Composite)runSettingsComposite, (String)"Ignore task error", (String)"Whenever any contained task fails just ignore (and log) the error and proceed to the next task.", (boolean)compSettings.isIgnoreErrors(), (int)1);
        Composite taskSettingsComposite = UIUtils.createComposite((Composite)settingsComposite, (int)1);
        taskSettingsComposite.setLayoutData((Object)new GridData(128));
        ((CompositeTaskWizard)this.getWizard()).createTaskSaveButtons(taskSettingsComposite, true, 1);
        this.setControl((Control)composite);
    }

    public void activatePage() {
        this.refreshTasks();
    }

    private int getSelectedTaskIndex() {
        Tree tree = this.taskViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return -1;
        }
        TreeItem selectedItem = selection[0];
        if (selectedItem.getParentItem() != null) {
            return -1;
        }
        return tree.indexOf(selectedItem);
    }

    private void addTasksToTable(int atIndex, List<DBTTask> newTasks) {
        for (DBTTask task : newTasks) {
            if (this.isContainedBy(task)) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)"Cannot add task", (String)("Task '" + task.getName() + "' cannot be added - it is owner task for " + ((CompositeTaskWizard)this.getWizard()).getCurrentTask().getName()), (int)1);
                continue;
            }
            CompositeTaskSettings.TaskReference taskReference = new CompositeTaskSettings.TaskReference();
            taskReference.setTask(task);
            if (atIndex >= 0) {
                this.tasks.add(atIndex, taskReference);
                ++atIndex;
                continue;
            }
            this.tasks.add(taskReference);
        }
        this.refreshTasks();
        this.updateState();
    }

    private boolean isContainedBy(DBTTask task) {
        DBTTask currentTask = ((CompositeTaskWizard)this.getWizard()).getCurrentTask();
        return task == currentTask;
    }

    private void removeTaskFromTable(CompositeTaskSettings.TaskReference task) {
        if (this.tasks.remove(task)) {
            this.refreshTasks();
            this.updateState();
        }
    }

    private void refreshTasks() {
        this.taskViewer.refresh();
        this.actionUpdater.run();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.taskViewer.getTree(), (boolean)true, null));
    }

    public void saveState() {
        CompositeTaskSettings settings = ((CompositeTaskWizard)this.getWizard()).getSettings();
        settings.setIgnoreErrors(this.ignoreErrorCheck.getSelection());
        settings.setTasks(new ArrayList<CompositeTaskSettings.TaskReference>(this.tasks));
    }

    protected void updateState() {
        this.saveState();
        this.actionUpdater.run();
        this.getContainer().updateButtons();
    }

    public void addDragAndDropSupport() {
        DatabaseTasksTree.addDragSourceSupport((Viewer)this.taskViewer, this.tasks::contains);
        DropTarget dropTarget = new DropTarget(this.taskViewer.getControl(), 2);
        dropTarget.setTransfer(new Transfer[]{DatabaseTaskTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){
            private TreeItem dropItem;

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    this.moveTasks(event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = this.isDropSupported(event) ? 2 : 0;
                event.feedback = 1;
                Point dragPoint = CompositeTaskWizardPageSettings.this.getShell().getDisplay().map(null, CompositeTaskWizardPageSettings.this.taskViewer.getControl(), new Point(event.x, event.y));
                this.dropItem = CompositeTaskWizardPageSettings.this.taskViewer.getTree().getItem(dragPoint);
                while (this.dropItem != null && this.dropItem.getParentItem() != null) {
                    this.dropItem = this.dropItem.getParentItem();
                }
            }

            private boolean isDropSupported(DropTargetEvent event) {
                return DatabaseTaskTransfer.getInstance().isSupportedType(event.currentDataType);
            }

            private void moveTasks(DropTargetEvent event) {
                if (DatabaseTaskTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof DatabaseTaskTransfer.Data) {
                    DatabaseTaskTransfer.Data taskData = (DatabaseTaskTransfer.Data)event.data;
                    boolean sameControl = taskData.getSourceControl() == CompositeTaskWizardPageSettings.this.taskViewer.getControl();
                    ArrayList droppedTasks = new ArrayList(taskData.getTasks());
                    if (sameControl) {
                        if (this.dropItem != null) {
                            int curIndex = CompositeTaskWizardPageSettings.this.taskViewer.getTree().indexOf(this.dropItem);
                            ArrayList<CompositeTaskSettings.TaskReference> taskToMove = new ArrayList<CompositeTaskSettings.TaskReference>();
                            block0: for (DBTTask task : droppedTasks) {
                                for (CompositeTaskSettings.TaskReference tr : CompositeTaskWizardPageSettings.this.tasks) {
                                    if (task != tr.getTask()) continue;
                                    taskToMove.add(tr);
                                    continue block0;
                                }
                            }
                            CompositeTaskWizardPageSettings.this.tasks.removeAll(taskToMove);
                            CompositeTaskWizardPageSettings.this.tasks.addAll(curIndex >= 0 && curIndex <= CompositeTaskWizardPageSettings.this.tasks.size() ? curIndex : CompositeTaskWizardPageSettings.this.tasks.size(), taskToMove);
                            CompositeTaskWizardPageSettings.this.refreshTasks();
                        }
                    } else {
                        CompositeTaskWizardPageSettings.this.addTasksToTable(this.dropItem == null ? -1 : CompositeTaskWizardPageSettings.this.taskViewer.getTree().indexOf(this.dropItem), droppedTasks);
                    }
                }
            }
        });
    }
}

