/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.sched.ui;

import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseTitleDialog;
import org.jkiss.utils.CommonUtils;

public class ScheduleTaskDialog
extends BaseTitleDialog {
    private static final List<Integer> CRON_TYPE_MINUTELY_FREQUENCIES = Arrays.asList(1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30);
    private static final List<Integer> CRON_TYPE_HOURLY_FREQUENCIES = Arrays.asList(1, 2, 3, 4, 6, 8, 12);
    private final DBTTask task;
    private final DBTScheduler scheduler;
    private final DBTTaskScheduleConfiguration configuration;
    private final boolean isUpdate;
    private Group settingsGroup;
    private List<Button> frequencyButtons = new ArrayList<Button>();
    private List<Button> monthButtons = new ArrayList<Button>();
    private List<Button> dayButtons = new ArrayList<Button>();
    private List<Button> weekDayButtons = new ArrayList<Button>();
    private DateTime[] startDatePickers;
    private Spinner recurSpinner;
    private Combo recurCombo;
    private Spinner executionMinuteSpinner;
    private static final Map<DBTTaskScheduleConfiguration.Frequency, String> FREQUENCY_FEATURE_MAP;

    static {
        HashMap<DBTTaskScheduleConfiguration.Frequency, String> map = new HashMap<DBTTaskScheduleConfiguration.Frequency, String>(DBTTaskScheduleConfiguration.Frequency.values().length, 1.0f);
        map.put(DBTTaskScheduleConfiguration.Frequency.MINUTELY, "frequency.minutely");
        map.put(DBTTaskScheduleConfiguration.Frequency.HOURLY, "frequency.hourly");
        map.put(DBTTaskScheduleConfiguration.Frequency.DAILY, "frequency.daily");
        map.put(DBTTaskScheduleConfiguration.Frequency.WEEKLY, "frequency.weekly");
        map.put(DBTTaskScheduleConfiguration.Frequency.MONTHLY, "frequency.monthly");
        map.put(DBTTaskScheduleConfiguration.Frequency.ONE_TIME, "frequency.onetime");
        map.put(DBTTaskScheduleConfiguration.Frequency.EVENT, "frequency.event");
        FREQUENCY_FEATURE_MAP = Collections.unmodifiableMap(map);
    }

    public ScheduleTaskDialog(Shell parentShell, DBTTask task, DBTScheduler scheduler, DBTTaskScheduleConfiguration configuration, boolean isUpdate) {
        super(parentShell, (DBPImage)DBIcon.TREE_TASK);
        this.task = task;
        this.scheduler = scheduler;
        this.configuration = configuration;
        this.isUpdate = isUpdate;
    }

    public DBTTaskScheduleConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite schedComp = UIUtils.createComposite((Composite)dialogArea, (int)2);
        Combo schedulerCombo = UIUtils.createLabelCombo((Composite)schedComp, (String)"Scheduler", (int)12);
        schedulerCombo.setLayoutData((Object)new GridData(32));
        schedulerCombo.setEnabled(false);
        schedulerCombo.add(this.scheduler.getSchedulerName());
        schedulerCombo.select(0);
        Composite main = UIUtils.createComposite((Composite)dialogArea, (int)2);
        main.setLayoutData((Object)new GridData(1808));
        Group frequencyGroup = UIUtils.createControlGroup((Composite)main, (String)"Frequency", (int)1, (int)1040, (int)0);
        DBTTaskScheduleConfiguration.Frequency[] frequencyArray = DBTTaskScheduleConfiguration.Frequency.values();
        int n = frequencyArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBTTaskScheduleConfiguration.Frequency frequency = frequencyArray[n2];
            if (this.scheduler.supportsFeature(FREQUENCY_FEATURE_MAP.get(frequency))) {
                Button fb = UIUtils.createRadioButton((Composite)frequencyGroup, (String)CommonUtils.toCamelCase((String)frequency.name()).replace('_', ' '), (Object)frequency, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DBTTaskScheduleConfiguration.Frequency newFrequency = (DBTTaskScheduleConfiguration.Frequency)e.widget.getData();
                        if (newFrequency == ((ScheduleTaskDialog)ScheduleTaskDialog.this).configuration.frequency) {
                            return;
                        }
                        ScheduleTaskDialog.this.changeFrequency(newFrequency, true);
                    }
                });
                if (frequency == this.configuration.frequency) {
                    fb.setSelection(true);
                }
                this.frequencyButtons.add(fb);
            }
            ++n2;
        }
        this.settingsGroup = UIUtils.createControlGroup((Composite)main, (String)"Settings", (int)2, (int)1808, (int)0);
        this.changeFrequency(this.configuration.frequency, false);
        this.getShell().setText("Schedule task '" + this.task.getName() + "'");
        this.setTitle("Scheduler parameters");
        this.setMessage("Set task '" + this.task.getName() + "' scheduler parameters");
        return dialogArea;
    }

    public void create() {
        super.create();
        if (!this.isUpdate) {
            this.configuration.frequency = DBTTaskScheduleConfiguration.Frequency.WEEKLY;
        }
        for (Button fb : this.frequencyButtons) {
            fb.setSelection(fb.getData() == this.configuration.frequency);
        }
        this.changeFrequency(this.configuration.frequency, true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.isUpdate ? "Update" : "Schedule", true).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void changeFrequency(DBTTaskScheduleConfiguration.Frequency frequency, boolean reset) {
        this.configuration.frequency = frequency;
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, 100);
        Calendar startDateCal = GregorianCalendar.getInstance();
        if (this.configuration.startTime == null) {
            startDateCal.setTime(new Date());
        } else {
            startDateCal.setTime(this.configuration.startTime);
        }
        Calendar endDateCal = GregorianCalendar.getInstance();
        endDateCal.setTime(new Date());
        endDateCal.add(1, 100);
        int repInterval = this.configuration.recurrence;
        String unitName = "";
        switch (frequency) {
            case MINUTELY: {
                unitName = "minutes";
                if (this.isUpdate && !reset) break;
                repInterval = 20;
                break;
            }
            case HOURLY: {
                unitName = "hours";
                if (this.isUpdate && !reset) break;
                repInterval = 2;
                break;
            }
            case DAILY: {
                unitName = "days";
                if (this.isUpdate && !reset) break;
                repInterval = 1;
                break;
            }
            case WEEKLY: {
                unitName = "weeks";
                if (this.isUpdate && !reset) break;
                repInterval = 1;
                break;
            }
            case MONTHLY: {
                unitName = "months";
                if (this.isUpdate && !reset) break;
                repInterval = 1;
            }
        }
        UIUtils.disposeChildControls((Composite)this.settingsGroup);
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleTaskDialog.this.updateButtons();
            }
        };
        boolean hasMonths = frequency == DBTTaskScheduleConfiguration.Frequency.MONTHLY;
        boolean hasWeekDays = frequency == DBTTaskScheduleConfiguration.Frequency.WEEKLY;
        boolean isStartDateSupported = this.isStartDateSupported(frequency);
        boolean isStartTimeSupported = this.isStartTimeSupported(frequency);
        if (isStartDateSupported || isStartTimeSupported) {
            UIUtils.createControlLabel((Composite)this.settingsGroup, (String)"Start time");
            Composite startTimeComposite = UIUtils.createComposite((Composite)this.settingsGroup, (int)2);
            startTimeComposite.setLayoutData((Object)new GridData(768));
            DateTime[] dateTimeArray = this.startDatePickers = this.createDatePickers(startTimeComposite, startDateCal, isStartDateSupported, isStartTimeSupported);
            int n = this.startDatePickers.length;
            int n2 = 0;
            while (n2 < n) {
                DateTime dateTime = dateTimeArray[n2];
                if (dateTime != null) {
                    dateTime.addSelectionListener((SelectionListener)selListener);
                }
                ++n2;
            }
        }
        if (this.hasRecurrence(frequency)) {
            new Label((Composite)this.settingsGroup, 0).setText("Recur every");
            Composite recurComposite = UIUtils.createComposite((Composite)this.settingsGroup, (int)2);
            if (this.isFrequencyComboSupported(frequency)) {
                this.recurCombo = new Combo(recurComposite, 2056);
                int idx = -1;
                List<Integer> supportedRecurrences = frequency == DBTTaskScheduleConfiguration.Frequency.MINUTELY ? CRON_TYPE_MINUTELY_FREQUENCIES : CRON_TYPE_HOURLY_FREQUENCIES;
                int i = 0;
                while (i < supportedRecurrences.size()) {
                    int recur = supportedRecurrences.get(i);
                    this.recurCombo.add(Integer.toString(recur));
                    if (recur == this.configuration.recurrence) {
                        idx = i;
                    }
                    ++i;
                }
                if (idx == -1) {
                    this.recurCombo.select(0);
                } else {
                    this.recurCombo.select(idx);
                }
                this.recurCombo.addSelectionListener((SelectionListener)selListener);
            } else {
                this.recurSpinner = new Spinner(recurComposite, 2048);
                this.recurSpinner.setMinimum(1);
                this.recurSpinner.setMaximum(Integer.MAX_VALUE);
                this.recurSpinner.setSelection(repInterval);
                this.recurSpinner.addSelectionListener((SelectionListener)selListener);
            }
            new Label(recurComposite, 0).setText(unitName);
        }
        if (this.scheduler.supportsFeature("frequency.hourly.executionMinute") && frequency == DBTTaskScheduleConfiguration.Frequency.HOURLY) {
            new Label((Composite)this.settingsGroup, 0).setText("Execution minute:");
            Composite executionMinuteComposite = UIUtils.createComposite((Composite)this.settingsGroup, (int)2);
            this.executionMinuteSpinner = new Spinner(executionMinuteComposite, 2048);
            this.executionMinuteSpinner.setSelection(this.configuration.executionMinute);
            this.executionMinuteSpinner.addSelectionListener((SelectionListener)selListener);
        }
        if (hasMonths) {
            this.createGroupLabel((Composite)this.settingsGroup, "Months");
            Composite monthDaysComposite = UIUtils.createComposite((Composite)this.settingsGroup, (int)3);
            monthDaysComposite.setLayoutData((Object)new GridData(770));
            Composite monthsComposite = new Composite(monthDaysComposite, 0);
            monthsComposite.setLayoutData((Object)new GridData(2));
            monthsComposite.setLayout((Layout)new GridLayout(2, false));
            this.monthButtons.clear();
            int i = 0;
            while (i < 6) {
                int k = 0;
                while (k < 2) {
                    int monthNum = i + k * 6;
                    calendar.set(2, monthNum);
                    String monthName = calendar.getDisplayName(2, 2, Locale.getDefault());
                    Button monthCheck = new Button(monthsComposite, 32);
                    monthCheck.setText(monthName);
                    monthCheck.setData((Object)monthNum);
                    monthCheck.setSelection(this.configuration.months != null && this.configuration.months.contains((short)monthNum));
                    monthCheck.addSelectionListener((SelectionListener)selListener);
                    this.monthButtons.add(monthCheck);
                    ++k;
                }
                ++i;
            }
            final Button allMothsCheck = new Button(monthsComposite, 32);
            allMothsCheck.setText("<All months>");
            allMothsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean check = allMothsCheck.getSelection();
                    for (Button btn : ScheduleTaskDialog.this.monthButtons) {
                        btn.setSelection(check);
                    }
                    ScheduleTaskDialog.this.updateButtons();
                }
            });
            this.createGroupLabel(monthDaysComposite, "Days");
            Composite daysComposite = new Composite(monthDaysComposite, 0);
            daysComposite.setLayout((Layout)new GridLayout(4, false));
            this.dayButtons.clear();
            int daysPerColumn = 8;
            int colCount = 4;
            int i2 = 0;
            while (i2 < daysPerColumn) {
                int k = 0;
                while (k < colCount) {
                    int dayNum = i2 + k * daysPerColumn + 1;
                    if (dayNum < 33 && (dayNum != 32 || this.scheduler.supportsFeature("frequency.monthly.last_day"))) {
                        Button dayCheck = new Button(daysComposite, 32);
                        dayCheck.setText(dayNum == 32 ? "Last" : String.valueOf(dayNum));
                        dayCheck.setData((Object)dayNum);
                        dayCheck.setSelection(this.configuration.days != null && this.configuration.days.contains((short)dayNum));
                        dayCheck.addSelectionListener((SelectionListener)selListener);
                        this.dayButtons.add(dayCheck);
                    }
                    ++k;
                }
                ++i2;
            }
        }
        if (hasWeekDays) {
            this.createGroupLabel((Composite)this.settingsGroup, "Week days");
            Composite monthsComposite = new Composite((Composite)this.settingsGroup, 0);
            monthsComposite.setLayout((Layout)new GridLayout(3, false));
            this.weekDayButtons.clear();
            int i = 0;
            while (i < 3) {
                int k = 0;
                while (k < 3) {
                    int dayNum = i + k * 3 + 1;
                    if (dayNum > 7) {
                        new Label(monthsComposite, 0);
                    } else {
                        calendar.set(7, dayNum);
                        String dayName = calendar.getDisplayName(7, 2, Locale.getDefault());
                        Button wdCheck = new Button(monthsComposite, 32);
                        wdCheck.setText(dayName);
                        wdCheck.setData((Object)dayNum);
                        wdCheck.setSelection(this.configuration.days != null && this.configuration.days.contains((short)dayNum));
                        wdCheck.addSelectionListener((SelectionListener)selListener);
                        this.weekDayButtons.add(wdCheck);
                    }
                    ++k;
                }
                ++i;
            }
        }
        this.settingsGroup.getParent().layout(true, true);
        this.updateButtons();
    }

    private boolean isFrequencyComboSupported(DBTTaskScheduleConfiguration.Frequency frequency) {
        switch (frequency) {
            case MINUTELY: 
            case HOURLY: {
                return this.scheduler.getRecurrenceType() == DBTScheduler.RecurrenceType.Cron;
            }
        }
        return false;
    }

    private boolean isStartDateSupported(DBTTaskScheduleConfiguration.Frequency frequency) {
        switch (frequency) {
            case MINUTELY: {
                return this.scheduler.supportsFeature("frequency.minutely.startDatetime");
            }
            case HOURLY: {
                return this.scheduler.supportsFeature("frequency.hourly.startDatetime");
            }
            case DAILY: {
                return this.scheduler.supportsFeature("frequency.daily.startDate");
            }
            case MONTHLY: {
                return this.scheduler.supportsFeature("frequency.weekly.startDate");
            }
            case ONE_TIME: {
                return this.scheduler.supportsFeature("frequency.onetime.startDatetime");
            }
            case EVENT: {
                return true;
            }
        }
        return false;
    }

    private boolean isStartTimeSupported(DBTTaskScheduleConfiguration.Frequency frequency) {
        switch (frequency) {
            case MINUTELY: {
                return this.scheduler.supportsFeature("frequency.minutely.startDatetime");
            }
            case HOURLY: {
                return this.scheduler.supportsFeature("frequency.hourly.startDatetime");
            }
            case ONE_TIME: {
                return this.scheduler.supportsFeature("frequency.onetime.startDatetime");
            }
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case EVENT: {
                return true;
            }
        }
        return false;
    }

    private boolean hasRecurrence(DBTTaskScheduleConfiguration.Frequency frequency) {
        switch (frequency) {
            case WEEKLY: {
                return this.scheduler.supportsFeature("frequency.weekly.recurrence");
            }
            case DAILY: {
                return this.scheduler.supportsFeature("frequency.daily.recurrence");
            }
            case MONTHLY: 
            case ONE_TIME: {
                return false;
            }
        }
        return true;
    }

    private DateTime[] createDatePickers(Composite startTimeComposite, Calendar startDateCal, boolean createStartDate, boolean createStartTime) {
        DateTime datePicker = null;
        DateTime timePicker = null;
        if (createStartDate) {
            datePicker = new DateTime(startTimeComposite, 65568);
            datePicker.setDate(startDateCal.get(1), startDateCal.get(2), startDateCal.get(5));
        }
        if (createStartTime) {
            timePicker = new DateTime(startTimeComposite, 65664);
            timePicker.setTime(startDateCal.get(11), startDateCal.get(12), startDateCal.get(13));
        }
        return new DateTime[]{datePicker, timePicker};
    }

    private void createGroupLabel(Composite monthDaysComposite, String days) {
        Composite monthLabelComposite = new Composite(monthDaysComposite, 0);
        monthLabelComposite.setLayoutData((Object)new GridData(2));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        monthLabelComposite.setLayout((Layout)gl);
        UIUtils.createControlLabel((Composite)monthLabelComposite, (String)days);
    }

    private void updateButtons() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.isValidConfiguration());
        }
    }

    private boolean isValidConfiguration() {
        boolean isValid = false;
        this.configuration.days = new ArrayList();
        this.configuration.months = new ArrayList();
        this.configuration.recurrence = 0;
        this.configuration.repetitionInterval = 0;
        Calendar cl = GregorianCalendar.getInstance();
        if (this.startDatePickers != null) {
            if (this.startDatePickers[0] != null && !this.startDatePickers[1].isDisposed()) {
                cl.set(1, this.startDatePickers[0].getYear());
                cl.set(2, this.startDatePickers[0].getMonth());
                cl.set(5, this.startDatePickers[0].getDay());
            }
            if (this.startDatePickers[1] != null && !this.startDatePickers[1].isDisposed()) {
                cl.set(11, this.startDatePickers[1].getHours());
                cl.set(12, this.startDatePickers[1].getMinutes());
                cl.set(13, this.startDatePickers[1].getSeconds());
            }
        }
        this.configuration.startTime = cl.getTime();
        switch (this.configuration.frequency) {
            case MINUTELY: {
                if (this.isFrequencyComboSupported(this.configuration.frequency)) {
                    isValid = true;
                    this.configuration.recurrence = CommonUtils.toInt((Object)this.recurCombo.getText());
                    break;
                }
                this.configuration.recurrence = this.recurSpinner.getSelection();
                if (this.scheduler.supportsFeature("frequency.minutely.recurrence.greaterThan59")) {
                    isValid = this.configuration.recurrence > 0;
                    break;
                }
                isValid = this.configuration.recurrence > 0 && this.configuration.recurrence < 60;
                break;
            }
            case HOURLY: {
                this.configuration.recurrence = this.isFrequencyComboSupported(this.configuration.frequency) ? CommonUtils.toInt((Object)this.recurCombo.getText()) : this.recurSpinner.getSelection();
                if (this.scheduler.supportsFeature("frequency.hourly.executionMinute")) {
                    this.configuration.executionMinute = this.executionMinuteSpinner.getSelection();
                    isValid = this.configuration.executionMinute > -1 && this.configuration.executionMinute < 60 && this.configuration.recurrence > 0;
                    break;
                }
                isValid = this.configuration.recurrence > 0;
                break;
            }
            case DAILY: {
                this.configuration.recurrence = this.scheduler.supportsFeature("frequency.daily.recurrence") ? this.recurSpinner.getSelection() : 1;
                isValid = this.configuration.recurrence > 0;
                break;
            }
            case WEEKLY: {
                this.configuration.days = new ArrayList();
                for (Button btn : this.weekDayButtons) {
                    if (!btn.getSelection()) continue;
                    this.configuration.days.add(((Number)btn.getData()).shortValue());
                }
                boolean bl = isValid = !this.configuration.days.isEmpty();
                if (!this.scheduler.supportsFeature("frequency.weekly.recurrence")) break;
                this.configuration.recurrence = this.recurSpinner.getSelection();
                if (this.configuration.recurrence > 0) break;
                isValid = false;
                break;
            }
            case MONTHLY: {
                for (Button btn : this.dayButtons) {
                    if (!btn.getSelection()) continue;
                    this.configuration.days.add(((Number)btn.getData()).shortValue());
                }
                for (Button btn : this.monthButtons) {
                    if (!btn.getSelection()) continue;
                    this.configuration.months.add(((Number)btn.getData()).shortValue());
                }
                isValid = this.isMonthsAndDaysCombinationValid(this.configuration.days, this.configuration.months);
                break;
            }
            case ONE_TIME: {
                isValid = this.configuration.startTime.toInstant().atZone(ZoneId.systemDefault()).isAfter(ZonedDateTime.now());
                break;
            }
        }
        return isValid;
    }

    private boolean isMonthsAndDaysCombinationValid(List<Short> days, List<Short> months) {
        if (days.isEmpty() || months.isEmpty()) {
            return false;
        }
        for (short d : days) {
            if (d != 32 && d != 33) continue;
            return true;
        }
        int maxSupportedDay = 0;
        for (short m : months) {
            int maxLength = Month.of(m + 1).maxLength();
            if (maxLength <= maxSupportedDay) continue;
            maxSupportedDay = maxLength;
        }
        for (short d : days) {
            if (d <= maxSupportedDay) continue;
            return false;
        }
        return true;
    }

    protected void okPressed() {
        try {
            this.scheduler.setTaskSchedule(this.task, this.configuration);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Schedule error", "Error " + (this.isUpdate ? "updating" : "scheduling") + " task '" + this.task.getName() + "'", (Throwable)e);
            return;
        }
        super.okPressed();
    }
}

