/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.stubbing.answers.InvocationInfo;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.ValidableAnswer;

public class ReturnsArgumentAt
implements Answer<Object>,
ValidableAnswer,
Serializable {
    private static final long serialVersionUID = -589315085166295101L;
    public static final int LAST_ARGUMENT = -1;
    private final int wantedArgumentPosition;

    public ReturnsArgumentAt(int wantedArgumentPosition) {
        if (wantedArgumentPosition != -1 && wantedArgumentPosition < 0) {
            throw Reporter.invalidArgumentRangeAtIdentityAnswerCreationTime();
        }
        this.wantedArgumentPosition = wantedArgumentPosition;
    }

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        int argumentPosition = this.inferWantedArgumentPosition(invocation);
        this.validateIndexWithinInvocationRange(invocation, argumentPosition);
        if (this.wantedArgIndexIsVarargAndSameTypeAsReturnType(invocation.getMethod(), argumentPosition)) {
            return ((Invocation)invocation).getRawArguments()[argumentPosition];
        }
        return invocation.getArgument(argumentPosition);
    }

    @Override
    public void validateFor(InvocationOnMock invocation) {
        int argumentPosition = this.inferWantedArgumentPosition(invocation);
        this.validateIndexWithinInvocationRange(invocation, argumentPosition);
        this.validateArgumentTypeCompatibility(invocation, argumentPosition);
    }

    private int inferWantedArgumentPosition(InvocationOnMock invocation) {
        return this.wantedArgumentPosition == -1 ? invocation.getArguments().length - 1 : this.wantedArgumentPosition;
    }

    private void validateIndexWithinInvocationRange(InvocationOnMock invocation, int argumentPosition) {
        if (!this.wantedArgumentPositionIsValidForInvocation(invocation, argumentPosition)) {
            throw Reporter.invalidArgumentPositionRangeAtInvocationTime(invocation, this.wantedArgumentPosition == -1, this.wantedArgumentPosition);
        }
    }

    private void validateArgumentTypeCompatibility(InvocationOnMock invocation, int argumentPosition) {
        InvocationInfo invocationInfo = new InvocationInfo(invocation);
        Class<?> inferredArgumentType = this.inferWantedArgumentType(invocation, argumentPosition);
        if (!invocationInfo.isValidReturnType(inferredArgumentType)) {
            throw Reporter.wrongTypeOfArgumentToReturn(invocation, invocationInfo.printMethodReturnType(), inferredArgumentType, this.wantedArgumentPosition);
        }
    }

    private boolean wantedArgIndexIsVarargAndSameTypeAsReturnType(Method method, int argumentPosition) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return method.isVarArgs() && argumentPosition == parameterTypes.length - 1 && method.getReturnType().isAssignableFrom(parameterTypes[argumentPosition]);
    }

    private boolean wantedArgumentPositionIsValidForInvocation(InvocationOnMock invocation, int argumentPosition) {
        if (argumentPosition < 0) {
            return false;
        }
        if (!invocation.getMethod().isVarArgs()) {
            return invocation.getArguments().length > argumentPosition;
        }
        return true;
    }

    private Class<?> inferWantedArgumentType(InvocationOnMock invocation, int argumentPosition) {
        Class<?>[] parameterTypes = invocation.getMethod().getParameterTypes();
        if (!invocation.getMethod().isVarArgs()) {
            return parameterTypes[argumentPosition];
        }
        int varargIndex = parameterTypes.length - 1;
        if (argumentPosition < varargIndex) {
            return parameterTypes[argumentPosition];
        }
        if (this.wantedArgIndexIsVarargAndSameTypeAsReturnType(invocation.getMethod(), argumentPosition)) {
            return parameterTypes[argumentPosition];
        }
        return parameterTypes[varargIndex].getComponentType();
    }
}

